/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The choice level additional resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalResources implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalResources.Builder, AdditionalResources> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AdditionalResources::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<ChoiceContent>> CONTENT_FIELD = SdkField
            .<List<ChoiceContent>> builder(MarshallingType.LIST)
            .memberName("Content")
            .getter(getter(AdditionalResources::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChoiceContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChoiceContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<ChoiceContent> content;

    private AdditionalResources(BuilderImpl builder) {
        this.type = builder.type;
        this.content = builder.content;
    }

    /**
     * <p>
     * Type of additional resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AdditionalResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of additional resource.
     * @see AdditionalResourceType
     */
    public final AdditionalResourceType type() {
        return AdditionalResourceType.fromValue(type);
    }

    /**
     * <p>
     * Type of additional resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AdditionalResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of additional resource.
     * @see AdditionalResourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The URLs for additional resources, either helpful resources or improvement plans. Up to five additional URLs can
     * be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The URLs for additional resources, either helpful resources or improvement plans. Up to five additional
     *         URLs can be specified.
     */
    public final List<ChoiceContent> content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalResources)) {
            return false;
        }
        AdditionalResources other = (AdditionalResources) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasContent() == other.hasContent()
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalResources").add("Type", typeAsString())
                .add("Content", hasContent() ? content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalResources, T> g) {
        return obj -> g.apply((AdditionalResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalResources> {
        /**
         * <p>
         * Type of additional resource.
         * </p>
         * 
         * @param type
         *        Type of additional resource.
         * @see AdditionalResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of additional resource.
         * </p>
         * 
         * @param type
         *        Type of additional resource.
         * @see AdditionalResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalResourceType
         */
        Builder type(AdditionalResourceType type);

        /**
         * <p>
         * The URLs for additional resources, either helpful resources or improvement plans. Up to five additional URLs
         * can be specified.
         * </p>
         * 
         * @param content
         *        The URLs for additional resources, either helpful resources or improvement plans. Up to five
         *        additional URLs can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<ChoiceContent> content);

        /**
         * <p>
         * The URLs for additional resources, either helpful resources or improvement plans. Up to five additional URLs
         * can be specified.
         * </p>
         * 
         * @param content
         *        The URLs for additional resources, either helpful resources or improvement plans. Up to five
         *        additional URLs can be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ChoiceContent... content);

        /**
         * <p>
         * The URLs for additional resources, either helpful resources or improvement plans. Up to five additional URLs
         * can be specified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceContent.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceContent#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceContent.Builder#build()} is called
         * immediately and its result is passed to {@link #content(List<ChoiceContent>)}.
         * 
         * @param content
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(java.util.Collection<ChoiceContent>)
         */
        Builder content(Consumer<ChoiceContent.Builder>... content);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<ChoiceContent> content = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalResources model) {
            type(model.type);
            content(model.content);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AdditionalResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<ChoiceContent.Builder> getContent() {
            List<ChoiceContent.Builder> result = UrlsCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<ChoiceContent.BuilderImpl> content) {
            this.content = UrlsCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<ChoiceContent> content) {
            this.content = UrlsCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(ChoiceContent... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<ChoiceContent.Builder>... content) {
            content(Stream.of(content).map(c -> ChoiceContent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AdditionalResources build() {
            return new AdditionalResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
