/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Discovery configuration associated to the workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadDiscoveryConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadDiscoveryConfig.Builder, WorkloadDiscoveryConfig> {
    private static final SdkField<String> TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrustedAdvisorIntegrationStatus")
            .getter(getter(WorkloadDiscoveryConfig::trustedAdvisorIntegrationStatusAsString))
            .setter(setter(Builder::trustedAdvisorIntegrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedAdvisorIntegrationStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trustedAdvisorIntegrationStatus;

    private WorkloadDiscoveryConfig(BuilderImpl builder) {
        this.trustedAdvisorIntegrationStatus = builder.trustedAdvisorIntegrationStatus;
    }

    /**
     * <p>
     * Discovery integration status in respect to Trusted Advisor for the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedAdvisorIntegrationStatus} will return
     * {@link TrustedAdvisorIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trustedAdvisorIntegrationStatusAsString}.
     * </p>
     * 
     * @return Discovery integration status in respect to Trusted Advisor for the workload.
     * @see TrustedAdvisorIntegrationStatus
     */
    public final TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus() {
        return TrustedAdvisorIntegrationStatus.fromValue(trustedAdvisorIntegrationStatus);
    }

    /**
     * <p>
     * Discovery integration status in respect to Trusted Advisor for the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedAdvisorIntegrationStatus} will return
     * {@link TrustedAdvisorIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trustedAdvisorIntegrationStatusAsString}.
     * </p>
     * 
     * @return Discovery integration status in respect to Trusted Advisor for the workload.
     * @see TrustedAdvisorIntegrationStatus
     */
    public final String trustedAdvisorIntegrationStatusAsString() {
        return trustedAdvisorIntegrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trustedAdvisorIntegrationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDiscoveryConfig)) {
            return false;
        }
        WorkloadDiscoveryConfig other = (WorkloadDiscoveryConfig) obj;
        return Objects.equals(trustedAdvisorIntegrationStatusAsString(), other.trustedAdvisorIntegrationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadDiscoveryConfig")
                .add("TrustedAdvisorIntegrationStatus", trustedAdvisorIntegrationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustedAdvisorIntegrationStatus":
            return Optional.ofNullable(clazz.cast(trustedAdvisorIntegrationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadDiscoveryConfig, T> g) {
        return obj -> g.apply((WorkloadDiscoveryConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadDiscoveryConfig> {
        /**
         * <p>
         * Discovery integration status in respect to Trusted Advisor for the workload.
         * </p>
         * 
         * @param trustedAdvisorIntegrationStatus
         *        Discovery integration status in respect to Trusted Advisor for the workload.
         * @see TrustedAdvisorIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedAdvisorIntegrationStatus
         */
        Builder trustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus);

        /**
         * <p>
         * Discovery integration status in respect to Trusted Advisor for the workload.
         * </p>
         * 
         * @param trustedAdvisorIntegrationStatus
         *        Discovery integration status in respect to Trusted Advisor for the workload.
         * @see TrustedAdvisorIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedAdvisorIntegrationStatus
         */
        Builder trustedAdvisorIntegrationStatus(TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String trustedAdvisorIntegrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadDiscoveryConfig model) {
            trustedAdvisorIntegrationStatus(model.trustedAdvisorIntegrationStatus);
        }

        public final String getTrustedAdvisorIntegrationStatus() {
            return trustedAdvisorIntegrationStatus;
        }

        public final void setTrustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus;
        }

        @Override
        public final Builder trustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus;
            return this;
        }

        @Override
        public final Builder trustedAdvisorIntegrationStatus(TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus(trustedAdvisorIntegrationStatus == null ? null : trustedAdvisorIntegrationStatus
                    .toString());
            return this;
        }

        @Override
        public WorkloadDiscoveryConfig build() {
            return new WorkloadDiscoveryConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
