/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The share invitation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareInvitation implements SdkPojo, Serializable, ToCopyableBuilder<ShareInvitation.Builder, ShareInvitation> {
    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationId").getter(getter(ShareInvitation::shareInvitationId))
            .setter(setter(Builder::shareInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()).build();

    private static final SdkField<String> SHARE_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareResourceType").getter(getter(ShareInvitation::shareResourceTypeAsString))
            .setter(setter(Builder::shareResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareResourceType").build()).build();

    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ShareInvitation::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(ShareInvitation::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(ShareInvitation::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_INVITATION_ID_FIELD,
            SHARE_RESOURCE_TYPE_FIELD, WORKLOAD_ID_FIELD, LENS_ALIAS_FIELD, LENS_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shareInvitationId;

    private final String shareResourceType;

    private final String workloadId;

    private final String lensAlias;

    private final String lensArn;

    private ShareInvitation(BuilderImpl builder) {
        this.shareInvitationId = builder.shareInvitationId;
        this.shareResourceType = builder.shareResourceType;
        this.workloadId = builder.workloadId;
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
    }

    /**
     * <p>
     * The ID assigned to the share invitation.
     * </p>
     * 
     * @return The ID assigned to the share invitation.
     */
    public final String shareInvitationId() {
        return shareInvitationId;
    }

    /**
     * <p>
     * The resource type of the share invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareResourceType}
     * will return {@link ShareResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the share invitation.
     * @see ShareResourceType
     */
    public final ShareResourceType shareResourceType() {
        return ShareResourceType.fromValue(shareResourceType);
    }

    /**
     * <p>
     * The resource type of the share invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareResourceType}
     * will return {@link ShareResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the share invitation.
     * @see ShareResourceType
     */
    public final String shareResourceTypeAsString() {
        return shareResourceType;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The ARN for the lens.
     * </p>
     * 
     * @return The ARN for the lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(shareResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareInvitation)) {
            return false;
        }
        ShareInvitation other = (ShareInvitation) obj;
        return Objects.equals(shareInvitationId(), other.shareInvitationId())
                && Objects.equals(shareResourceTypeAsString(), other.shareResourceTypeAsString())
                && Objects.equals(workloadId(), other.workloadId()) && Objects.equals(lensAlias(), other.lensAlias())
                && Objects.equals(lensArn(), other.lensArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareInvitation").add("ShareInvitationId", shareInvitationId())
                .add("ShareResourceType", shareResourceTypeAsString()).add("WorkloadId", workloadId())
                .add("LensAlias", lensAlias()).add("LensArn", lensArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShareInvitationId":
            return Optional.ofNullable(clazz.cast(shareInvitationId()));
        case "ShareResourceType":
            return Optional.ofNullable(clazz.cast(shareResourceTypeAsString()));
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareInvitation, T> g) {
        return obj -> g.apply((ShareInvitation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShareInvitation> {
        /**
         * <p>
         * The ID assigned to the share invitation.
         * </p>
         * 
         * @param shareInvitationId
         *        The ID assigned to the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationId(String shareInvitationId);

        /**
         * <p>
         * The resource type of the share invitation.
         * </p>
         * 
         * @param shareResourceType
         *        The resource type of the share invitation.
         * @see ShareResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareResourceType
         */
        Builder shareResourceType(String shareResourceType);

        /**
         * <p>
         * The resource type of the share invitation.
         * </p>
         * 
         * @param shareResourceType
         *        The resource type of the share invitation.
         * @see ShareResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareResourceType
         */
        Builder shareResourceType(ShareResourceType shareResourceType);

        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The ARN for the lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN for the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);
    }

    static final class BuilderImpl implements Builder {
        private String shareInvitationId;

        private String shareResourceType;

        private String workloadId;

        private String lensAlias;

        private String lensArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareInvitation model) {
            shareInvitationId(model.shareInvitationId);
            shareResourceType(model.shareResourceType);
            workloadId(model.workloadId);
            lensAlias(model.lensAlias);
            lensArn(model.lensArn);
        }

        public final String getShareInvitationId() {
            return shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final String getShareResourceType() {
            return shareResourceType;
        }

        public final void setShareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
        }

        @Override
        public final Builder shareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
            return this;
        }

        @Override
        public final Builder shareResourceType(ShareResourceType shareResourceType) {
            this.shareResourceType(shareResourceType == null ? null : shareResourceType.toString());
            return this;
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        @Override
        public ShareInvitation build() {
            return new ShareInvitation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
