/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse;

public class ListAnswersIterable
implements SdkIterable<ListAnswersResponse> {
    private final WellArchitectedClient client;
    private final ListAnswersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnswersIterable(WellArchitectedClient client, ListAnswersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAnswersResponseFetcher();
    }

    public Iterator<ListAnswersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAnswersResponseFetcher
    implements SyncPageFetcher<ListAnswersResponse> {
        private ListAnswersResponseFetcher() {
        }

        public boolean hasNextPage(ListAnswersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnswersResponse nextPage(ListAnswersResponse previousPage) {
            if (previousPage == null) {
                return ListAnswersIterable.this.client.listAnswers(ListAnswersIterable.this.firstRequest);
            }
            return ListAnswersIterable.this.client.listAnswers((ListAnswersRequest)((Object)ListAnswersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

