/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfileRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateProfileRequest.Builder, UpdateProfileRequest> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileArn").getter(getter(UpdateProfileRequest::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileArn").build()).build();

    private static final SdkField<String> PROFILE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileDescription").getter(getter(UpdateProfileRequest::profileDescription))
            .setter(setter(Builder::profileDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileDescription").build())
            .build();

    private static final SdkField<List<ProfileQuestionUpdate>> PROFILE_QUESTIONS_FIELD = SdkField
            .<List<ProfileQuestionUpdate>> builder(MarshallingType.LIST)
            .memberName("ProfileQuestions")
            .getter(getter(UpdateProfileRequest::profileQuestions))
            .setter(setter(Builder::profileQuestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileQuestions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileQuestionUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileQuestionUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD,
            PROFILE_DESCRIPTION_FIELD, PROFILE_QUESTIONS_FIELD));

    private final String profileArn;

    private final String profileDescription;

    private final List<ProfileQuestionUpdate> profileQuestions;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
        this.profileDescription = builder.profileDescription;
        this.profileQuestions = builder.profileQuestions;
    }

    /**
     * <p>
     * The profile ARN.
     * </p>
     * 
     * @return The profile ARN.
     */
    public final String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The profile description.
     * </p>
     * 
     * @return The profile description.
     */
    public final String profileDescription() {
        return profileDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileQuestions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProfileQuestions() {
        return profileQuestions != null && !(profileQuestions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Profile questions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileQuestions} method.
     * </p>
     * 
     * @return Profile questions.
     */
    public final List<ProfileQuestionUpdate> profileQuestions() {
        return profileQuestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileQuestions() ? profileQuestions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest) obj;
        return Objects.equals(profileArn(), other.profileArn())
                && Objects.equals(profileDescription(), other.profileDescription())
                && hasProfileQuestions() == other.hasProfileQuestions()
                && Objects.equals(profileQuestions(), other.profileQuestions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfileRequest").add("ProfileArn", profileArn())
                .add("ProfileDescription", profileDescription())
                .add("ProfileQuestions", hasProfileQuestions() ? profileQuestions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "ProfileDescription":
            return Optional.ofNullable(clazz.cast(profileDescription()));
        case "ProfileQuestions":
            return Optional.ofNullable(clazz.cast(profileQuestions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileRequest, T> g) {
        return obj -> g.apply((UpdateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProfileRequest> {
        /**
         * <p>
         * The profile ARN.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The profile description.
         * </p>
         * 
         * @param profileDescription
         *        The profile description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileDescription(String profileDescription);

        /**
         * <p>
         * Profile questions.
         * </p>
         * 
         * @param profileQuestions
         *        Profile questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileQuestions(Collection<ProfileQuestionUpdate> profileQuestions);

        /**
         * <p>
         * Profile questions.
         * </p>
         * 
         * @param profileQuestions
         *        Profile questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileQuestions(ProfileQuestionUpdate... profileQuestions);

        /**
         * <p>
         * Profile questions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdate.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #profileQuestions(List<ProfileQuestionUpdate>)}.
         * 
         * @param profileQuestions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileQuestions(java.util.Collection<ProfileQuestionUpdate>)
         */
        Builder profileQuestions(Consumer<ProfileQuestionUpdate.Builder>... profileQuestions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String profileArn;

        private String profileDescription;

        private List<ProfileQuestionUpdate> profileQuestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            super(model);
            profileArn(model.profileArn);
            profileDescription(model.profileDescription);
            profileQuestions(model.profileQuestions);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileDescription() {
            return profileDescription;
        }

        public final void setProfileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
        }

        @Override
        public final Builder profileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
            return this;
        }

        public final List<ProfileQuestionUpdate.Builder> getProfileQuestions() {
            List<ProfileQuestionUpdate.Builder> result = ProfileQuestionUpdatesCopier.copyToBuilder(this.profileQuestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileQuestions(Collection<ProfileQuestionUpdate.BuilderImpl> profileQuestions) {
            this.profileQuestions = ProfileQuestionUpdatesCopier.copyFromBuilder(profileQuestions);
        }

        @Override
        public final Builder profileQuestions(Collection<ProfileQuestionUpdate> profileQuestions) {
            this.profileQuestions = ProfileQuestionUpdatesCopier.copy(profileQuestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(ProfileQuestionUpdate... profileQuestions) {
            profileQuestions(Arrays.asList(profileQuestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(Consumer<ProfileQuestionUpdate.Builder>... profileQuestions) {
            profileQuestions(Stream.of(profileQuestions).map(c -> ProfileQuestionUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
