/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workload summary return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadSummary implements SdkPojo, Serializable, ToCopyableBuilder<WorkloadSummary.Builder, WorkloadSummary> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(WorkloadSummary::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> WORKLOAD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadArn").getter(getter(WorkloadSummary::workloadArn)).setter(setter(Builder::workloadArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadArn").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(WorkloadSummary::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(WorkloadSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(WorkloadSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<List<String>> LENSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Lenses")
            .getter(getter(WorkloadSummary::lenses))
            .setter(setter(Builder::lenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("RiskCounts")
            .getter(getter(WorkloadSummary::riskCountsAsStrings))
            .setter(setter(Builder::riskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IMPROVEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImprovementStatus").getter(getter(WorkloadSummary::improvementStatusAsString))
            .setter(setter(Builder::improvementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementStatus").build()).build();

    private static final SdkField<List<WorkloadProfile>> PROFILES_FIELD = SdkField
            .<List<WorkloadProfile>> builder(MarshallingType.LIST)
            .memberName("Profiles")
            .getter(getter(WorkloadSummary::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkloadProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkloadProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> PRIORITIZED_RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("PrioritizedRiskCounts")
            .getter(getter(WorkloadSummary::prioritizedRiskCountsAsStrings))
            .setter(setter(Builder::prioritizedRiskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrioritizedRiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            WORKLOAD_ARN_FIELD, WORKLOAD_NAME_FIELD, OWNER_FIELD, UPDATED_AT_FIELD, LENSES_FIELD, RISK_COUNTS_FIELD,
            IMPROVEMENT_STATUS_FIELD, PROFILES_FIELD, PRIORITIZED_RISK_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workloadId;

    private final String workloadArn;

    private final String workloadName;

    private final String owner;

    private final Instant updatedAt;

    private final List<String> lenses;

    private final Map<String, Integer> riskCounts;

    private final String improvementStatus;

    private final List<WorkloadProfile> profiles;

    private final Map<String, Integer> prioritizedRiskCounts;

    private WorkloadSummary(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.workloadArn = builder.workloadArn;
        this.workloadName = builder.workloadName;
        this.owner = builder.owner;
        this.updatedAt = builder.updatedAt;
        this.lenses = builder.lenses;
        this.riskCounts = builder.riskCounts;
        this.improvementStatus = builder.improvementStatus;
        this.profiles = builder.profiles;
        this.prioritizedRiskCounts = builder.prioritizedRiskCounts;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the WorkloadArn property for this object.
     * 
     * @return The value of the WorkloadArn property for this object.
     */
    public final String workloadArn() {
        return workloadArn;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public final String owner() {
        return owner;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lenses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLenses() {
        return lenses != null && !(lenses instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Lenses property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLenses} method.
     * </p>
     * 
     * @return The value of the Lenses property for this object.
     */
    public final List<String> lenses() {
        return lenses;
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(riskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskCounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRiskCounts() {
        return riskCounts != null && !(riskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<String, Integer> riskCountsAsStrings() {
        return riskCounts;
    }

    /**
     * Returns the value of the ImprovementStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #improvementStatus}
     * will return {@link WorkloadImprovementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #improvementStatusAsString}.
     * </p>
     * 
     * @return The value of the ImprovementStatus property for this object.
     * @see WorkloadImprovementStatus
     */
    public final WorkloadImprovementStatus improvementStatus() {
        return WorkloadImprovementStatus.fromValue(improvementStatus);
    }

    /**
     * Returns the value of the ImprovementStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #improvementStatus}
     * will return {@link WorkloadImprovementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #improvementStatusAsString}.
     * </p>
     * 
     * @return The value of the ImprovementStatus property for this object.
     * @see WorkloadImprovementStatus
     */
    public final String improvementStatusAsString() {
        return improvementStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Profile associated with a workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return Profile associated with a workload.
     */
    public final List<WorkloadProfile> profiles() {
        return profiles;
    }

    /**
     * Returns the value of the PrioritizedRiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrioritizedRiskCounts} method.
     * </p>
     * 
     * @return The value of the PrioritizedRiskCounts property for this object.
     */
    public final Map<Risk, Integer> prioritizedRiskCounts() {
        return RiskCountsCopier.copyStringToEnum(prioritizedRiskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the PrioritizedRiskCounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrioritizedRiskCounts() {
        return prioritizedRiskCounts != null && !(prioritizedRiskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the PrioritizedRiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrioritizedRiskCounts} method.
     * </p>
     * 
     * @return The value of the PrioritizedRiskCounts property for this object.
     */
    public final Map<String, Integer> prioritizedRiskCountsAsStrings() {
        return prioritizedRiskCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadArn());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasLenses() ? lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskCounts() ? riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(improvementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrioritizedRiskCounts() ? prioritizedRiskCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadSummary)) {
            return false;
        }
        WorkloadSummary other = (WorkloadSummary) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(workloadArn(), other.workloadArn())
                && Objects.equals(workloadName(), other.workloadName()) && Objects.equals(owner(), other.owner())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasLenses() == other.hasLenses()
                && Objects.equals(lenses(), other.lenses()) && hasRiskCounts() == other.hasRiskCounts()
                && Objects.equals(riskCountsAsStrings(), other.riskCountsAsStrings())
                && Objects.equals(improvementStatusAsString(), other.improvementStatusAsString())
                && hasProfiles() == other.hasProfiles() && Objects.equals(profiles(), other.profiles())
                && hasPrioritizedRiskCounts() == other.hasPrioritizedRiskCounts()
                && Objects.equals(prioritizedRiskCountsAsStrings(), other.prioritizedRiskCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadSummary").add("WorkloadId", workloadId()).add("WorkloadArn", workloadArn())
                .add("WorkloadName", workloadName()).add("Owner", owner()).add("UpdatedAt", updatedAt())
                .add("Lenses", hasLenses() ? lenses() : null).add("RiskCounts", hasRiskCounts() ? riskCountsAsStrings() : null)
                .add("ImprovementStatus", improvementStatusAsString()).add("Profiles", hasProfiles() ? profiles() : null)
                .add("PrioritizedRiskCounts", hasPrioritizedRiskCounts() ? prioritizedRiskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadArn":
            return Optional.ofNullable(clazz.cast(workloadArn()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Lenses":
            return Optional.ofNullable(clazz.cast(lenses()));
        case "RiskCounts":
            return Optional.ofNullable(clazz.cast(riskCountsAsStrings()));
        case "ImprovementStatus":
            return Optional.ofNullable(clazz.cast(improvementStatusAsString()));
        case "Profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        case "PrioritizedRiskCounts":
            return Optional.ofNullable(clazz.cast(prioritizedRiskCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadSummary, T> g) {
        return obj -> g.apply((WorkloadSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadSummary> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the WorkloadArn property for this object.
         *
         * @param workloadArn
         *        The new value for the WorkloadArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadArn(String workloadArn);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the Lenses property for this object.
         *
         * @param lenses
         *        The new value for the Lenses property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(Collection<String> lenses);

        /**
         * Sets the value of the Lenses property for this object.
         *
         * @param lenses
         *        The new value for the Lenses property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(String... lenses);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCountsWithStrings(Map<String, Integer> riskCounts);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCounts(Map<Risk, Integer> riskCounts);

        /**
         * Sets the value of the ImprovementStatus property for this object.
         *
         * @param improvementStatus
         *        The new value for the ImprovementStatus property for this object.
         * @see WorkloadImprovementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadImprovementStatus
         */
        Builder improvementStatus(String improvementStatus);

        /**
         * Sets the value of the ImprovementStatus property for this object.
         *
         * @param improvementStatus
         *        The new value for the ImprovementStatus property for this object.
         * @see WorkloadImprovementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadImprovementStatus
         */
        Builder improvementStatus(WorkloadImprovementStatus improvementStatus);

        /**
         * <p>
         * Profile associated with a workload.
         * </p>
         * 
         * @param profiles
         *        Profile associated with a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<WorkloadProfile> profiles);

        /**
         * <p>
         * Profile associated with a workload.
         * </p>
         * 
         * @param profiles
         *        Profile associated with a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(WorkloadProfile... profiles);

        /**
         * <p>
         * Profile associated with a workload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #profiles(List<WorkloadProfile>)}.
         * 
         * @param profiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profiles(java.util.Collection<WorkloadProfile>)
         */
        Builder profiles(Consumer<WorkloadProfile.Builder>... profiles);

        /**
         * Sets the value of the PrioritizedRiskCounts property for this object.
         *
         * @param prioritizedRiskCounts
         *        The new value for the PrioritizedRiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts);

        /**
         * Sets the value of the PrioritizedRiskCounts property for this object.
         *
         * @param prioritizedRiskCounts
         *        The new value for the PrioritizedRiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts);
    }

    static final class BuilderImpl implements Builder {
        private String workloadId;

        private String workloadArn;

        private String workloadName;

        private String owner;

        private Instant updatedAt;

        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private String improvementStatus;

        private List<WorkloadProfile> profiles = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Integer> prioritizedRiskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadSummary model) {
            workloadId(model.workloadId);
            workloadArn(model.workloadArn);
            workloadName(model.workloadName);
            owner(model.owner);
            updatedAt(model.updatedAt);
            lenses(model.lenses);
            riskCountsWithStrings(model.riskCounts);
            improvementStatus(model.improvementStatus);
            profiles(model.profiles);
            prioritizedRiskCountsWithStrings(model.prioritizedRiskCounts);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadArn() {
            return workloadArn;
        }

        public final void setWorkloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
        }

        @Override
        public final Builder workloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Collection<String> getLenses() {
            if (lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String... lenses) {
            lenses(Arrays.asList(lenses));
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final String getImprovementStatus() {
            return improvementStatus;
        }

        public final void setImprovementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
        }

        @Override
        public final Builder improvementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
            return this;
        }

        @Override
        public final Builder improvementStatus(WorkloadImprovementStatus improvementStatus) {
            this.improvementStatus(improvementStatus == null ? null : improvementStatus.toString());
            return this;
        }

        public final List<WorkloadProfile.Builder> getProfiles() {
            List<WorkloadProfile.Builder> result = WorkloadProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<WorkloadProfile.BuilderImpl> profiles) {
            this.profiles = WorkloadProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<WorkloadProfile> profiles) {
            this.profiles = WorkloadProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(WorkloadProfile... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<WorkloadProfile.Builder>... profiles) {
            profiles(Stream.of(profiles).map(c -> WorkloadProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getPrioritizedRiskCounts() {
            if (prioritizedRiskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return prioritizedRiskCounts;
        }

        public final void setPrioritizedRiskCounts(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
        }

        @Override
        public final Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
            return this;
        }

        @Override
        public final Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copyEnumToString(prioritizedRiskCounts);
            return this;
        }

        @Override
        public WorkloadSummary build() {
            return new WorkloadSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
