/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse;

public class ListCheckDetailsPublisher
implements SdkPublisher<ListCheckDetailsResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListCheckDetailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCheckDetailsPublisher(WellArchitectedAsyncClient client, ListCheckDetailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCheckDetailsPublisher(WellArchitectedAsyncClient client, ListCheckDetailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCheckDetailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCheckDetailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCheckDetailsResponseFetcher
    implements AsyncPageFetcher<ListCheckDetailsResponse> {
        private ListCheckDetailsResponseFetcher() {
        }

        public boolean hasNextPage(ListCheckDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCheckDetailsResponse> nextPage(ListCheckDetailsResponse previousPage) {
            if (previousPage == null) {
                return ListCheckDetailsPublisher.this.client.listCheckDetails(ListCheckDetailsPublisher.this.firstRequest);
            }
            return ListCheckDetailsPublisher.this.client.listCheckDetails((ListCheckDetailsRequest)((Object)ListCheckDetailsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

