/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.AssociateProfilesRequest;
import software.amazon.awssdk.services.wellarchitected.model.AssociateProfilesResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensVersionRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensVersionResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateProfileRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateProfileResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateProfileShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateProfileShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateReviewTemplateRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateReviewTemplateResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateTemplateShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateTemplateShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteProfileRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteProfileResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteProfileShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteProfileShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteReviewTemplateRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteReviewTemplateResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteTemplateShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteTemplateShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateProfilesRequest;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateProfilesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ExportLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.ExportLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetProfileRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetProfileResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetProfileTemplateRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetProfileTemplateResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.ImportLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.ImportLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfilesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.wellarchitected.model.TagResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.TagResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.UntagResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.UntagResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateProfileRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateProfileResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeProfileVersionRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeProfileVersionResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeReviewTemplateLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeReviewTemplateLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.paginators.GetConsolidatedReportPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListCheckDetailsPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListCheckSummariesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListProfileNotificationsPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListProfileSharesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListProfilesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplateAnswersPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplatesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListTemplateSharesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesPublisher;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsPublisher;

/**
 * Service client for accessing Well-Architected asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Well-Architected Tool</fullname>
 * <p>
 * This is the <i>Well-Architected Tool API Reference</i>. The WA Tool API provides programmatic access to the <a
 * href="http://aws.amazon.com/well-architected-tool">Well-Architected Tool</a> in the <a
 * href="https://console.aws.amazon.com/wellarchitected">Amazon Web Services Management Console</a>. For information
 * about the Well-Architected Tool, see the <a
 * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html">Well-Architected Tool User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WellArchitectedAsyncClient extends AwsClient {
    String SERVICE_NAME = "wellarchitected";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "wellarchitected";

    /**
     * <p>
     * Associate a lens to a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be
     * associated with a workload.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you
     * acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in
     * the Amazon Web Services Customer Agreement.
     * </p>
     * </note>
     *
     * @param associateLensesRequest
     *        Input to associate lens reviews.
     * @return A Java Future containing the result of the AssociateLenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.AssociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateLensesResponse> associateLenses(AssociateLensesRequest associateLensesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a lens to a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be
     * associated with a workload.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you
     * acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in
     * the Amazon Web Services Customer Agreement.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLensesRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateLensesRequest#builder()}
     * </p>
     *
     * @param associateLensesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.AssociateLensesRequest.Builder} to create a
     *        request. Input to associate lens reviews.
     * @return A Java Future containing the result of the AssociateLenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.AssociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateLensesResponse> associateLenses(
            Consumer<AssociateLensesRequest.Builder> associateLensesRequest) {
        return associateLenses(AssociateLensesRequest.builder().applyMutation(associateLensesRequest).build());
    }

    /**
     * <p>
     * Associate a profile with a workload.
     * </p>
     *
     * @param associateProfilesRequest
     * @return A Java Future containing the result of the AssociateProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.AssociateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateProfilesResponse> associateProfiles(AssociateProfilesRequest associateProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a profile with a workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateProfilesRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateProfilesRequest#builder()}
     * </p>
     *
     * @param associateProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.AssociateProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.AssociateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/AssociateProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateProfilesResponse> associateProfiles(
            Consumer<AssociateProfilesRequest.Builder> associateProfilesRequest) {
        return associateProfiles(AssociateProfilesRequest.builder().applyMutation(associateProfilesRequest).build());
    }

    /**
     * <p>
     * Create a lens share.
     * </p>
     * <p>
     * The owner of a lens can share it with other Amazon Web Services accounts, users, an organization, and
     * organizational units (OUs) in the same Amazon Web Services Region. Lenses provided by Amazon Web Services (Amazon
     * Web Services Official Content) cannot be shared.
     * </p>
     * <p>
     * Shared access to a lens is not removed until the lens invitation is deleted.
     * </p>
     * <p>
     * If you share a lens with an organization or OU, all accounts in the organization or OU are granted access to the
     * lens.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-sharing.html">Sharing a custom lens</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note>
     *
     * @param createLensShareRequest
     * @return A Java Future containing the result of the CreateLensShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLensShareResponse> createLensShare(CreateLensShareRequest createLensShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a lens share.
     * </p>
     * <p>
     * The owner of a lens can share it with other Amazon Web Services accounts, users, an organization, and
     * organizational units (OUs) in the same Amazon Web Services Region. Lenses provided by Amazon Web Services (Amazon
     * Web Services Official Content) cannot be shared.
     * </p>
     * <p>
     * Shared access to a lens is not removed until the lens invitation is deleted.
     * </p>
     * <p>
     * If you share a lens with an organization or OU, all accounts in the organization or OU are granted access to the
     * lens.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-sharing.html">Sharing a custom lens</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLensShareRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLensShareRequest#builder()}
     * </p>
     *
     * @param createLensShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateLensShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLensShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLensShareResponse> createLensShare(
            Consumer<CreateLensShareRequest.Builder> createLensShareRequest) {
        return createLensShare(CreateLensShareRequest.builder().applyMutation(createLensShareRequest).build());
    }

    /**
     * <p>
     * Create a new lens version.
     * </p>
     * <p>
     * A lens can have up to 100 versions.
     * </p>
     * <p>
     * Use this operation to publish a new lens version after you have imported a lens. The <code>LensAlias</code> is
     * used to identify the lens to be published. The owner of a lens can share the lens with other Amazon Web Services
     * accounts and users in the same Amazon Web Services Region. Only the owner of a lens can delete it.
     * </p>
     *
     * @param createLensVersionRequest
     * @return A Java Future containing the result of the CreateLensVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateLensVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLensVersionResponse> createLensVersion(CreateLensVersionRequest createLensVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new lens version.
     * </p>
     * <p>
     * A lens can have up to 100 versions.
     * </p>
     * <p>
     * Use this operation to publish a new lens version after you have imported a lens. The <code>LensAlias</code> is
     * used to identify the lens to be published. The owner of a lens can share the lens with other Amazon Web Services
     * accounts and users in the same Amazon Web Services Region. Only the owner of a lens can delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLensVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLensVersionRequest#builder()}
     * </p>
     *
     * @param createLensVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateLensVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLensVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateLensVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateLensVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLensVersionResponse> createLensVersion(
            Consumer<CreateLensVersionRequest.Builder> createLensVersionRequest) {
        return createLensVersion(CreateLensVersionRequest.builder().applyMutation(createLensVersionRequest).build());
    }

    /**
     * <p>
     * Create a milestone for an existing workload.
     * </p>
     *
     * @param createMilestoneRequest
     *        Input for milestone creation.
     * @return A Java Future containing the result of the CreateMilestone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMilestoneResponse> createMilestone(CreateMilestoneRequest createMilestoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a milestone for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMilestoneRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMilestoneRequest#builder()}
     * </p>
     *
     * @param createMilestoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneRequest.Builder} to create a
     *        request. Input for milestone creation.
     * @return A Java Future containing the result of the CreateMilestone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateMilestone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMilestoneResponse> createMilestone(
            Consumer<CreateMilestoneRequest.Builder> createMilestoneRequest) {
        return createMilestone(CreateMilestoneRequest.builder().applyMutation(createMilestoneRequest).build());
    }

    /**
     * <p>
     * Create a profile.
     * </p>
     *
     * @param createProfileRequest
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(CreateProfileRequest createProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest) {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Create a profile share.
     * </p>
     *
     * @param createProfileShareRequest
     * @return A Java Future containing the result of the CreateProfileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateProfileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProfileShareResponse> createProfileShare(CreateProfileShareRequest createProfileShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a profile share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProfileShareRequest#builder()}
     * </p>
     *
     * @param createProfileShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateProfileShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateProfileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateProfileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateProfileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProfileShareResponse> createProfileShare(
            Consumer<CreateProfileShareRequest.Builder> createProfileShareRequest) {
        return createProfileShare(CreateProfileShareRequest.builder().applyMutation(createProfileShareRequest).build());
    }

    /**
     * <p>
     * Create a review template.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your review templates. If your review template or those shared with you and used in your account do
     * include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with
     * applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note>
     *
     * @param createReviewTemplateRequest
     * @return A Java Future containing the result of the CreateReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReviewTemplateResponse> createReviewTemplate(
            CreateReviewTemplateRequest createReviewTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a review template.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your review templates. If your review template or those shared with you and used in your account do
     * include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with
     * applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReviewTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReviewTemplateRequest#builder()}
     * </p>
     *
     * @param createReviewTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateReviewTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReviewTemplateResponse> createReviewTemplate(
            Consumer<CreateReviewTemplateRequest.Builder> createReviewTemplateRequest) {
        return createReviewTemplate(CreateReviewTemplateRequest.builder().applyMutation(createReviewTemplateRequest).build());
    }

    /**
     * <p>
     * Create a review template share.
     * </p>
     * <p>
     * The owner of a review template can share it with other Amazon Web Services accounts, users, an organization, and
     * organizational units (OUs) in the same Amazon Web Services Region.
     * </p>
     * <p>
     * Shared access to a review template is not removed until the review template share invitation is deleted.
     * </p>
     * <p>
     * If you share a review template with an organization or OU, all accounts in the organization or OU are granted
     * access to the review template.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your review template with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your review template available to those other accounts.
     * </p>
     * </note>
     *
     * @param createTemplateShareRequest
     * @return A Java Future containing the result of the CreateTemplateShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateTemplateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateTemplateShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTemplateShareResponse> createTemplateShare(
            CreateTemplateShareRequest createTemplateShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a review template share.
     * </p>
     * <p>
     * The owner of a review template can share it with other Amazon Web Services accounts, users, an organization, and
     * organizational units (OUs) in the same Amazon Web Services Region.
     * </p>
     * <p>
     * Shared access to a review template is not removed until the review template share invitation is deleted.
     * </p>
     * <p>
     * If you share a review template with an organization or OU, all accounts in the organization or OU are granted
     * access to the review template.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your review template with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your review template available to those other accounts.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTemplateShareRequest#builder()}
     * </p>
     *
     * @param createTemplateShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateTemplateShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateTemplateShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateTemplateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateTemplateShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTemplateShareResponse> createTemplateShare(
            Consumer<CreateTemplateShareRequest.Builder> createTemplateShareRequest) {
        return createTemplateShare(CreateTemplateShareRequest.builder().applyMutation(createTemplateShareRequest).build());
    }

    /**
     * <p>
     * Create a new workload.
     * </p>
     * <p>
     * The owner of a workload can share the workload with other Amazon Web Services accounts, users, an organization,
     * and organizational units (OUs) in the same Amazon Web Services Region. Only the owner of a workload can delete
     * it.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <important>
     * <p>
     * Either <code>AwsRegions</code>, <code>NonAwsRegions</code>, or both must be specified when creating a workload.
     * </p>
     * <p>
     * You also must specify <code>ReviewOwner</code>, even though the parameter is listed as not being required in the
     * following section.
     * </p>
     * </important>
     * <p>
     * When creating a workload using a review template, you must have the following IAM permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>wellarchitected:GetReviewTemplate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wellarchitected:GetReviewTemplateAnswer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wellarchitected:ListReviewTemplateAnswers</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wellarchitected:GetReviewTemplateLensReview</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param createWorkloadRequest
     *        Input for workload creation.
     * @return A Java Future containing the result of the CreateWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadResponse> createWorkload(CreateWorkloadRequest createWorkloadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new workload.
     * </p>
     * <p>
     * The owner of a workload can share the workload with other Amazon Web Services accounts, users, an organization,
     * and organizational units (OUs) in the same Amazon Web Services Region. Only the owner of a workload can delete
     * it.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <important>
     * <p>
     * Either <code>AwsRegions</code>, <code>NonAwsRegions</code>, or both must be specified when creating a workload.
     * </p>
     * <p>
     * You also must specify <code>ReviewOwner</code>, even though the parameter is listed as not being required in the
     * following section.
     * </p>
     * </important>
     * <p>
     * When creating a workload using a review template, you must have the following IAM permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>wellarchitected:GetReviewTemplate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wellarchitected:GetReviewTemplateAnswer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wellarchitected:ListReviewTemplateAnswers</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wellarchitected:GetReviewTemplateLensReview</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkloadRequest#builder()}
     * </p>
     *
     * @param createWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadRequest.Builder} to create a
     *        request. Input for workload creation.
     * @return A Java Future containing the result of the CreateWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadResponse> createWorkload(Consumer<CreateWorkloadRequest.Builder> createWorkloadRequest) {
        return createWorkload(CreateWorkloadRequest.builder().applyMutation(createWorkloadRequest).build());
    }

    /**
     * <p>
     * Create a workload share.
     * </p>
     * <p>
     * The owner of a workload can share it with other Amazon Web Services accounts and users in the same Amazon Web
     * Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
     * </p>
     * <p>
     * If you share a workload with an organization or OU, all accounts in the organization or OU are granted access to
     * the workload.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     *
     * @param createWorkloadShareRequest
     *        Input for Create Workload Share
     * @return A Java Future containing the result of the CreateWorkloadShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadShareResponse> createWorkloadShare(
            CreateWorkloadShareRequest createWorkloadShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a workload share.
     * </p>
     * <p>
     * The owner of a workload can share it with other Amazon Web Services accounts and users in the same Amazon Web
     * Services Region. Shared access to a workload is not removed until the workload invitation is deleted.
     * </p>
     * <p>
     * If you share a workload with an organization or OU, all accounts in the organization or OU are granted access to
     * the workload.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a workload</a>
     * in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkloadShareRequest#builder()}
     * </p>
     *
     * @param createWorkloadShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareRequest.Builder} to create
     *        a request. Input for Create Workload Share
     * @return A Java Future containing the result of the CreateWorkloadShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.CreateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/CreateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadShareResponse> createWorkloadShare(
            Consumer<CreateWorkloadShareRequest.Builder> createWorkloadShareRequest) {
        return createWorkloadShare(CreateWorkloadShareRequest.builder().applyMutation(createWorkloadShareRequest).build());
    }

    /**
     * <p>
     * Delete an existing lens.
     * </p>
     * <p>
     * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and users that
     * you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note>
     *
     * @param deleteLensRequest
     * @return A Java Future containing the result of the DeleteLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLensResponse> deleteLens(DeleteLensRequest deleteLensRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing lens.
     * </p>
     * <p>
     * Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and users that
     * you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLensRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLensRequest#builder()}
     * </p>
     *
     * @param deleteLensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteLensRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteLensResponse> deleteLens(Consumer<DeleteLensRequest.Builder> deleteLensRequest) {
        return deleteLens(DeleteLensRequest.builder().applyMutation(deleteLensRequest).build());
    }

    /**
     * <p>
     * Delete a lens share.
     * </p>
     * <p>
     * After the lens share is deleted, Amazon Web Services accounts, users, organizations, and organizational units
     * (OUs) that you shared the lens with can continue to use it, but they will no longer be able to apply it to new
     * workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note>
     *
     * @param deleteLensShareRequest
     * @return A Java Future containing the result of the DeleteLensShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLensShareResponse> deleteLensShare(DeleteLensShareRequest deleteLensShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a lens share.
     * </p>
     * <p>
     * After the lens share is deleted, Amazon Web Services accounts, users, organizations, and organizational units
     * (OUs) that you shared the lens with can continue to use it, but they will no longer be able to apply it to new
     * workloads.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services
     * will make your custom lenses available to those other accounts. Those other accounts may continue to access and
     * use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or
     * terminate your Amazon Web Services account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLensShareRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLensShareRequest#builder()}
     * </p>
     *
     * @param deleteLensShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteLensShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLensShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteLensShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteLensShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLensShareResponse> deleteLensShare(
            Consumer<DeleteLensShareRequest.Builder> deleteLensShareRequest) {
        return deleteLensShare(DeleteLensShareRequest.builder().applyMutation(deleteLensShareRequest).build());
    }

    /**
     * <p>
     * Delete a profile.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your profile with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will
     * make your profile available to those other accounts. Those other accounts may continue to access and use your
     * shared profile even if you delete the profile from your own Amazon Web Services account or terminate your Amazon
     * Web Services account.
     * </p>
     * </note>
     *
     * @param deleteProfileRequest
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(DeleteProfileRequest deleteProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a profile.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * By sharing your profile with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will
     * make your profile available to those other accounts. Those other accounts may continue to access and use your
     * shared profile even if you delete the profile from your own Amazon Web Services account or terminate your Amazon
     * Web Services account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest) {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Delete a profile share.
     * </p>
     *
     * @param deleteProfileShareRequest
     * @return A Java Future containing the result of the DeleteProfileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteProfileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProfileShareResponse> deleteProfileShare(DeleteProfileShareRequest deleteProfileShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a profile share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProfileShareRequest#builder()}
     * </p>
     *
     * @param deleteProfileShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteProfileShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteProfileShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteProfileShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteProfileShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProfileShareResponse> deleteProfileShare(
            Consumer<DeleteProfileShareRequest.Builder> deleteProfileShareRequest) {
        return deleteProfileShare(DeleteProfileShareRequest.builder().applyMutation(deleteProfileShareRequest).build());
    }

    /**
     * <p>
     * Delete a review template.
     * </p>
     * <p>
     * Only the owner of a review template can delete it.
     * </p>
     * <p>
     * After the review template is deleted, Amazon Web Services accounts, users, organizations, and organizational
     * units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.
     * </p>
     *
     * @param deleteReviewTemplateRequest
     * @return A Java Future containing the result of the DeleteReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReviewTemplateResponse> deleteReviewTemplate(
            DeleteReviewTemplateRequest deleteReviewTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a review template.
     * </p>
     * <p>
     * Only the owner of a review template can delete it.
     * </p>
     * <p>
     * After the review template is deleted, Amazon Web Services accounts, users, organizations, and organizational
     * units (OUs) that you shared the review template with will no longer be able to apply it to new workloads.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReviewTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReviewTemplateRequest#builder()}
     * </p>
     *
     * @param deleteReviewTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteReviewTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReviewTemplateResponse> deleteReviewTemplate(
            Consumer<DeleteReviewTemplateRequest.Builder> deleteReviewTemplateRequest) {
        return deleteReviewTemplate(DeleteReviewTemplateRequest.builder().applyMutation(deleteReviewTemplateRequest).build());
    }

    /**
     * <p>
     * Delete a review template share.
     * </p>
     * <p>
     * After the review template share is deleted, Amazon Web Services accounts, users, organizations, and
     * organizational units (OUs) that you shared the review template with will no longer be able to apply it to new
     * workloads.
     * </p>
     *
     * @param deleteTemplateShareRequest
     * @return A Java Future containing the result of the DeleteTemplateShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteTemplateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteTemplateShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTemplateShareResponse> deleteTemplateShare(
            DeleteTemplateShareRequest deleteTemplateShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a review template share.
     * </p>
     * <p>
     * After the review template share is deleted, Amazon Web Services accounts, users, organizations, and
     * organizational units (OUs) that you shared the review template with will no longer be able to apply it to new
     * workloads.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTemplateShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTemplateShareRequest#builder()}
     * </p>
     *
     * @param deleteTemplateShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteTemplateShareRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteTemplateShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteTemplateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteTemplateShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTemplateShareResponse> deleteTemplateShare(
            Consumer<DeleteTemplateShareRequest.Builder> deleteTemplateShareRequest) {
        return deleteTemplateShare(DeleteTemplateShareRequest.builder().applyMutation(deleteTemplateShareRequest).build());
    }

    /**
     * <p>
     * Delete an existing workload.
     * </p>
     *
     * @param deleteWorkloadRequest
     *        Input for workload deletion.
     * @return A Java Future containing the result of the DeleteWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadResponse> deleteWorkload(DeleteWorkloadRequest deleteWorkloadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkloadRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadRequest.Builder} to create a
     *        request. Input for workload deletion.
     * @return A Java Future containing the result of the DeleteWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadResponse> deleteWorkload(Consumer<DeleteWorkloadRequest.Builder> deleteWorkloadRequest) {
        return deleteWorkload(DeleteWorkloadRequest.builder().applyMutation(deleteWorkloadRequest).build());
    }

    /**
     * <p>
     * Delete a workload share.
     * </p>
     *
     * @param deleteWorkloadShareRequest
     *        Input for Delete Workload Share
     * @return A Java Future containing the result of the DeleteWorkloadShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadShareResponse> deleteWorkloadShare(
            DeleteWorkloadShareRequest deleteWorkloadShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a workload share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkloadShareRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareRequest.Builder} to create
     *        a request. Input for Delete Workload Share
     * @return A Java Future containing the result of the DeleteWorkloadShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DeleteWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DeleteWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadShareResponse> deleteWorkloadShare(
            Consumer<DeleteWorkloadShareRequest.Builder> deleteWorkloadShareRequest) {
        return deleteWorkloadShare(DeleteWorkloadShareRequest.builder().applyMutation(deleteWorkloadShareRequest).build());
    }

    /**
     * <p>
     * Disassociate a lens from a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be disassociated from a workload in a single API operation.
     * </p>
     * <note>
     * <p>
     * The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a
     * workload.
     * </p>
     * </note>
     *
     * @param disassociateLensesRequest
     *        Input to disassociate lens reviews.
     * @return A Java Future containing the result of the DisassociateLenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DisassociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLensesResponse> disassociateLenses(DisassociateLensesRequest disassociateLensesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate a lens from a workload.
     * </p>
     * <p>
     * Up to 10 lenses can be disassociated from a workload in a single API operation.
     * </p>
     * <note>
     * <p>
     * The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a
     * workload.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLensesRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateLensesRequest#builder()}
     * </p>
     *
     * @param disassociateLensesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesRequest.Builder} to create
     *        a request. Input to disassociate lens reviews.
     * @return A Java Future containing the result of the DisassociateLenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DisassociateLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateLenses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLensesResponse> disassociateLenses(
            Consumer<DisassociateLensesRequest.Builder> disassociateLensesRequest) {
        return disassociateLenses(DisassociateLensesRequest.builder().applyMutation(disassociateLensesRequest).build());
    }

    /**
     * <p>
     * Disassociate a profile from a workload.
     * </p>
     *
     * @param disassociateProfilesRequest
     * @return A Java Future containing the result of the DisassociateProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DisassociateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateProfilesResponse> disassociateProfiles(
            DisassociateProfilesRequest disassociateProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate a profile from a workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateProfilesRequest#builder()}
     * </p>
     *
     * @param disassociateProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.DisassociateProfilesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.DisassociateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/DisassociateProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateProfilesResponse> disassociateProfiles(
            Consumer<DisassociateProfilesRequest.Builder> disassociateProfilesRequest) {
        return disassociateProfiles(DisassociateProfilesRequest.builder().applyMutation(disassociateProfilesRequest).build());
    }

    /**
     * <p>
     * Export an existing lens.
     * </p>
     * <p>
     * Only the owner of a lens can export it. Lenses provided by Amazon Web Services (Amazon Web Services Official
     * Content) cannot be exported.
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note>
     *
     * @param exportLensRequest
     * @return A Java Future containing the result of the ExportLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ExportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ExportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportLensResponse> exportLens(ExportLensRequest exportLensRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Export an existing lens.
     * </p>
     * <p>
     * Only the owner of a lens can export it. Lenses provided by Amazon Web Services (Amazon Web Services Official
     * Content) cannot be exported.
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportLensRequest.Builder} avoiding the need to
     * create one manually via {@link ExportLensRequest#builder()}
     * </p>
     *
     * @param exportLensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ExportLensRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExportLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ExportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ExportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportLensResponse> exportLens(Consumer<ExportLensRequest.Builder> exportLensRequest) {
        return exportLens(ExportLensRequest.builder().applyMutation(exportLensRequest).build());
    }

    /**
     * <p>
     * Get the answer to a specific question in a workload review.
     * </p>
     *
     * @param getAnswerRequest
     *        Input to get answer.
     * @return A Java Future containing the result of the GetAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnswerResponse> getAnswer(GetAnswerRequest getAnswerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the answer to a specific question in a workload review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnswerRequest.Builder} avoiding the need to
     * create one manually via {@link GetAnswerRequest#builder()}
     * </p>
     *
     * @param getAnswerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetAnswerRequest.Builder} to create a
     *        request. Input to get answer.
     * @return A Java Future containing the result of the GetAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnswerResponse> getAnswer(Consumer<GetAnswerRequest.Builder> getAnswerRequest) {
        return getAnswer(GetAnswerRequest.builder().applyMutation(getAnswerRequest).build());
    }

    /**
     * <p>
     * Get a consolidated report of your workloads.
     * </p>
     * <p>
     * You can optionally choose to include workloads that have been shared with you.
     * </p>
     *
     * @param getConsolidatedReportRequest
     * @return A Java Future containing the result of the GetConsolidatedReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetConsolidatedReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetConsolidatedReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConsolidatedReportResponse> getConsolidatedReport(
            GetConsolidatedReportRequest getConsolidatedReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a consolidated report of your workloads.
     * </p>
     * <p>
     * You can optionally choose to include workloads that have been shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConsolidatedReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetConsolidatedReportRequest#builder()}
     * </p>
     *
     * @param getConsolidatedReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConsolidatedReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetConsolidatedReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetConsolidatedReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConsolidatedReportResponse> getConsolidatedReport(
            Consumer<GetConsolidatedReportRequest.Builder> getConsolidatedReportRequest) {
        return getConsolidatedReport(GetConsolidatedReportRequest.builder().applyMutation(getConsolidatedReportRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getConsolidatedReport(software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.GetConsolidatedReportPublisher publisher = client.getConsolidatedReportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.GetConsolidatedReportPublisher publisher = client.getConsolidatedReportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConsolidatedReport(software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConsolidatedReportRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetConsolidatedReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetConsolidatedReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConsolidatedReportPublisher getConsolidatedReportPaginator(
            GetConsolidatedReportRequest getConsolidatedReportRequest) {
        return new GetConsolidatedReportPublisher(this, getConsolidatedReportRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getConsolidatedReport(software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.GetConsolidatedReportPublisher publisher = client.getConsolidatedReportPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.GetConsolidatedReportPublisher publisher = client.getConsolidatedReportPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConsolidatedReport(software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConsolidatedReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetConsolidatedReportRequest#builder()}
     * </p>
     *
     * @param getConsolidatedReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetConsolidatedReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetConsolidatedReport"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConsolidatedReportPublisher getConsolidatedReportPaginator(
            Consumer<GetConsolidatedReportRequest.Builder> getConsolidatedReportRequest) {
        return getConsolidatedReportPaginator(GetConsolidatedReportRequest.builder().applyMutation(getConsolidatedReportRequest)
                .build());
    }

    /**
     * <p>
     * Get an existing lens.
     * </p>
     *
     * @param getLensRequest
     * @return A Java Future containing the result of the GetLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLens" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLensResponse> getLens(GetLensRequest getLensRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an existing lens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensRequest.Builder} avoiding the need to create
     * one manually via {@link GetLensRequest#builder()}
     * </p>
     *
     * @param getLensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetLensRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLens" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLensResponse> getLens(Consumer<GetLensRequest.Builder> getLensRequest) {
        return getLens(GetLensRequest.builder().applyMutation(getLensRequest).build());
    }

    /**
     * <p>
     * Get lens review.
     * </p>
     *
     * @param getLensReviewRequest
     *        Input to get lens review.
     * @return A Java Future containing the result of the GetLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLensReviewResponse> getLensReview(GetLensReviewRequest getLensReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get lens review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensReviewRequest.Builder} avoiding the need to
     * create one manually via {@link GetLensReviewRequest#builder()}
     * </p>
     *
     * @param getLensReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetLensReviewRequest.Builder} to create a
     *        request. Input to get lens review.
     * @return A Java Future containing the result of the GetLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReview" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLensReviewResponse> getLensReview(Consumer<GetLensReviewRequest.Builder> getLensReviewRequest) {
        return getLensReview(GetLensReviewRequest.builder().applyMutation(getLensReviewRequest).build());
    }

    /**
     * <p>
     * Get lens review report.
     * </p>
     *
     * @param getLensReviewReportRequest
     *        Input to get lens review report.
     * @return A Java Future containing the result of the GetLensReviewReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLensReviewReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLensReviewReportResponse> getLensReviewReport(
            GetLensReviewReportRequest getLensReviewReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get lens review report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensReviewReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetLensReviewReportRequest#builder()}
     * </p>
     *
     * @param getLensReviewReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportRequest.Builder} to create
     *        a request. Input to get lens review report.
     * @return A Java Future containing the result of the GetLensReviewReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLensReviewReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensReviewReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLensReviewReportResponse> getLensReviewReport(
            Consumer<GetLensReviewReportRequest.Builder> getLensReviewReportRequest) {
        return getLensReviewReport(GetLensReviewReportRequest.builder().applyMutation(getLensReviewReportRequest).build());
    }

    /**
     * <p>
     * Get lens version differences.
     * </p>
     *
     * @param getLensVersionDifferenceRequest
     * @return A Java Future containing the result of the GetLensVersionDifference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLensVersionDifference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLensVersionDifferenceResponse> getLensVersionDifference(
            GetLensVersionDifferenceRequest getLensVersionDifferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get lens version differences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLensVersionDifferenceRequest.Builder} avoiding
     * the need to create one manually via {@link GetLensVersionDifferenceRequest#builder()}
     * </p>
     *
     * @param getLensVersionDifferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetLensVersionDifference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetLensVersionDifference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetLensVersionDifference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLensVersionDifferenceResponse> getLensVersionDifference(
            Consumer<GetLensVersionDifferenceRequest.Builder> getLensVersionDifferenceRequest) {
        return getLensVersionDifference(GetLensVersionDifferenceRequest.builder().applyMutation(getLensVersionDifferenceRequest)
                .build());
    }

    /**
     * <p>
     * Get a milestone for an existing workload.
     * </p>
     *
     * @param getMilestoneRequest
     *        Input to get a milestone.
     * @return A Java Future containing the result of the GetMilestone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMilestoneResponse> getMilestone(GetMilestoneRequest getMilestoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a milestone for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMilestoneRequest.Builder} avoiding the need to
     * create one manually via {@link GetMilestoneRequest#builder()}
     * </p>
     *
     * @param getMilestoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetMilestoneRequest.Builder} to create a
     *        request. Input to get a milestone.
     * @return A Java Future containing the result of the GetMilestone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetMilestone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetMilestone" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMilestoneResponse> getMilestone(Consumer<GetMilestoneRequest.Builder> getMilestoneRequest) {
        return getMilestone(GetMilestoneRequest.builder().applyMutation(getMilestoneRequest).build());
    }

    /**
     * <p>
     * Get profile information.
     * </p>
     *
     * @param getProfileRequest
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(GetProfileRequest getProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get profile information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * Get profile template.
     * </p>
     *
     * @param getProfileTemplateRequest
     * @return A Java Future containing the result of the GetProfileTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetProfileTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfileTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProfileTemplateResponse> getProfileTemplate(GetProfileTemplateRequest getProfileTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get profile template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link GetProfileTemplateRequest#builder()}
     * </p>
     *
     * @param getProfileTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetProfileTemplateRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetProfileTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetProfileTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetProfileTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProfileTemplateResponse> getProfileTemplate(
            Consumer<GetProfileTemplateRequest.Builder> getProfileTemplateRequest) {
        return getProfileTemplate(GetProfileTemplateRequest.builder().applyMutation(getProfileTemplateRequest).build());
    }

    /**
     * <p>
     * Get review template.
     * </p>
     *
     * @param getReviewTemplateRequest
     * @return A Java Future containing the result of the GetReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReviewTemplateResponse> getReviewTemplate(GetReviewTemplateRequest getReviewTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get review template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReviewTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetReviewTemplateRequest#builder()}
     * </p>
     *
     * @param getReviewTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReviewTemplateResponse> getReviewTemplate(
            Consumer<GetReviewTemplateRequest.Builder> getReviewTemplateRequest) {
        return getReviewTemplate(GetReviewTemplateRequest.builder().applyMutation(getReviewTemplateRequest).build());
    }

    /**
     * <p>
     * Get review template answer.
     * </p>
     *
     * @param getReviewTemplateAnswerRequest
     * @return A Java Future containing the result of the GetReviewTemplateAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetReviewTemplateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReviewTemplateAnswerResponse> getReviewTemplateAnswer(
            GetReviewTemplateAnswerRequest getReviewTemplateAnswerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get review template answer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReviewTemplateAnswerRequest.Builder} avoiding
     * the need to create one manually via {@link GetReviewTemplateAnswerRequest#builder()}
     * </p>
     *
     * @param getReviewTemplateAnswerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateAnswerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetReviewTemplateAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetReviewTemplateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReviewTemplateAnswerResponse> getReviewTemplateAnswer(
            Consumer<GetReviewTemplateAnswerRequest.Builder> getReviewTemplateAnswerRequest) {
        return getReviewTemplateAnswer(GetReviewTemplateAnswerRequest.builder().applyMutation(getReviewTemplateAnswerRequest)
                .build());
    }

    /**
     * <p>
     * Get a lens review associated with a review template.
     * </p>
     *
     * @param getReviewTemplateLensReviewRequest
     * @return A Java Future containing the result of the GetReviewTemplateLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetReviewTemplateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReviewTemplateLensReviewResponse> getReviewTemplateLensReview(
            GetReviewTemplateLensReviewRequest getReviewTemplateLensReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a lens review associated with a review template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReviewTemplateLensReviewRequest.Builder}
     * avoiding the need to create one manually via {@link GetReviewTemplateLensReviewRequest#builder()}
     * </p>
     *
     * @param getReviewTemplateLensReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetReviewTemplateLensReviewRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetReviewTemplateLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetReviewTemplateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetReviewTemplateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReviewTemplateLensReviewResponse> getReviewTemplateLensReview(
            Consumer<GetReviewTemplateLensReviewRequest.Builder> getReviewTemplateLensReviewRequest) {
        return getReviewTemplateLensReview(GetReviewTemplateLensReviewRequest.builder()
                .applyMutation(getReviewTemplateLensReviewRequest).build());
    }

    /**
     * <p>
     * Get an existing workload.
     * </p>
     *
     * @param getWorkloadRequest
     *        Input to get a workload.
     * @return A Java Future containing the result of the GetWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkloadResponse> getWorkload(GetWorkloadRequest getWorkloadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkloadRequest#builder()}
     * </p>
     *
     * @param getWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.GetWorkloadRequest.Builder} to create a
     *        request. Input to get a workload.
     * @return A Java Future containing the result of the GetWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.GetWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/GetWorkload" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkloadResponse> getWorkload(Consumer<GetWorkloadRequest.Builder> getWorkloadRequest) {
        return getWorkload(GetWorkloadRequest.builder().applyMutation(getWorkloadRequest).build());
    }

    /**
     * <p>
     * Import a new custom lens or update an existing custom lens.
     * </p>
     * <p>
     * To update an existing custom lens, specify its ARN as the <code>LensAlias</code>. If no ARN is specified, a new
     * custom lens is created.
     * </p>
     * <p>
     * The new or updated lens will have a status of <code>DRAFT</code>. The lens cannot be applied to workloads or
     * shared with other Amazon Web Services accounts until it's published with <a>CreateLensVersion</a>.
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <p>
     * A custom lens cannot exceed 500 KB in size.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note>
     *
     * @param importLensRequest
     * @return A Java Future containing the result of the ImportLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ImportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ImportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportLensResponse> importLens(ImportLensRequest importLensRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import a new custom lens or update an existing custom lens.
     * </p>
     * <p>
     * To update an existing custom lens, specify its ARN as the <code>LensAlias</code>. If no ARN is specified, a new
     * custom lens is created.
     * </p>
     * <p>
     * The new or updated lens will have a status of <code>DRAFT</code>. The lens cannot be applied to workloads or
     * shared with other Amazon Web Services accounts until it's published with <a>CreateLensVersion</a>.
     * </p>
     * <p>
     * Lenses are defined in JSON. For more information, see <a
     * href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format
     * specification</a> in the <i>Well-Architected Tool User Guide</i>.
     * </p>
     * <p>
     * A custom lens cannot exceed 500 KB in size.
     * </p>
     * <note>
     * <p>
     * <b>Disclaimer</b>
     * </p>
     * <p>
     * Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals
     * in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or
     * collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable
     * law, providing adequate privacy notices, and obtaining necessary consents for processing such data.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportLensRequest.Builder} avoiding the need to
     * create one manually via {@link ImportLensRequest#builder()}
     * </p>
     *
     * @param importLensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ImportLensRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportLens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ServiceQuotaExceededException The user has reached their resource quota.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ImportLens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ImportLens" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportLensResponse> importLens(Consumer<ImportLensRequest.Builder> importLensRequest) {
        return importLens(ImportLensRequest.builder().applyMutation(importLensRequest).build());
    }

    /**
     * <p>
     * List of answers for a particular workload and lens.
     * </p>
     *
     * @param listAnswersRequest
     *        Input to list answers.
     * @return A Java Future containing the result of the ListAnswers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnswersResponse> listAnswers(ListAnswersRequest listAnswersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of answers for a particular workload and lens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnswersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnswersRequest#builder()}
     * </p>
     *
     * @param listAnswersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest.Builder} to create a
     *        request. Input to list answers.
     * @return A Java Future containing the result of the ListAnswers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnswersResponse> listAnswers(Consumer<ListAnswersRequest.Builder> listAnswersRequest) {
        return listAnswers(ListAnswersRequest.builder().applyMutation(listAnswersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersPublisher publisher = client.listAnswersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersPublisher publisher = client.listAnswersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation.</b>
     * </p>
     *
     * @param listAnswersRequest
     *        Input to list answers.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnswersPublisher listAnswersPaginator(ListAnswersRequest listAnswersRequest) {
        return new ListAnswersPublisher(this, listAnswersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersPublisher publisher = client.listAnswersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersPublisher publisher = client.listAnswersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnswers(software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnswersRequest.Builder} avoiding the need to
     * create one manually via {@link ListAnswersRequest#builder()}
     * </p>
     *
     * @param listAnswersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest.Builder} to create a
     *        request. Input to list answers.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListAnswers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnswersPublisher listAnswersPaginator(Consumer<ListAnswersRequest.Builder> listAnswersRequest) {
        return listAnswersPaginator(ListAnswersRequest.builder().applyMutation(listAnswersRequest).build());
    }

    /**
     * <p>
     * List of Trusted Advisor check details by account related to the workload.
     * </p>
     *
     * @param listCheckDetailsRequest
     * @return A Java Future containing the result of the ListCheckDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCheckDetailsResponse> listCheckDetails(ListCheckDetailsRequest listCheckDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of Trusted Advisor check details by account related to the workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCheckDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCheckDetailsRequest#builder()}
     * </p>
     *
     * @param listCheckDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCheckDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCheckDetailsResponse> listCheckDetails(
            Consumer<ListCheckDetailsRequest.Builder> listCheckDetailsRequest) {
        return listCheckDetails(ListCheckDetailsRequest.builder().applyMutation(listCheckDetailsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCheckDetails(software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckDetailsPublisher publisher = client.listCheckDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckDetailsPublisher publisher = client.listCheckDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCheckDetails(software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCheckDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCheckDetailsPublisher listCheckDetailsPaginator(ListCheckDetailsRequest listCheckDetailsRequest) {
        return new ListCheckDetailsPublisher(this, listCheckDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCheckDetails(software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckDetailsPublisher publisher = client.listCheckDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckDetailsPublisher publisher = client.listCheckDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCheckDetails(software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCheckDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCheckDetailsRequest#builder()}
     * </p>
     *
     * @param listCheckDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCheckDetailsPublisher listCheckDetailsPaginator(Consumer<ListCheckDetailsRequest.Builder> listCheckDetailsRequest) {
        return listCheckDetailsPaginator(ListCheckDetailsRequest.builder().applyMutation(listCheckDetailsRequest).build());
    }

    /**
     * <p>
     * List of Trusted Advisor checks summarized for all accounts related to the workload.
     * </p>
     *
     * @param listCheckSummariesRequest
     * @return A Java Future containing the result of the ListCheckSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCheckSummariesResponse> listCheckSummaries(ListCheckSummariesRequest listCheckSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of Trusted Advisor checks summarized for all accounts related to the workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCheckSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCheckSummariesRequest#builder()}
     * </p>
     *
     * @param listCheckSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListCheckSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCheckSummariesResponse> listCheckSummaries(
            Consumer<ListCheckSummariesRequest.Builder> listCheckSummariesRequest) {
        return listCheckSummaries(ListCheckSummariesRequest.builder().applyMutation(listCheckSummariesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCheckSummaries(software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckSummariesPublisher publisher = client.listCheckSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckSummariesPublisher publisher = client.listCheckSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCheckSummaries(software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCheckSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCheckSummariesPublisher listCheckSummariesPaginator(ListCheckSummariesRequest listCheckSummariesRequest) {
        return new ListCheckSummariesPublisher(this, listCheckSummariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCheckSummaries(software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckSummariesPublisher publisher = client.listCheckSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListCheckSummariesPublisher publisher = client.listCheckSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCheckSummaries(software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCheckSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCheckSummariesRequest#builder()}
     * </p>
     *
     * @param listCheckSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListCheckSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListCheckSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCheckSummariesPublisher listCheckSummariesPaginator(
            Consumer<ListCheckSummariesRequest.Builder> listCheckSummariesRequest) {
        return listCheckSummariesPaginator(ListCheckSummariesRequest.builder().applyMutation(listCheckSummariesRequest).build());
    }

    /**
     * <p>
     * List lens review improvements.
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        Input to list lens review improvements.
     * @return A Java Future containing the result of the ListLensReviewImprovements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLensReviewImprovementsResponse> listLensReviewImprovements(
            ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens review improvements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewImprovementsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLensReviewImprovementsRequest#builder()}
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest.Builder} to
     *        create a request. Input to list lens review improvements.
     * @return A Java Future containing the result of the ListLensReviewImprovements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLensReviewImprovementsResponse> listLensReviewImprovements(
            Consumer<ListLensReviewImprovementsRequest.Builder> listLensReviewImprovementsRequest) {
        return listLensReviewImprovements(ListLensReviewImprovementsRequest.builder()
                .applyMutation(listLensReviewImprovementsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsPublisher publisher = client.listLensReviewImprovementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsPublisher publisher = client.listLensReviewImprovementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        Input to list lens review improvements.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewImprovementsPublisher listLensReviewImprovementsPaginator(
            ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) {
        return new ListLensReviewImprovementsPublisher(this, listLensReviewImprovementsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsPublisher publisher = client.listLensReviewImprovementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsPublisher publisher = client.listLensReviewImprovementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviewImprovements(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewImprovementsRequest.Builder} avoiding
     * the need to create one manually via {@link ListLensReviewImprovementsRequest#builder()}
     * </p>
     *
     * @param listLensReviewImprovementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest.Builder} to
     *        create a request. Input to list lens review improvements.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviewImprovements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviewImprovements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewImprovementsPublisher listLensReviewImprovementsPaginator(
            Consumer<ListLensReviewImprovementsRequest.Builder> listLensReviewImprovementsRequest) {
        return listLensReviewImprovementsPaginator(ListLensReviewImprovementsRequest.builder()
                .applyMutation(listLensReviewImprovementsRequest).build());
    }

    /**
     * <p>
     * List lens reviews for a particular workload.
     * </p>
     *
     * @param listLensReviewsRequest
     *        Input to list lens reviews.
     * @return A Java Future containing the result of the ListLensReviews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLensReviewsResponse> listLensReviews(ListLensReviewsRequest listLensReviewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens reviews for a particular workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLensReviewsRequest#builder()}
     * </p>
     *
     * @param listLensReviewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest.Builder} to create a
     *        request. Input to list lens reviews.
     * @return A Java Future containing the result of the ListLensReviews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLensReviewsResponse> listLensReviews(
            Consumer<ListLensReviewsRequest.Builder> listLensReviewsRequest) {
        return listLensReviews(ListLensReviewsRequest.builder().applyMutation(listLensReviewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsPublisher publisher = client.listLensReviewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsPublisher publisher = client.listLensReviewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLensReviewsRequest
     *        Input to list lens reviews.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewsPublisher listLensReviewsPaginator(ListLensReviewsRequest listLensReviewsRequest) {
        return new ListLensReviewsPublisher(this, listLensReviewsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsPublisher publisher = client.listLensReviewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsPublisher publisher = client.listLensReviewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensReviews(software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensReviewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLensReviewsRequest#builder()}
     * </p>
     *
     * @param listLensReviewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest.Builder} to create a
     *        request. Input to list lens reviews.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensReviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensReviews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensReviewsPublisher listLensReviewsPaginator(Consumer<ListLensReviewsRequest.Builder> listLensReviewsRequest) {
        return listLensReviewsPaginator(ListLensReviewsRequest.builder().applyMutation(listLensReviewsRequest).build());
    }

    /**
     * <p>
     * List the lens shares associated with the lens.
     * </p>
     *
     * @param listLensSharesRequest
     * @return A Java Future containing the result of the ListLensShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLensSharesResponse> listLensShares(ListLensSharesRequest listLensSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the lens shares associated with the lens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensSharesRequest#builder()}
     * </p>
     *
     * @param listLensSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLensShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLensSharesResponse> listLensShares(Consumer<ListLensSharesRequest.Builder> listLensSharesRequest) {
        return listLensShares(ListLensSharesRequest.builder().applyMutation(listLensSharesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesPublisher publisher = client.listLensSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesPublisher publisher = client.listLensSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLensSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensSharesPublisher listLensSharesPaginator(ListLensSharesRequest listLensSharesRequest) {
        return new ListLensSharesPublisher(this, listLensSharesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesPublisher publisher = client.listLensSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesPublisher publisher = client.listLensSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLensShares(software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensSharesRequest#builder()}
     * </p>
     *
     * @param listLensSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLensShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLensSharesPublisher listLensSharesPaginator(Consumer<ListLensSharesRequest.Builder> listLensSharesRequest) {
        return listLensSharesPaginator(ListLensSharesRequest.builder().applyMutation(listLensSharesRequest).build());
    }

    /**
     * <p>
     * List the available lenses.
     * </p>
     *
     * @param listLensesRequest
     *        Input to list lenses.
     * @return A Java Future containing the result of the ListLenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLensesResponse> listLenses(ListLensesRequest listLensesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the available lenses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensesRequest#builder()}
     * </p>
     *
     * @param listLensesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest.Builder} to create a
     *        request. Input to list lenses.
     * @return A Java Future containing the result of the ListLenses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLensesResponse> listLenses(Consumer<ListLensesRequest.Builder> listLensesRequest) {
        return listLenses(ListLensesRequest.builder().applyMutation(listLensesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesPublisher publisher = client.listLensesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesPublisher publisher = client.listLensesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)} operation.</b>
     * </p>
     *
     * @param listLensesRequest
     *        Input to list lenses.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLensesPublisher listLensesPaginator(ListLensesRequest listLensesRequest) {
        return new ListLensesPublisher(this, listLensesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesPublisher publisher = client.listLensesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListLensesPublisher publisher = client.listLensesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLenses(software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLensesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLensesRequest#builder()}
     * </p>
     *
     * @param listLensesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest.Builder} to create a
     *        request. Input to list lenses.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListLenses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLenses" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLensesPublisher listLensesPaginator(Consumer<ListLensesRequest.Builder> listLensesRequest) {
        return listLensesPaginator(ListLensesRequest.builder().applyMutation(listLensesRequest).build());
    }

    /**
     * <p>
     * List all milestones for an existing workload.
     * </p>
     *
     * @param listMilestonesRequest
     *        Input to list all milestones for a workload.
     * @return A Java Future containing the result of the ListMilestones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMilestonesResponse> listMilestones(ListMilestonesRequest listMilestonesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all milestones for an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMilestonesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMilestonesRequest#builder()}
     * </p>
     *
     * @param listMilestonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest.Builder} to create a
     *        request. Input to list all milestones for a workload.
     * @return A Java Future containing the result of the ListMilestones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMilestonesResponse> listMilestones(Consumer<ListMilestonesRequest.Builder> listMilestonesRequest) {
        return listMilestones(ListMilestonesRequest.builder().applyMutation(listMilestonesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesPublisher publisher = client.listMilestonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesPublisher publisher = client.listMilestonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMilestonesRequest
     *        Input to list all milestones for a workload.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMilestonesPublisher listMilestonesPaginator(ListMilestonesRequest listMilestonesRequest) {
        return new ListMilestonesPublisher(this, listMilestonesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesPublisher publisher = client.listMilestonesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesPublisher publisher = client.listMilestonesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMilestones(software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMilestonesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMilestonesRequest#builder()}
     * </p>
     *
     * @param listMilestonesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest.Builder} to create a
     *        request. Input to list all milestones for a workload.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListMilestones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListMilestones"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMilestonesPublisher listMilestonesPaginator(Consumer<ListMilestonesRequest.Builder> listMilestonesRequest) {
        return listMilestonesPaginator(ListMilestonesRequest.builder().applyMutation(listMilestonesRequest).build());
    }

    /**
     * <p>
     * List lens notifications.
     * </p>
     *
     * @param listNotificationsRequest
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(ListNotificationsRequest listNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List lens notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationsResponse> listNotifications(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotifications(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest) {
        return new ListNotificationsPublisher(this, listNotificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsPublisher publisher = client.listNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotifications(software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListNotificationsRequest#builder()}
     * </p>
     *
     * @param listNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationsPublisher listNotificationsPaginator(
            Consumer<ListNotificationsRequest.Builder> listNotificationsRequest) {
        return listNotificationsPaginator(ListNotificationsRequest.builder().applyMutation(listNotificationsRequest).build());
    }

    /**
     * <p>
     * List profile notifications.
     * </p>
     *
     * @param listProfileNotificationsRequest
     * @return A Java Future containing the result of the ListProfileNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfileNotificationsResponse> listProfileNotifications(
            ListProfileNotificationsRequest listProfileNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List profile notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileNotificationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProfileNotificationsRequest#builder()}
     * </p>
     *
     * @param listProfileNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProfileNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfileNotificationsResponse> listProfileNotifications(
            Consumer<ListProfileNotificationsRequest.Builder> listProfileNotificationsRequest) {
        return listProfileNotifications(ListProfileNotificationsRequest.builder().applyMutation(listProfileNotificationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProfileNotifications(software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileNotificationsPublisher publisher = client.listProfileNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileNotificationsPublisher publisher = client.listProfileNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileNotifications(software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfileNotificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileNotificationsPublisher listProfileNotificationsPaginator(
            ListProfileNotificationsRequest listProfileNotificationsRequest) {
        return new ListProfileNotificationsPublisher(this, listProfileNotificationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProfileNotifications(software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileNotificationsPublisher publisher = client.listProfileNotificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileNotificationsPublisher publisher = client.listProfileNotificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileNotifications(software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileNotificationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProfileNotificationsRequest#builder()}
     * </p>
     *
     * @param listProfileNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileNotificationsPublisher listProfileNotificationsPaginator(
            Consumer<ListProfileNotificationsRequest.Builder> listProfileNotificationsRequest) {
        return listProfileNotificationsPaginator(ListProfileNotificationsRequest.builder()
                .applyMutation(listProfileNotificationsRequest).build());
    }

    /**
     * <p>
     * List profile shares.
     * </p>
     *
     * @param listProfileSharesRequest
     * @return A Java Future containing the result of the ListProfileShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfileSharesResponse> listProfileShares(ListProfileSharesRequest listProfileSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List profile shares.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileSharesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileSharesRequest#builder()}
     * </p>
     *
     * @param listProfileSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProfileShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfileSharesResponse> listProfileShares(
            Consumer<ListProfileSharesRequest.Builder> listProfileSharesRequest) {
        return listProfileShares(ListProfileSharesRequest.builder().applyMutation(listProfileSharesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProfileShares(software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileSharesPublisher publisher = client.listProfileSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileSharesPublisher publisher = client.listProfileSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileShares(software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfileSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileSharesPublisher listProfileSharesPaginator(ListProfileSharesRequest listProfileSharesRequest) {
        return new ListProfileSharesPublisher(this, listProfileSharesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProfileShares(software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileSharesPublisher publisher = client.listProfileSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfileSharesPublisher publisher = client.listProfileSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileShares(software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileSharesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileSharesRequest#builder()}
     * </p>
     *
     * @param listProfileSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfileShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfileShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileSharesPublisher listProfileSharesPaginator(
            Consumer<ListProfileSharesRequest.Builder> listProfileSharesRequest) {
        return listProfileSharesPaginator(ListProfileSharesRequest.builder().applyMutation(listProfileSharesRequest).build());
    }

    /**
     * <p>
     * List profiles.
     * </p>
     *
     * @param listProfilesRequest
     * @return A Java Future containing the result of the ListProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProfilesResponse> listProfiles(ListProfilesRequest listProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProfilesResponse> listProfiles(Consumer<ListProfilesRequest.Builder> listProfilesRequest) {
        return listProfiles(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProfiles(software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProfilesPublisher listProfilesPaginator(ListProfilesRequest listProfilesRequest) {
        return new ListProfilesPublisher(this, listProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProfiles(software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProfilesPublisher listProfilesPaginator(Consumer<ListProfilesRequest.Builder> listProfilesRequest) {
        return listProfilesPaginator(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * List the answers of a review template.
     * </p>
     *
     * @param listReviewTemplateAnswersRequest
     * @return A Java Future containing the result of the ListReviewTemplateAnswers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplateAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplateAnswers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewTemplateAnswersResponse> listReviewTemplateAnswers(
            ListReviewTemplateAnswersRequest listReviewTemplateAnswersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the answers of a review template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewTemplateAnswersRequest.Builder} avoiding
     * the need to create one manually via {@link ListReviewTemplateAnswersRequest#builder()}
     * </p>
     *
     * @param listReviewTemplateAnswersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListReviewTemplateAnswers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplateAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplateAnswers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewTemplateAnswersResponse> listReviewTemplateAnswers(
            Consumer<ListReviewTemplateAnswersRequest.Builder> listReviewTemplateAnswersRequest) {
        return listReviewTemplateAnswers(ListReviewTemplateAnswersRequest.builder()
                .applyMutation(listReviewTemplateAnswersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewTemplateAnswers(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplateAnswersPublisher publisher = client.listReviewTemplateAnswersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplateAnswersPublisher publisher = client.listReviewTemplateAnswersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewTemplateAnswers(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReviewTemplateAnswersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplateAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplateAnswers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewTemplateAnswersPublisher listReviewTemplateAnswersPaginator(
            ListReviewTemplateAnswersRequest listReviewTemplateAnswersRequest) {
        return new ListReviewTemplateAnswersPublisher(this, listReviewTemplateAnswersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewTemplateAnswers(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplateAnswersPublisher publisher = client.listReviewTemplateAnswersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplateAnswersPublisher publisher = client.listReviewTemplateAnswersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewTemplateAnswers(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewTemplateAnswersRequest.Builder} avoiding
     * the need to create one manually via {@link ListReviewTemplateAnswersRequest#builder()}
     * </p>
     *
     * @param listReviewTemplateAnswersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplateAnswers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplateAnswers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewTemplateAnswersPublisher listReviewTemplateAnswersPaginator(
            Consumer<ListReviewTemplateAnswersRequest.Builder> listReviewTemplateAnswersRequest) {
        return listReviewTemplateAnswersPaginator(ListReviewTemplateAnswersRequest.builder()
                .applyMutation(listReviewTemplateAnswersRequest).build());
    }

    /**
     * <p>
     * List review templates.
     * </p>
     *
     * @param listReviewTemplatesRequest
     * @return A Java Future containing the result of the ListReviewTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewTemplatesResponse> listReviewTemplates(
            ListReviewTemplatesRequest listReviewTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List review templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListReviewTemplatesRequest#builder()}
     * </p>
     *
     * @param listReviewTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListReviewTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReviewTemplatesResponse> listReviewTemplates(
            Consumer<ListReviewTemplatesRequest.Builder> listReviewTemplatesRequest) {
        return listReviewTemplates(ListReviewTemplatesRequest.builder().applyMutation(listReviewTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewTemplates(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplatesPublisher publisher = client.listReviewTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplatesPublisher publisher = client.listReviewTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewTemplates(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReviewTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewTemplatesPublisher listReviewTemplatesPaginator(ListReviewTemplatesRequest listReviewTemplatesRequest) {
        return new ListReviewTemplatesPublisher(this, listReviewTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReviewTemplates(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplatesPublisher publisher = client.listReviewTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListReviewTemplatesPublisher publisher = client.listReviewTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReviewTemplates(software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReviewTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListReviewTemplatesRequest#builder()}
     * </p>
     *
     * @param listReviewTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListReviewTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReviewTemplatesPublisher listReviewTemplatesPaginator(
            Consumer<ListReviewTemplatesRequest.Builder> listReviewTemplatesRequest) {
        return listReviewTemplatesPaginator(ListReviewTemplatesRequest.builder().applyMutation(listReviewTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * List the share invitations.
     * </p>
     * <p>
     * <code>WorkloadNamePrefix</code>, <code>LensNamePrefix</code>, <code>ProfileNamePrefix</code>, and
     * <code>TemplateNamePrefix</code> are mutually exclusive. Use the parameter that matches your
     * <code>ShareResourceType</code>.
     * </p>
     *
     * @param listShareInvitationsRequest
     *        Input for List Share Invitations
     * @return A Java Future containing the result of the ListShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListShareInvitationsResponse> listShareInvitations(
            ListShareInvitationsRequest listShareInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the share invitations.
     * </p>
     * <p>
     * <code>WorkloadNamePrefix</code>, <code>LensNamePrefix</code>, <code>ProfileNamePrefix</code>, and
     * <code>TemplateNamePrefix</code> are mutually exclusive. Use the parameter that matches your
     * <code>ShareResourceType</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListShareInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListShareInvitationsRequest#builder()}
     * </p>
     *
     * @param listShareInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest.Builder} to
     *        create a request. Input for List Share Invitations
     * @return A Java Future containing the result of the ListShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListShareInvitationsResponse> listShareInvitations(
            Consumer<ListShareInvitationsRequest.Builder> listShareInvitationsRequest) {
        return listShareInvitations(ListShareInvitationsRequest.builder().applyMutation(listShareInvitationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsPublisher publisher = client.listShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsPublisher publisher = client.listShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listShareInvitationsRequest
     *        Input for List Share Invitations
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListShareInvitationsPublisher listShareInvitationsPaginator(ListShareInvitationsRequest listShareInvitationsRequest) {
        return new ListShareInvitationsPublisher(this, listShareInvitationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsPublisher publisher = client.listShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsPublisher publisher = client.listShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listShareInvitations(software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListShareInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListShareInvitationsRequest#builder()}
     * </p>
     *
     * @param listShareInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest.Builder} to
     *        create a request. Input for List Share Invitations
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListShareInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListShareInvitationsPublisher listShareInvitationsPaginator(
            Consumer<ListShareInvitationsRequest.Builder> listShareInvitationsRequest) {
        return listShareInvitationsPaginator(ListShareInvitationsRequest.builder().applyMutation(listShareInvitationsRequest)
                .build());
    }

    /**
     * <p>
     * List the tags for a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     * </p>
     * </note>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List review template shares.
     * </p>
     *
     * @param listTemplateSharesRequest
     * @return A Java Future containing the result of the ListTemplateShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListTemplateShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTemplateShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTemplateSharesResponse> listTemplateShares(ListTemplateSharesRequest listTemplateSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List review template shares.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateSharesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateSharesRequest#builder()}
     * </p>
     *
     * @param listTemplateSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTemplateShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListTemplateShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTemplateShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTemplateSharesResponse> listTemplateShares(
            Consumer<ListTemplateSharesRequest.Builder> listTemplateSharesRequest) {
        return listTemplateShares(ListTemplateSharesRequest.builder().applyMutation(listTemplateSharesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTemplateShares(software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListTemplateSharesPublisher publisher = client.listTemplateSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListTemplateSharesPublisher publisher = client.listTemplateSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateShares(software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListTemplateShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTemplateShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateSharesPublisher listTemplateSharesPaginator(ListTemplateSharesRequest listTemplateSharesRequest) {
        return new ListTemplateSharesPublisher(this, listTemplateSharesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTemplateShares(software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListTemplateSharesPublisher publisher = client.listTemplateSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListTemplateSharesPublisher publisher = client.listTemplateSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateShares(software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateSharesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateSharesRequest#builder()}
     * </p>
     *
     * @param listTemplateSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListTemplateSharesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListTemplateShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListTemplateShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTemplateSharesPublisher listTemplateSharesPaginator(
            Consumer<ListTemplateSharesRequest.Builder> listTemplateSharesRequest) {
        return listTemplateSharesPaginator(ListTemplateSharesRequest.builder().applyMutation(listTemplateSharesRequest).build());
    }

    /**
     * <p>
     * List the workload shares associated with the workload.
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        Input for List Workload Share
     * @return A Java Future containing the result of the ListWorkloadShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadSharesResponse> listWorkloadShares(ListWorkloadSharesRequest listWorkloadSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the workload shares associated with the workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadSharesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadSharesRequest#builder()}
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest.Builder} to create
     *        a request. Input for List Workload Share
     * @return A Java Future containing the result of the ListWorkloadShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadSharesResponse> listWorkloadShares(
            Consumer<ListWorkloadSharesRequest.Builder> listWorkloadSharesRequest) {
        return listWorkloadShares(ListWorkloadSharesRequest.builder().applyMutation(listWorkloadSharesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesPublisher publisher = client.listWorkloadSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesPublisher publisher = client.listWorkloadSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        Input for List Workload Share
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadSharesPublisher listWorkloadSharesPaginator(ListWorkloadSharesRequest listWorkloadSharesRequest) {
        return new ListWorkloadSharesPublisher(this, listWorkloadSharesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesPublisher publisher = client.listWorkloadSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesPublisher publisher = client.listWorkloadSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadShares(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadSharesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadSharesRequest#builder()}
     * </p>
     *
     * @param listWorkloadSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest.Builder} to create
     *        a request. Input for List Workload Share
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloadShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloadShares"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadSharesPublisher listWorkloadSharesPaginator(
            Consumer<ListWorkloadSharesRequest.Builder> listWorkloadSharesRequest) {
        return listWorkloadSharesPaginator(ListWorkloadSharesRequest.builder().applyMutation(listWorkloadSharesRequest).build());
    }

    /**
     * <p>
     * Paginated list of workloads.
     * </p>
     *
     * @param listWorkloadsRequest
     *        Input to list all workloads.
     * @return A Java Future containing the result of the ListWorkloads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkloadsResponse> listWorkloads(ListWorkloadsRequest listWorkloadsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Paginated list of workloads.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest.Builder} to create a
     *        request. Input to list all workloads.
     * @return A Java Future containing the result of the ListWorkloads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkloadsResponse> listWorkloads(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest) {
        return listWorkloads(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsPublisher publisher = client.listWorkloadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsPublisher publisher = client.listWorkloadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkloadsRequest
     *        Input to list all workloads.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsPublisher listWorkloadsPaginator(ListWorkloadsRequest listWorkloadsRequest) {
        return new ListWorkloadsPublisher(this, listWorkloadsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsPublisher publisher = client.listWorkloadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsPublisher publisher = client.listWorkloadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest.Builder} to create a
     *        request. Input to list all workloads.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsPublisher listWorkloadsPaginator(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest) {
        return listWorkloadsPaginator(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     * </p>
     * </note>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     * </p>
     * </note>
     * <p>
     * To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:
     * </p>
     * <p>
     * <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code>
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <note>
     * <p>
     * The WorkloadArn parameter can be a workload ARN, a custom lens ARN, a profile ARN, or review template ARN.
     * </p>
     * </note>
     * <p>
     * To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:
     * </p>
     * <p>
     * <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the answer to a specific question in a workload review.
     * </p>
     *
     * @param updateAnswerRequest
     *        Input to update answer.
     * @return A Java Future containing the result of the UpdateAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnswerResponse> updateAnswer(UpdateAnswerRequest updateAnswerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the answer to a specific question in a workload review.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnswerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAnswerRequest#builder()}
     * </p>
     *
     * @param updateAnswerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerRequest.Builder} to create a
     *        request. Input to update answer.
     * @return A Java Future containing the result of the UpdateAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateAnswer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnswerResponse> updateAnswer(Consumer<UpdateAnswerRequest.Builder> updateAnswerRequest) {
        return updateAnswer(UpdateAnswerRequest.builder().applyMutation(updateAnswerRequest).build());
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted into organization sharing and discovery integration
     * features.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            UpdateGlobalSettingsRequest updateGlobalSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted into organization sharing and discovery integration
     * features.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param updateGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateGlobalSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            Consumer<UpdateGlobalSettingsRequest.Builder> updateGlobalSettingsRequest) {
        return updateGlobalSettings(UpdateGlobalSettingsRequest.builder().applyMutation(updateGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Update lens review for a particular workload.
     * </p>
     *
     * @param updateLensReviewRequest
     *        Input for update lens review.
     * @return A Java Future containing the result of the UpdateLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLensReviewResponse> updateLensReview(UpdateLensReviewRequest updateLensReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update lens review for a particular workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLensReviewRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLensReviewRequest#builder()}
     * </p>
     *
     * @param updateLensReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewRequest.Builder} to create a
     *        request. Input for update lens review.
     * @return A Java Future containing the result of the UpdateLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLensReviewResponse> updateLensReview(
            Consumer<UpdateLensReviewRequest.Builder> updateLensReviewRequest) {
        return updateLensReview(UpdateLensReviewRequest.builder().applyMutation(updateLensReviewRequest).build());
    }

    /**
     * <p>
     * Update a profile.
     * </p>
     *
     * @param updateProfileRequest
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(UpdateProfileRequest updateProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest) {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Update a review template.
     * </p>
     *
     * @param updateReviewTemplateRequest
     * @return A Java Future containing the result of the UpdateReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReviewTemplateResponse> updateReviewTemplate(
            UpdateReviewTemplateRequest updateReviewTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a review template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReviewTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateReviewTemplateRequest#builder()}
     * </p>
     *
     * @param updateReviewTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateReviewTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateReviewTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReviewTemplateResponse> updateReviewTemplate(
            Consumer<UpdateReviewTemplateRequest.Builder> updateReviewTemplateRequest) {
        return updateReviewTemplate(UpdateReviewTemplateRequest.builder().applyMutation(updateReviewTemplateRequest).build());
    }

    /**
     * <p>
     * Update a review template answer.
     * </p>
     *
     * @param updateReviewTemplateAnswerRequest
     * @return A Java Future containing the result of the UpdateReviewTemplateAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateReviewTemplateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReviewTemplateAnswerResponse> updateReviewTemplateAnswer(
            UpdateReviewTemplateAnswerRequest updateReviewTemplateAnswerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a review template answer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReviewTemplateAnswerRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateReviewTemplateAnswerRequest#builder()}
     * </p>
     *
     * @param updateReviewTemplateAnswerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateAnswerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateReviewTemplateAnswer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateReviewTemplateAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReviewTemplateAnswerResponse> updateReviewTemplateAnswer(
            Consumer<UpdateReviewTemplateAnswerRequest.Builder> updateReviewTemplateAnswerRequest) {
        return updateReviewTemplateAnswer(UpdateReviewTemplateAnswerRequest.builder()
                .applyMutation(updateReviewTemplateAnswerRequest).build());
    }

    /**
     * <p>
     * Update a lens review associated with a review template.
     * </p>
     *
     * @param updateReviewTemplateLensReviewRequest
     * @return A Java Future containing the result of the UpdateReviewTemplateLensReview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateReviewTemplateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReviewTemplateLensReviewResponse> updateReviewTemplateLensReview(
            UpdateReviewTemplateLensReviewRequest updateReviewTemplateLensReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a lens review associated with a review template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReviewTemplateLensReviewRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateReviewTemplateLensReviewRequest#builder()}
     * </p>
     *
     * @param updateReviewTemplateLensReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateReviewTemplateLensReviewRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateReviewTemplateLensReview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateReviewTemplateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateReviewTemplateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReviewTemplateLensReviewResponse> updateReviewTemplateLensReview(
            Consumer<UpdateReviewTemplateLensReviewRequest.Builder> updateReviewTemplateLensReviewRequest) {
        return updateReviewTemplateLensReview(UpdateReviewTemplateLensReviewRequest.builder()
                .applyMutation(updateReviewTemplateLensReviewRequest).build());
    }

    /**
     * <p>
     * Update a workload or custom lens share invitation.
     * </p>
     * <note>
     * <p>
     * This API operation can be called independently of any resource. Previous documentation implied that a workload
     * ARN must be specified.
     * </p>
     * </note>
     *
     * @param updateShareInvitationRequest
     *        Input for Update Share Invitation
     * @return A Java Future containing the result of the UpdateShareInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateShareInvitationResponse> updateShareInvitation(
            UpdateShareInvitationRequest updateShareInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a workload or custom lens share invitation.
     * </p>
     * <note>
     * <p>
     * This API operation can be called independently of any resource. Previous documentation implied that a workload
     * ARN must be specified.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateShareInvitationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateShareInvitationRequest#builder()}
     * </p>
     *
     * @param updateShareInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationRequest.Builder} to
     *        create a request. Input for Update Share Invitation
     * @return A Java Future containing the result of the UpdateShareInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateShareInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateShareInvitationResponse> updateShareInvitation(
            Consumer<UpdateShareInvitationRequest.Builder> updateShareInvitationRequest) {
        return updateShareInvitation(UpdateShareInvitationRequest.builder().applyMutation(updateShareInvitationRequest).build());
    }

    /**
     * <p>
     * Update an existing workload.
     * </p>
     *
     * @param updateWorkloadRequest
     *        Input to update a workload.
     * @return A Java Future containing the result of the UpdateWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadResponse> updateWorkload(UpdateWorkloadRequest updateWorkloadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkloadRequest#builder()}
     * </p>
     *
     * @param updateWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadRequest.Builder} to create a
     *        request. Input to update a workload.
     * @return A Java Future containing the result of the UpdateWorkload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadResponse> updateWorkload(Consumer<UpdateWorkloadRequest.Builder> updateWorkloadRequest) {
        return updateWorkload(UpdateWorkloadRequest.builder().applyMutation(updateWorkloadRequest).build());
    }

    /**
     * <p>
     * Update a workload share.
     * </p>
     *
     * @param updateWorkloadShareRequest
     *        Input for Update Workload Share
     * @return A Java Future containing the result of the UpdateWorkloadShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadShareResponse> updateWorkloadShare(
            UpdateWorkloadShareRequest updateWorkloadShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a workload share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkloadShareRequest#builder()}
     * </p>
     *
     * @param updateWorkloadShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareRequest.Builder} to create
     *        a request. Input for Update Workload Share
     * @return A Java Future containing the result of the UpdateWorkloadShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpdateWorkloadShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpdateWorkloadShare"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadShareResponse> updateWorkloadShare(
            Consumer<UpdateWorkloadShareRequest.Builder> updateWorkloadShareRequest) {
        return updateWorkloadShare(UpdateWorkloadShareRequest.builder().applyMutation(updateWorkloadShareRequest).build());
    }

    /**
     * <p>
     * Upgrade lens review for a particular workload.
     * </p>
     *
     * @param upgradeLensReviewRequest
     * @return A Java Future containing the result of the UpgradeLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpgradeLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeLensReviewResponse> upgradeLensReview(UpgradeLensReviewRequest upgradeLensReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upgrade lens review for a particular workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeLensReviewRequest.Builder} avoiding the need
     * to create one manually via {@link UpgradeLensReviewRequest#builder()}
     * </p>
     *
     * @param upgradeLensReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpgradeLensReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpgradeLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeLensReviewResponse> upgradeLensReview(
            Consumer<UpgradeLensReviewRequest.Builder> upgradeLensReviewRequest) {
        return upgradeLensReview(UpgradeLensReviewRequest.builder().applyMutation(upgradeLensReviewRequest).build());
    }

    /**
     * <p>
     * Upgrade a profile.
     * </p>
     *
     * @param upgradeProfileVersionRequest
     * @return A Java Future containing the result of the UpgradeProfileVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpgradeProfileVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeProfileVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeProfileVersionResponse> upgradeProfileVersion(
            UpgradeProfileVersionRequest upgradeProfileVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upgrade a profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeProfileVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpgradeProfileVersionRequest#builder()}
     * </p>
     *
     * @param upgradeProfileVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpgradeProfileVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpgradeProfileVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpgradeProfileVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeProfileVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeProfileVersionResponse> upgradeProfileVersion(
            Consumer<UpgradeProfileVersionRequest.Builder> upgradeProfileVersionRequest) {
        return upgradeProfileVersion(UpgradeProfileVersionRequest.builder().applyMutation(upgradeProfileVersionRequest).build());
    }

    /**
     * <p>
     * Upgrade the lens review of a review template.
     * </p>
     *
     * @param upgradeReviewTemplateLensReviewRequest
     * @return A Java Future containing the result of the UpgradeReviewTemplateLensReview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpgradeReviewTemplateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeReviewTemplateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeReviewTemplateLensReviewResponse> upgradeReviewTemplateLensReview(
            UpgradeReviewTemplateLensReviewRequest upgradeReviewTemplateLensReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Upgrade the lens review of a review template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeReviewTemplateLensReviewRequest.Builder}
     * avoiding the need to create one manually via {@link UpgradeReviewTemplateLensReviewRequest#builder()}
     * </p>
     *
     * @param upgradeReviewTemplateLensReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.wellarchitected.model.UpgradeReviewTemplateLensReviewRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpgradeReviewTemplateLensReview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The user input is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ConflictException The resource has already been processed, was deleted, or is too large.</li>
     *         <li>InternalServerException There is a problem with the Well-Architected Tool API service.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WellArchitectedException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample WellArchitectedAsyncClient.UpgradeReviewTemplateLensReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/UpgradeReviewTemplateLensReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpgradeReviewTemplateLensReviewResponse> upgradeReviewTemplateLensReview(
            Consumer<UpgradeReviewTemplateLensReviewRequest.Builder> upgradeReviewTemplateLensReviewRequest) {
        return upgradeReviewTemplateLensReview(UpgradeReviewTemplateLensReviewRequest.builder()
                .applyMutation(upgradeReviewTemplateLensReviewRequest).build());
    }

    @Override
    default WellArchitectedServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link WellArchitectedAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WellArchitectedAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WellArchitectedAsyncClient}.
     */
    static WellArchitectedAsyncClientBuilder builder() {
        return new DefaultWellArchitectedAsyncClientBuilder();
    }
}
