/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workload return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workload implements SdkPojo, Serializable, ToCopyableBuilder<Workload.Builder, Workload> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(Workload::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> WORKLOAD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadArn").getter(getter(Workload::workloadArn)).setter(setter(Builder::workloadArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadArn").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(Workload::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Workload::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Environment").getter(getter(Workload::environmentAsString)).setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(Workload::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(Workload::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AwsRegions")
            .getter(getter(Workload::awsRegions))
            .setter(setter(Builder::awsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NON_AWS_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NonAwsRegions")
            .getter(getter(Workload::nonAwsRegions))
            .setter(setter(Builder::nonAwsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARCHITECTURAL_DESIGN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchitecturalDesign").getter(getter(Workload::architecturalDesign))
            .setter(setter(Builder::architecturalDesign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitecturalDesign").build())
            .build();

    private static final SdkField<String> REVIEW_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewOwner").getter(getter(Workload::reviewOwner)).setter(setter(Builder::reviewOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewOwner").build()).build();

    private static final SdkField<Instant> REVIEW_RESTRICTION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReviewRestrictionDate").getter(getter(Workload::reviewRestrictionDate))
            .setter(setter(Builder::reviewRestrictionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewRestrictionDate").build())
            .build();

    private static final SdkField<Boolean> IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsReviewOwnerUpdateAcknowledged")
            .getter(getter(Workload::isReviewOwnerUpdateAcknowledged))
            .setter(setter(Builder::isReviewOwnerUpdateAcknowledged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsReviewOwnerUpdateAcknowledged")
                    .build()).build();

    private static final SdkField<String> INDUSTRY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndustryType").getter(getter(Workload::industryType)).setter(setter(Builder::industryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndustryType").build()).build();

    private static final SdkField<String> INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Industry").getter(getter(Workload::industry)).setter(setter(Builder::industry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(Workload::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<String> IMPROVEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImprovementStatus").getter(getter(Workload::improvementStatusAsString))
            .setter(setter(Builder::improvementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementStatus").build()).build();

    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("RiskCounts")
            .getter(getter(Workload::riskCountsAsStrings))
            .setter(setter(Builder::riskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PILLAR_PRIORITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PillarPriorities")
            .getter(getter(Workload::pillarPriorities))
            .setter(setter(Builder::pillarPriorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarPriorities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LENSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Lenses")
            .getter(getter(Workload::lenses))
            .setter(setter(Builder::lenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(Workload::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationId").getter(getter(Workload::shareInvitationId))
            .setter(setter(Builder::shareInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Workload::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<WorkloadDiscoveryConfig> DISCOVERY_CONFIG_FIELD = SdkField
            .<WorkloadDiscoveryConfig> builder(MarshallingType.SDK_POJO).memberName("DiscoveryConfig")
            .getter(getter(Workload::discoveryConfig)).setter(setter(Builder::discoveryConfig))
            .constructor(WorkloadDiscoveryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryConfig").build()).build();

    private static final SdkField<List<String>> APPLICATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Applications")
            .getter(getter(Workload::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WorkloadProfile>> PROFILES_FIELD = SdkField
            .<List<WorkloadProfile>> builder(MarshallingType.LIST)
            .memberName("Profiles")
            .getter(getter(Workload::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkloadProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkloadProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> PRIORITIZED_RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("PrioritizedRiskCounts")
            .getter(getter(Workload::prioritizedRiskCountsAsStrings))
            .setter(setter(Builder::prioritizedRiskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrioritizedRiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            WORKLOAD_ARN_FIELD, WORKLOAD_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_FIELD, UPDATED_AT_FIELD, ACCOUNT_IDS_FIELD,
            AWS_REGIONS_FIELD, NON_AWS_REGIONS_FIELD, ARCHITECTURAL_DESIGN_FIELD, REVIEW_OWNER_FIELD,
            REVIEW_RESTRICTION_DATE_FIELD, IS_REVIEW_OWNER_UPDATE_ACKNOWLEDGED_FIELD, INDUSTRY_TYPE_FIELD, INDUSTRY_FIELD,
            NOTES_FIELD, IMPROVEMENT_STATUS_FIELD, RISK_COUNTS_FIELD, PILLAR_PRIORITIES_FIELD, LENSES_FIELD, OWNER_FIELD,
            SHARE_INVITATION_ID_FIELD, TAGS_FIELD, DISCOVERY_CONFIG_FIELD, APPLICATIONS_FIELD, PROFILES_FIELD,
            PRIORITIZED_RISK_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workloadId;

    private final String workloadArn;

    private final String workloadName;

    private final String description;

    private final String environment;

    private final Instant updatedAt;

    private final List<String> accountIds;

    private final List<String> awsRegions;

    private final List<String> nonAwsRegions;

    private final String architecturalDesign;

    private final String reviewOwner;

    private final Instant reviewRestrictionDate;

    private final Boolean isReviewOwnerUpdateAcknowledged;

    private final String industryType;

    private final String industry;

    private final String notes;

    private final String improvementStatus;

    private final Map<String, Integer> riskCounts;

    private final List<String> pillarPriorities;

    private final List<String> lenses;

    private final String owner;

    private final String shareInvitationId;

    private final Map<String, String> tags;

    private final WorkloadDiscoveryConfig discoveryConfig;

    private final List<String> applications;

    private final List<WorkloadProfile> profiles;

    private final Map<String, Integer> prioritizedRiskCounts;

    private Workload(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.workloadArn = builder.workloadArn;
        this.workloadName = builder.workloadName;
        this.description = builder.description;
        this.environment = builder.environment;
        this.updatedAt = builder.updatedAt;
        this.accountIds = builder.accountIds;
        this.awsRegions = builder.awsRegions;
        this.nonAwsRegions = builder.nonAwsRegions;
        this.architecturalDesign = builder.architecturalDesign;
        this.reviewOwner = builder.reviewOwner;
        this.reviewRestrictionDate = builder.reviewRestrictionDate;
        this.isReviewOwnerUpdateAcknowledged = builder.isReviewOwnerUpdateAcknowledged;
        this.industryType = builder.industryType;
        this.industry = builder.industry;
        this.notes = builder.notes;
        this.improvementStatus = builder.improvementStatus;
        this.riskCounts = builder.riskCounts;
        this.pillarPriorities = builder.pillarPriorities;
        this.lenses = builder.lenses;
        this.owner = builder.owner;
        this.shareInvitationId = builder.shareInvitationId;
        this.tags = builder.tags;
        this.discoveryConfig = builder.discoveryConfig;
        this.applications = builder.applications;
        this.profiles = builder.profiles;
        this.prioritizedRiskCounts = builder.prioritizedRiskCounts;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the WorkloadArn property for this object.
     * 
     * @return The value of the WorkloadArn property for this object.
     */
    public final String workloadArn() {
        return workloadArn;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the Environment property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environment} will
     * return {@link WorkloadEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentAsString}.
     * </p>
     * 
     * @return The value of the Environment property for this object.
     * @see WorkloadEnvironment
     */
    public final WorkloadEnvironment environment() {
        return WorkloadEnvironment.fromValue(environment);
    }

    /**
     * Returns the value of the Environment property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environment} will
     * return {@link WorkloadEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentAsString}.
     * </p>
     * 
     * @return The value of the Environment property for this object.
     * @see WorkloadEnvironment
     */
    public final String environmentAsString() {
        return environment;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AccountIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The value of the AccountIds property for this object.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsRegions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAwsRegions() {
        return awsRegions != null && !(awsRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AwsRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsRegions} method.
     * </p>
     * 
     * @return The value of the AwsRegions property for this object.
     */
    public final List<String> awsRegions() {
        return awsRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the NonAwsRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNonAwsRegions() {
        return nonAwsRegions != null && !(nonAwsRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the NonAwsRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNonAwsRegions} method.
     * </p>
     * 
     * @return The value of the NonAwsRegions property for this object.
     */
    public final List<String> nonAwsRegions() {
        return nonAwsRegions;
    }

    /**
     * Returns the value of the ArchitecturalDesign property for this object.
     * 
     * @return The value of the ArchitecturalDesign property for this object.
     */
    public final String architecturalDesign() {
        return architecturalDesign;
    }

    /**
     * Returns the value of the ReviewOwner property for this object.
     * 
     * @return The value of the ReviewOwner property for this object.
     */
    public final String reviewOwner() {
        return reviewOwner;
    }

    /**
     * Returns the value of the ReviewRestrictionDate property for this object.
     * 
     * @return The value of the ReviewRestrictionDate property for this object.
     */
    public final Instant reviewRestrictionDate() {
        return reviewRestrictionDate;
    }

    /**
     * <p>
     * Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.
     * </p>
     * <p>
     * If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload
     * is restricted until an owner is added.
     * </p>
     * 
     * @return Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is
     *         required.</p>
     *         <p>
     *         If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the
     *         workload is restricted until an owner is added.
     */
    public final Boolean isReviewOwnerUpdateAcknowledged() {
        return isReviewOwnerUpdateAcknowledged;
    }

    /**
     * Returns the value of the IndustryType property for this object.
     * 
     * @return The value of the IndustryType property for this object.
     */
    public final String industryType() {
        return industryType;
    }

    /**
     * Returns the value of the Industry property for this object.
     * 
     * @return The value of the Industry property for this object.
     */
    public final String industry() {
        return industry;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * Returns the value of the ImprovementStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #improvementStatus}
     * will return {@link WorkloadImprovementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #improvementStatusAsString}.
     * </p>
     * 
     * @return The value of the ImprovementStatus property for this object.
     * @see WorkloadImprovementStatus
     */
    public final WorkloadImprovementStatus improvementStatus() {
        return WorkloadImprovementStatus.fromValue(improvementStatus);
    }

    /**
     * Returns the value of the ImprovementStatus property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #improvementStatus}
     * will return {@link WorkloadImprovementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #improvementStatusAsString}.
     * </p>
     * 
     * @return The value of the ImprovementStatus property for this object.
     * @see WorkloadImprovementStatus
     */
    public final String improvementStatusAsString() {
        return improvementStatus;
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(riskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskCounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRiskCounts() {
        return riskCounts != null && !(riskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<String, Integer> riskCountsAsStrings() {
        return riskCounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the PillarPriorities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPillarPriorities() {
        return pillarPriorities != null && !(pillarPriorities instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the PillarPriorities property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillarPriorities} method.
     * </p>
     * 
     * @return The value of the PillarPriorities property for this object.
     */
    public final List<String> pillarPriorities() {
        return pillarPriorities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lenses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLenses() {
        return lenses != null && !(lenses instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Lenses property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLenses} method.
     * </p>
     * 
     * @return The value of the Lenses property for this object.
     */
    public final List<String> lenses() {
        return lenses;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The ID assigned to the share invitation.
     * </p>
     * 
     * @return The ID assigned to the share invitation.
     */
    public final String shareInvitationId() {
        return shareInvitationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the workload.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Discovery configuration associated to the workload.
     * </p>
     * 
     * @return Discovery configuration associated to the workload.
     */
    public final WorkloadDiscoveryConfig discoveryConfig() {
        return discoveryConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Applications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of AppRegistry application ARNs associated to the workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplications} method.
     * </p>
     * 
     * @return List of AppRegistry application ARNs associated to the workload.
     */
    public final List<String> applications() {
        return applications;
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Profile associated with a workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return Profile associated with a workload.
     */
    public final List<WorkloadProfile> profiles() {
        return profiles;
    }

    /**
     * Returns the value of the PrioritizedRiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrioritizedRiskCounts} method.
     * </p>
     * 
     * @return The value of the PrioritizedRiskCounts property for this object.
     */
    public final Map<Risk, Integer> prioritizedRiskCounts() {
        return RiskCountsCopier.copyStringToEnum(prioritizedRiskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the PrioritizedRiskCounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrioritizedRiskCounts() {
        return prioritizedRiskCounts != null && !(prioritizedRiskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the PrioritizedRiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrioritizedRiskCounts} method.
     * </p>
     * 
     * @return The value of the PrioritizedRiskCounts property for this object.
     */
    public final Map<String, Integer> prioritizedRiskCountsAsStrings() {
        return prioritizedRiskCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadArn());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsRegions() ? awsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNonAwsRegions() ? nonAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(architecturalDesign());
        hashCode = 31 * hashCode + Objects.hashCode(reviewOwner());
        hashCode = 31 * hashCode + Objects.hashCode(reviewRestrictionDate());
        hashCode = 31 * hashCode + Objects.hashCode(isReviewOwnerUpdateAcknowledged());
        hashCode = 31 * hashCode + Objects.hashCode(industryType());
        hashCode = 31 * hashCode + Objects.hashCode(industry());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(improvementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskCounts() ? riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPillarPriorities() ? pillarPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLenses() ? lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(discoveryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplications() ? applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrioritizedRiskCounts() ? prioritizedRiskCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workload)) {
            return false;
        }
        Workload other = (Workload) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(workloadArn(), other.workloadArn())
                && Objects.equals(workloadName(), other.workloadName()) && Objects.equals(description(), other.description())
                && Objects.equals(environmentAsString(), other.environmentAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasAccountIds() == other.hasAccountIds()
                && Objects.equals(accountIds(), other.accountIds()) && hasAwsRegions() == other.hasAwsRegions()
                && Objects.equals(awsRegions(), other.awsRegions()) && hasNonAwsRegions() == other.hasNonAwsRegions()
                && Objects.equals(nonAwsRegions(), other.nonAwsRegions())
                && Objects.equals(architecturalDesign(), other.architecturalDesign())
                && Objects.equals(reviewOwner(), other.reviewOwner())
                && Objects.equals(reviewRestrictionDate(), other.reviewRestrictionDate())
                && Objects.equals(isReviewOwnerUpdateAcknowledged(), other.isReviewOwnerUpdateAcknowledged())
                && Objects.equals(industryType(), other.industryType()) && Objects.equals(industry(), other.industry())
                && Objects.equals(notes(), other.notes())
                && Objects.equals(improvementStatusAsString(), other.improvementStatusAsString())
                && hasRiskCounts() == other.hasRiskCounts() && Objects.equals(riskCountsAsStrings(), other.riskCountsAsStrings())
                && hasPillarPriorities() == other.hasPillarPriorities()
                && Objects.equals(pillarPriorities(), other.pillarPriorities()) && hasLenses() == other.hasLenses()
                && Objects.equals(lenses(), other.lenses()) && Objects.equals(owner(), other.owner())
                && Objects.equals(shareInvitationId(), other.shareInvitationId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(discoveryConfig(), other.discoveryConfig())
                && hasApplications() == other.hasApplications() && Objects.equals(applications(), other.applications())
                && hasProfiles() == other.hasProfiles() && Objects.equals(profiles(), other.profiles())
                && hasPrioritizedRiskCounts() == other.hasPrioritizedRiskCounts()
                && Objects.equals(prioritizedRiskCountsAsStrings(), other.prioritizedRiskCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Workload").add("WorkloadId", workloadId()).add("WorkloadArn", workloadArn())
                .add("WorkloadName", workloadName()).add("Description", description()).add("Environment", environmentAsString())
                .add("UpdatedAt", updatedAt()).add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("AwsRegions", hasAwsRegions() ? awsRegions() : null)
                .add("NonAwsRegions", hasNonAwsRegions() ? nonAwsRegions() : null)
                .add("ArchitecturalDesign", architecturalDesign()).add("ReviewOwner", reviewOwner())
                .add("ReviewRestrictionDate", reviewRestrictionDate())
                .add("IsReviewOwnerUpdateAcknowledged", isReviewOwnerUpdateAcknowledged()).add("IndustryType", industryType())
                .add("Industry", industry()).add("Notes", notes()).add("ImprovementStatus", improvementStatusAsString())
                .add("RiskCounts", hasRiskCounts() ? riskCountsAsStrings() : null)
                .add("PillarPriorities", hasPillarPriorities() ? pillarPriorities() : null)
                .add("Lenses", hasLenses() ? lenses() : null).add("Owner", owner()).add("ShareInvitationId", shareInvitationId())
                .add("Tags", hasTags() ? tags() : null).add("DiscoveryConfig", discoveryConfig())
                .add("Applications", hasApplications() ? applications() : null)
                .add("Profiles", hasProfiles() ? profiles() : null)
                .add("PrioritizedRiskCounts", hasPrioritizedRiskCounts() ? prioritizedRiskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadArn":
            return Optional.ofNullable(clazz.cast(workloadArn()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environmentAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "AwsRegions":
            return Optional.ofNullable(clazz.cast(awsRegions()));
        case "NonAwsRegions":
            return Optional.ofNullable(clazz.cast(nonAwsRegions()));
        case "ArchitecturalDesign":
            return Optional.ofNullable(clazz.cast(architecturalDesign()));
        case "ReviewOwner":
            return Optional.ofNullable(clazz.cast(reviewOwner()));
        case "ReviewRestrictionDate":
            return Optional.ofNullable(clazz.cast(reviewRestrictionDate()));
        case "IsReviewOwnerUpdateAcknowledged":
            return Optional.ofNullable(clazz.cast(isReviewOwnerUpdateAcknowledged()));
        case "IndustryType":
            return Optional.ofNullable(clazz.cast(industryType()));
        case "Industry":
            return Optional.ofNullable(clazz.cast(industry()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "ImprovementStatus":
            return Optional.ofNullable(clazz.cast(improvementStatusAsString()));
        case "RiskCounts":
            return Optional.ofNullable(clazz.cast(riskCountsAsStrings()));
        case "PillarPriorities":
            return Optional.ofNullable(clazz.cast(pillarPriorities()));
        case "Lenses":
            return Optional.ofNullable(clazz.cast(lenses()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ShareInvitationId":
            return Optional.ofNullable(clazz.cast(shareInvitationId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DiscoveryConfig":
            return Optional.ofNullable(clazz.cast(discoveryConfig()));
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "Profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        case "PrioritizedRiskCounts":
            return Optional.ofNullable(clazz.cast(prioritizedRiskCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workload, T> g) {
        return obj -> g.apply((Workload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workload> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the WorkloadArn property for this object.
         *
         * @param workloadArn
         *        The new value for the WorkloadArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadArn(String workloadArn);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Environment property for this object.
         *
         * @param environment
         *        The new value for the Environment property for this object.
         * @see WorkloadEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEnvironment
         */
        Builder environment(String environment);

        /**
         * Sets the value of the Environment property for this object.
         *
         * @param environment
         *        The new value for the Environment property for this object.
         * @see WorkloadEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadEnvironment
         */
        Builder environment(WorkloadEnvironment environment);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the AccountIds property for this object.
         *
         * @param accountIds
         *        The new value for the AccountIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * Sets the value of the AccountIds property for this object.
         *
         * @param accountIds
         *        The new value for the AccountIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * Sets the value of the AwsRegions property for this object.
         *
         * @param awsRegions
         *        The new value for the AwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(Collection<String> awsRegions);

        /**
         * Sets the value of the AwsRegions property for this object.
         *
         * @param awsRegions
         *        The new value for the AwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegions(String... awsRegions);

        /**
         * Sets the value of the NonAwsRegions property for this object.
         *
         * @param nonAwsRegions
         *        The new value for the NonAwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAwsRegions(Collection<String> nonAwsRegions);

        /**
         * Sets the value of the NonAwsRegions property for this object.
         *
         * @param nonAwsRegions
         *        The new value for the NonAwsRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonAwsRegions(String... nonAwsRegions);

        /**
         * Sets the value of the ArchitecturalDesign property for this object.
         *
         * @param architecturalDesign
         *        The new value for the ArchitecturalDesign property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturalDesign(String architecturalDesign);

        /**
         * Sets the value of the ReviewOwner property for this object.
         *
         * @param reviewOwner
         *        The new value for the ReviewOwner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewOwner(String reviewOwner);

        /**
         * Sets the value of the ReviewRestrictionDate property for this object.
         *
         * @param reviewRestrictionDate
         *        The new value for the ReviewRestrictionDate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewRestrictionDate(Instant reviewRestrictionDate);

        /**
         * <p>
         * Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.
         * </p>
         * <p>
         * If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the
         * workload is restricted until an owner is added.
         * </p>
         * 
         * @param isReviewOwnerUpdateAcknowledged
         *        Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is
         *        required.</p>
         *        <p>
         *        If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the
         *        workload is restricted until an owner is added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged);

        /**
         * Sets the value of the IndustryType property for this object.
         *
         * @param industryType
         *        The new value for the IndustryType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder industryType(String industryType);

        /**
         * Sets the value of the Industry property for this object.
         *
         * @param industry
         *        The new value for the Industry property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder industry(String industry);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * Sets the value of the ImprovementStatus property for this object.
         *
         * @param improvementStatus
         *        The new value for the ImprovementStatus property for this object.
         * @see WorkloadImprovementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadImprovementStatus
         */
        Builder improvementStatus(String improvementStatus);

        /**
         * Sets the value of the ImprovementStatus property for this object.
         *
         * @param improvementStatus
         *        The new value for the ImprovementStatus property for this object.
         * @see WorkloadImprovementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadImprovementStatus
         */
        Builder improvementStatus(WorkloadImprovementStatus improvementStatus);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCountsWithStrings(Map<String, Integer> riskCounts);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCounts(Map<Risk, Integer> riskCounts);

        /**
         * Sets the value of the PillarPriorities property for this object.
         *
         * @param pillarPriorities
         *        The new value for the PillarPriorities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarPriorities(Collection<String> pillarPriorities);

        /**
         * Sets the value of the PillarPriorities property for this object.
         *
         * @param pillarPriorities
         *        The new value for the PillarPriorities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarPriorities(String... pillarPriorities);

        /**
         * Sets the value of the Lenses property for this object.
         *
         * @param lenses
         *        The new value for the Lenses property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(Collection<String> lenses);

        /**
         * Sets the value of the Lenses property for this object.
         *
         * @param lenses
         *        The new value for the Lenses property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(String... lenses);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The ID assigned to the share invitation.
         * </p>
         * 
         * @param shareInvitationId
         *        The ID assigned to the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationId(String shareInvitationId);

        /**
         * <p>
         * The tags associated with the workload.
         * </p>
         * 
         * @param tags
         *        The tags associated with the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Discovery configuration associated to the workload.
         * </p>
         * 
         * @param discoveryConfig
         *        Discovery configuration associated to the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryConfig(WorkloadDiscoveryConfig discoveryConfig);

        /**
         * <p>
         * Discovery configuration associated to the workload.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadDiscoveryConfig.Builder} avoiding
         * the need to create one manually via {@link WorkloadDiscoveryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadDiscoveryConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #discoveryConfig(WorkloadDiscoveryConfig)}.
         * 
         * @param discoveryConfig
         *        a consumer that will call methods on {@link WorkloadDiscoveryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #discoveryConfig(WorkloadDiscoveryConfig)
         */
        default Builder discoveryConfig(Consumer<WorkloadDiscoveryConfig.Builder> discoveryConfig) {
            return discoveryConfig(WorkloadDiscoveryConfig.builder().applyMutation(discoveryConfig).build());
        }

        /**
         * <p>
         * List of AppRegistry application ARNs associated to the workload.
         * </p>
         * 
         * @param applications
         *        List of AppRegistry application ARNs associated to the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<String> applications);

        /**
         * <p>
         * List of AppRegistry application ARNs associated to the workload.
         * </p>
         * 
         * @param applications
         *        List of AppRegistry application ARNs associated to the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(String... applications);

        /**
         * <p>
         * Profile associated with a workload.
         * </p>
         * 
         * @param profiles
         *        Profile associated with a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<WorkloadProfile> profiles);

        /**
         * <p>
         * Profile associated with a workload.
         * </p>
         * 
         * @param profiles
         *        Profile associated with a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(WorkloadProfile... profiles);

        /**
         * <p>
         * Profile associated with a workload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #profiles(List<WorkloadProfile>)}.
         * 
         * @param profiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profiles(java.util.Collection<WorkloadProfile>)
         */
        Builder profiles(Consumer<WorkloadProfile.Builder>... profiles);

        /**
         * Sets the value of the PrioritizedRiskCounts property for this object.
         *
         * @param prioritizedRiskCounts
         *        The new value for the PrioritizedRiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts);

        /**
         * Sets the value of the PrioritizedRiskCounts property for this object.
         *
         * @param prioritizedRiskCounts
         *        The new value for the PrioritizedRiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts);
    }

    static final class BuilderImpl implements Builder {
        private String workloadId;

        private String workloadArn;

        private String workloadName;

        private String description;

        private String environment;

        private Instant updatedAt;

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();

        private List<String> nonAwsRegions = DefaultSdkAutoConstructList.getInstance();

        private String architecturalDesign;

        private String reviewOwner;

        private Instant reviewRestrictionDate;

        private Boolean isReviewOwnerUpdateAcknowledged;

        private String industryType;

        private String industry;

        private String notes;

        private String improvementStatus;

        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private List<String> pillarPriorities = DefaultSdkAutoConstructList.getInstance();

        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();

        private String owner;

        private String shareInvitationId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private WorkloadDiscoveryConfig discoveryConfig;

        private List<String> applications = DefaultSdkAutoConstructList.getInstance();

        private List<WorkloadProfile> profiles = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Integer> prioritizedRiskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Workload model) {
            workloadId(model.workloadId);
            workloadArn(model.workloadArn);
            workloadName(model.workloadName);
            description(model.description);
            environment(model.environment);
            updatedAt(model.updatedAt);
            accountIds(model.accountIds);
            awsRegions(model.awsRegions);
            nonAwsRegions(model.nonAwsRegions);
            architecturalDesign(model.architecturalDesign);
            reviewOwner(model.reviewOwner);
            reviewRestrictionDate(model.reviewRestrictionDate);
            isReviewOwnerUpdateAcknowledged(model.isReviewOwnerUpdateAcknowledged);
            industryType(model.industryType);
            industry(model.industry);
            notes(model.notes);
            improvementStatus(model.improvementStatus);
            riskCountsWithStrings(model.riskCounts);
            pillarPriorities(model.pillarPriorities);
            lenses(model.lenses);
            owner(model.owner);
            shareInvitationId(model.shareInvitationId);
            tags(model.tags);
            discoveryConfig(model.discoveryConfig);
            applications(model.applications);
            profiles(model.profiles);
            prioritizedRiskCountsWithStrings(model.prioritizedRiskCounts);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadArn() {
            return workloadArn;
        }

        public final void setWorkloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
        }

        @Override
        public final Builder workloadArn(String workloadArn) {
            this.workloadArn = workloadArn;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironment() {
            return environment;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        @Override
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public final Builder environment(WorkloadEnvironment environment) {
            this.environment(environment == null ? null : environment.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getAwsRegions() {
            if (awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return awsRegions;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String... awsRegions) {
            awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final Collection<String> getNonAwsRegions() {
            if (nonAwsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return nonAwsRegions;
        }

        public final void setNonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
        }

        @Override
        public final Builder nonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonAwsRegions(String... nonAwsRegions) {
            nonAwsRegions(Arrays.asList(nonAwsRegions));
            return this;
        }

        public final String getArchitecturalDesign() {
            return architecturalDesign;
        }

        public final void setArchitecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
        }

        @Override
        public final Builder architecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
            return this;
        }

        public final String getReviewOwner() {
            return reviewOwner;
        }

        public final void setReviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
        }

        @Override
        public final Builder reviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
            return this;
        }

        public final Instant getReviewRestrictionDate() {
            return reviewRestrictionDate;
        }

        public final void setReviewRestrictionDate(Instant reviewRestrictionDate) {
            this.reviewRestrictionDate = reviewRestrictionDate;
        }

        @Override
        public final Builder reviewRestrictionDate(Instant reviewRestrictionDate) {
            this.reviewRestrictionDate = reviewRestrictionDate;
            return this;
        }

        public final Boolean getIsReviewOwnerUpdateAcknowledged() {
            return isReviewOwnerUpdateAcknowledged;
        }

        public final void setIsReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
        }

        @Override
        public final Builder isReviewOwnerUpdateAcknowledged(Boolean isReviewOwnerUpdateAcknowledged) {
            this.isReviewOwnerUpdateAcknowledged = isReviewOwnerUpdateAcknowledged;
            return this;
        }

        public final String getIndustryType() {
            return industryType;
        }

        public final void setIndustryType(String industryType) {
            this.industryType = industryType;
        }

        @Override
        public final Builder industryType(String industryType) {
            this.industryType = industryType;
            return this;
        }

        public final String getIndustry() {
            return industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getImprovementStatus() {
            return improvementStatus;
        }

        public final void setImprovementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
        }

        @Override
        public final Builder improvementStatus(String improvementStatus) {
            this.improvementStatus = improvementStatus;
            return this;
        }

        @Override
        public final Builder improvementStatus(WorkloadImprovementStatus improvementStatus) {
            this.improvementStatus(improvementStatus == null ? null : improvementStatus.toString());
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final Collection<String> getPillarPriorities() {
            if (pillarPriorities instanceof SdkAutoConstructList) {
                return null;
            }
            return pillarPriorities;
        }

        public final void setPillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
        }

        @Override
        public final Builder pillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarPriorities(String... pillarPriorities) {
            pillarPriorities(Arrays.asList(pillarPriorities));
            return this;
        }

        public final Collection<String> getLenses() {
            if (lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String... lenses) {
            lenses(Arrays.asList(lenses));
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getShareInvitationId() {
            return shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final WorkloadDiscoveryConfig.Builder getDiscoveryConfig() {
            return discoveryConfig != null ? discoveryConfig.toBuilder() : null;
        }

        public final void setDiscoveryConfig(WorkloadDiscoveryConfig.BuilderImpl discoveryConfig) {
            this.discoveryConfig = discoveryConfig != null ? discoveryConfig.build() : null;
        }

        @Override
        public final Builder discoveryConfig(WorkloadDiscoveryConfig discoveryConfig) {
            this.discoveryConfig = discoveryConfig;
            return this;
        }

        public final Collection<String> getApplications() {
            if (applications instanceof SdkAutoConstructList) {
                return null;
            }
            return applications;
        }

        public final void setApplications(Collection<String> applications) {
            this.applications = WorkloadApplicationsCopier.copy(applications);
        }

        @Override
        public final Builder applications(Collection<String> applications) {
            this.applications = WorkloadApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(String... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        public final List<WorkloadProfile.Builder> getProfiles() {
            List<WorkloadProfile.Builder> result = WorkloadProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<WorkloadProfile.BuilderImpl> profiles) {
            this.profiles = WorkloadProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<WorkloadProfile> profiles) {
            this.profiles = WorkloadProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(WorkloadProfile... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<WorkloadProfile.Builder>... profiles) {
            profiles(Stream.of(profiles).map(c -> WorkloadProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getPrioritizedRiskCounts() {
            if (prioritizedRiskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return prioritizedRiskCounts;
        }

        public final void setPrioritizedRiskCounts(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
        }

        @Override
        public final Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
            return this;
        }

        @Override
        public final Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copyEnumToString(prioritizedRiskCounts);
            return this;
        }

        @Override
        public Workload build() {
            return new Workload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
