/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateLensAliasesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReviewTemplateRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateReviewTemplateRequest> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(UpdateReviewTemplateRequest.getter(UpdateReviewTemplateRequest::templateArn)).setter(UpdateReviewTemplateRequest.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(UpdateReviewTemplateRequest.getter(UpdateReviewTemplateRequest::templateName)).setter(UpdateReviewTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateReviewTemplateRequest.getter(UpdateReviewTemplateRequest::description)).setter(UpdateReviewTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(UpdateReviewTemplateRequest.getter(UpdateReviewTemplateRequest::notes)).setter(UpdateReviewTemplateRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<List<String>> LENSES_TO_ASSOCIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LensesToAssociate").getter(UpdateReviewTemplateRequest.getter(UpdateReviewTemplateRequest::lensesToAssociate)).setter(UpdateReviewTemplateRequest.setter(Builder::lensesToAssociate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensesToAssociate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LENSES_TO_DISASSOCIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LensesToDisassociate").getter(UpdateReviewTemplateRequest.getter(UpdateReviewTemplateRequest::lensesToDisassociate)).setter(UpdateReviewTemplateRequest.setter(Builder::lensesToDisassociate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensesToDisassociate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD, TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, NOTES_FIELD, LENSES_TO_ASSOCIATE_FIELD, LENSES_TO_DISASSOCIATE_FIELD));
    private final String templateArn;
    private final String templateName;
    private final String description;
    private final String notes;
    private final List<String> lensesToAssociate;
    private final List<String> lensesToDisassociate;

    private UpdateReviewTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.notes = builder.notes;
        this.lensesToAssociate = builder.lensesToAssociate;
        this.lensesToDisassociate = builder.lensesToDisassociate;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String description() {
        return this.description;
    }

    public final String notes() {
        return this.notes;
    }

    public final boolean hasLensesToAssociate() {
        return this.lensesToAssociate != null && !(this.lensesToAssociate instanceof SdkAutoConstructList);
    }

    public final List<String> lensesToAssociate() {
        return this.lensesToAssociate;
    }

    public final boolean hasLensesToDisassociate() {
        return this.lensesToDisassociate != null && !(this.lensesToDisassociate instanceof SdkAutoConstructList);
    }

    public final List<String> lensesToDisassociate() {
        return this.lensesToDisassociate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLensesToAssociate() ? this.lensesToAssociate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLensesToDisassociate() ? this.lensesToDisassociate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReviewTemplateRequest)) {
            return false;
        }
        UpdateReviewTemplateRequest other = (UpdateReviewTemplateRequest)((Object)obj);
        return Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.notes(), other.notes()) && this.hasLensesToAssociate() == other.hasLensesToAssociate() && Objects.equals(this.lensesToAssociate(), other.lensesToAssociate()) && this.hasLensesToDisassociate() == other.hasLensesToDisassociate() && Objects.equals(this.lensesToDisassociate(), other.lensesToDisassociate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReviewTemplateRequest").add("TemplateArn", (Object)this.templateArn()).add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("Notes", (Object)this.notes()).add("LensesToAssociate", this.hasLensesToAssociate() ? this.lensesToAssociate() : null).add("LensesToDisassociate", this.hasLensesToDisassociate() ? this.lensesToDisassociate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "LensesToAssociate": {
                return Optional.ofNullable(clazz.cast(this.lensesToAssociate()));
            }
            case "LensesToDisassociate": {
                return Optional.ofNullable(clazz.cast(this.lensesToDisassociate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReviewTemplateRequest, T> g) {
        return obj -> g.apply((UpdateReviewTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String templateArn;
        private String templateName;
        private String description;
        private String notes;
        private List<String> lensesToAssociate = DefaultSdkAutoConstructList.getInstance();
        private List<String> lensesToDisassociate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReviewTemplateRequest model) {
            super(model);
            this.templateArn(model.templateArn);
            this.templateName(model.templateName);
            this.description(model.description);
            this.notes(model.notes);
            this.lensesToAssociate(model.lensesToAssociate);
            this.lensesToDisassociate(model.lensesToDisassociate);
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Collection<String> getLensesToAssociate() {
            if (this.lensesToAssociate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lensesToAssociate;
        }

        public final void setLensesToAssociate(Collection<String> lensesToAssociate) {
            this.lensesToAssociate = ReviewTemplateLensAliasesCopier.copy(lensesToAssociate);
        }

        @Override
        public final Builder lensesToAssociate(Collection<String> lensesToAssociate) {
            this.lensesToAssociate = ReviewTemplateLensAliasesCopier.copy(lensesToAssociate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensesToAssociate(String ... lensesToAssociate) {
            this.lensesToAssociate(Arrays.asList(lensesToAssociate));
            return this;
        }

        public final Collection<String> getLensesToDisassociate() {
            if (this.lensesToDisassociate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lensesToDisassociate;
        }

        public final void setLensesToDisassociate(Collection<String> lensesToDisassociate) {
            this.lensesToDisassociate = ReviewTemplateLensAliasesCopier.copy(lensesToDisassociate);
        }

        @Override
        public final Builder lensesToDisassociate(Collection<String> lensesToDisassociate) {
            this.lensesToDisassociate = ReviewTemplateLensAliasesCopier.copy(lensesToDisassociate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensesToDisassociate(String ... lensesToDisassociate) {
            this.lensesToDisassociate(Arrays.asList(lensesToDisassociate));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReviewTemplateRequest build() {
            return new UpdateReviewTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReviewTemplateRequest> {
        public Builder templateArn(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder notes(String var1);

        public Builder lensesToAssociate(Collection<String> var1);

        public Builder lensesToAssociate(String ... var1);

        public Builder lensesToDisassociate(Collection<String> var1);

        public Builder lensesToDisassociate(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

