/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An answer summary of a lens review in a workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnswerSummary implements SdkPojo, Serializable, ToCopyableBuilder<AnswerSummary.Builder, AnswerSummary> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(AnswerSummary::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(AnswerSummary::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionTitle").getter(getter(AnswerSummary::questionTitle)).setter(setter(Builder::questionTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()).build();

    private static final SdkField<List<Choice>> CHOICES_FIELD = SdkField
            .<List<Choice>> builder(MarshallingType.LIST)
            .memberName("Choices")
            .getter(getter(AnswerSummary::choices))
            .setter(setter(Builder::choices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Choices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Choice> builder(MarshallingType.SDK_POJO)
                                            .constructor(Choice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedChoices")
            .getter(getter(AnswerSummary::selectedChoices))
            .setter(setter(Builder::selectedChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ChoiceAnswerSummary>> CHOICE_ANSWER_SUMMARIES_FIELD = SdkField
            .<List<ChoiceAnswerSummary>> builder(MarshallingType.LIST)
            .memberName("ChoiceAnswerSummaries")
            .getter(getter(AnswerSummary::choiceAnswerSummaries))
            .setter(setter(Builder::choiceAnswerSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceAnswerSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChoiceAnswerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChoiceAnswerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsApplicable").getter(getter(AnswerSummary::isApplicable)).setter(setter(Builder::isApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()).build();

    private static final SdkField<String> RISK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Risk")
            .getter(getter(AnswerSummary::riskAsString)).setter(setter(Builder::risk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(AnswerSummary::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> QUESTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionType").getter(getter(AnswerSummary::questionTypeAsString)).setter(setter(Builder::questionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionType").build()).build();

    private static final SdkField<JiraConfiguration> JIRA_CONFIGURATION_FIELD = SdkField
            .<JiraConfiguration> builder(MarshallingType.SDK_POJO).memberName("JiraConfiguration")
            .getter(getter(AnswerSummary::jiraConfiguration)).setter(setter(Builder::jiraConfiguration))
            .constructor(JiraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD,
            PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, CHOICES_FIELD, SELECTED_CHOICES_FIELD, CHOICE_ANSWER_SUMMARIES_FIELD,
            IS_APPLICABLE_FIELD, RISK_FIELD, REASON_FIELD, QUESTION_TYPE_FIELD, JIRA_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final String pillarId;

    private final String questionTitle;

    private final List<Choice> choices;

    private final List<String> selectedChoices;

    private final List<ChoiceAnswerSummary> choiceAnswerSummaries;

    private final Boolean isApplicable;

    private final String risk;

    private final String reason;

    private final String questionType;

    private final JiraConfiguration jiraConfiguration;

    private AnswerSummary(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.choices = builder.choices;
        this.selectedChoices = builder.selectedChoices;
        this.choiceAnswerSummaries = builder.choiceAnswerSummaries;
        this.isApplicable = builder.isApplicable;
        this.risk = builder.risk;
        this.reason = builder.reason;
        this.questionType = builder.questionType;
        this.jiraConfiguration = builder.jiraConfiguration;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the QuestionTitle property for this object.
     * 
     * @return The value of the QuestionTitle property for this object.
     */
    public final String questionTitle() {
        return questionTitle;
    }

    /**
     * For responses, this returns true if the service returned a value for the Choices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChoices() {
        return choices != null && !(choices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Choices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChoices} method.
     * </p>
     * 
     * @return The value of the Choices property for this object.
     */
    public final List<Choice> choices() {
        return choices;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedChoices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedChoices() {
        return selectedChoices != null && !(selectedChoices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SelectedChoices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedChoices} method.
     * </p>
     * 
     * @return The value of the SelectedChoices property for this object.
     */
    public final List<String> selectedChoices() {
        return selectedChoices;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChoiceAnswerSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasChoiceAnswerSummaries() {
        return choiceAnswerSummaries != null && !(choiceAnswerSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of selected choices to a question in your workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChoiceAnswerSummaries} method.
     * </p>
     * 
     * @return A list of selected choices to a question in your workload.
     */
    public final List<ChoiceAnswerSummary> choiceAnswerSummaries() {
        return choiceAnswerSummaries;
    }

    /**
     * Returns the value of the IsApplicable property for this object.
     * 
     * @return The value of the IsApplicable property for this object.
     */
    public final Boolean isApplicable() {
        return isApplicable;
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final Risk risk() {
        return Risk.fromValue(risk);
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final String riskAsString() {
        return risk;
    }

    /**
     * <p>
     * The reason why a choice is non-applicable to a question in your workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link AnswerReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason why a choice is non-applicable to a question in your workload.
     * @see AnswerReason
     */
    public final AnswerReason reason() {
        return AnswerReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason why a choice is non-applicable to a question in your workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link AnswerReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason why a choice is non-applicable to a question in your workload.
     * @see AnswerReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The type of the question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #questionType} will
     * return {@link QuestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #questionTypeAsString}.
     * </p>
     * 
     * @return The type of the question.
     * @see QuestionType
     */
    public final QuestionType questionType() {
        return QuestionType.fromValue(questionType);
    }

    /**
     * <p>
     * The type of the question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #questionType} will
     * return {@link QuestionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #questionTypeAsString}.
     * </p>
     * 
     * @return The type of the question.
     * @see QuestionType
     */
    public final String questionTypeAsString() {
        return questionType;
    }

    /**
     * <p>
     * Configuration of the Jira integration.
     * </p>
     * 
     * @return Configuration of the Jira integration.
     */
    public final JiraConfiguration jiraConfiguration() {
        return jiraConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(hasChoices() ? choices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedChoices() ? selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChoiceAnswerSummaries() ? choiceAnswerSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(questionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jiraConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnswerSummary)) {
            return false;
        }
        AnswerSummary other = (AnswerSummary) obj;
        return Objects.equals(questionId(), other.questionId()) && Objects.equals(pillarId(), other.pillarId())
                && Objects.equals(questionTitle(), other.questionTitle()) && hasChoices() == other.hasChoices()
                && Objects.equals(choices(), other.choices()) && hasSelectedChoices() == other.hasSelectedChoices()
                && Objects.equals(selectedChoices(), other.selectedChoices())
                && hasChoiceAnswerSummaries() == other.hasChoiceAnswerSummaries()
                && Objects.equals(choiceAnswerSummaries(), other.choiceAnswerSummaries())
                && Objects.equals(isApplicable(), other.isApplicable()) && Objects.equals(riskAsString(), other.riskAsString())
                && Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(questionTypeAsString(), other.questionTypeAsString())
                && Objects.equals(jiraConfiguration(), other.jiraConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnswerSummary").add("QuestionId", questionId()).add("PillarId", pillarId())
                .add("QuestionTitle", questionTitle()).add("Choices", hasChoices() ? choices() : null)
                .add("SelectedChoices", hasSelectedChoices() ? selectedChoices() : null)
                .add("ChoiceAnswerSummaries", hasChoiceAnswerSummaries() ? choiceAnswerSummaries() : null)
                .add("IsApplicable", isApplicable()).add("Risk", riskAsString()).add("Reason", reasonAsString())
                .add("QuestionType", questionTypeAsString()).add("JiraConfiguration", jiraConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "QuestionTitle":
            return Optional.ofNullable(clazz.cast(questionTitle()));
        case "Choices":
            return Optional.ofNullable(clazz.cast(choices()));
        case "SelectedChoices":
            return Optional.ofNullable(clazz.cast(selectedChoices()));
        case "ChoiceAnswerSummaries":
            return Optional.ofNullable(clazz.cast(choiceAnswerSummaries()));
        case "IsApplicable":
            return Optional.ofNullable(clazz.cast(isApplicable()));
        case "Risk":
            return Optional.ofNullable(clazz.cast(riskAsString()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "QuestionType":
            return Optional.ofNullable(clazz.cast(questionTypeAsString()));
        case "JiraConfiguration":
            return Optional.ofNullable(clazz.cast(jiraConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnswerSummary, T> g) {
        return obj -> g.apply((AnswerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnswerSummary> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the QuestionTitle property for this object.
         *
         * @param questionTitle
         *        The new value for the QuestionTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionTitle(String questionTitle);

        /**
         * Sets the value of the Choices property for this object.
         *
         * @param choices
         *        The new value for the Choices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choices(Collection<Choice> choices);

        /**
         * Sets the value of the Choices property for this object.
         *
         * @param choices
         *        The new value for the Choices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choices(Choice... choices);

        /**
         * Sets the value of the Choices property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.Choice.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wellarchitected.model.Choice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.Choice.Builder#build()} is called immediately
         * and its result is passed to {@link #choices(List<Choice>)}.
         * 
         * @param choices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.Choice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #choices(java.util.Collection<Choice>)
         */
        Builder choices(Consumer<Choice.Builder>... choices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(Collection<String> selectedChoices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(String... selectedChoices);

        /**
         * <p>
         * A list of selected choices to a question in your workload.
         * </p>
         * 
         * @param choiceAnswerSummaries
         *        A list of selected choices to a question in your workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceAnswerSummaries(Collection<ChoiceAnswerSummary> choiceAnswerSummaries);

        /**
         * <p>
         * A list of selected choices to a question in your workload.
         * </p>
         * 
         * @param choiceAnswerSummaries
         *        A list of selected choices to a question in your workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceAnswerSummaries(ChoiceAnswerSummary... choiceAnswerSummaries);

        /**
         * <p>
         * A list of selected choices to a question in your workload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswerSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswerSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #choiceAnswerSummaries(List<ChoiceAnswerSummary>)}.
         * 
         * @param choiceAnswerSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #choiceAnswerSummaries(java.util.Collection<ChoiceAnswerSummary>)
         */
        Builder choiceAnswerSummaries(Consumer<ChoiceAnswerSummary.Builder>... choiceAnswerSummaries);

        /**
         * Sets the value of the IsApplicable property for this object.
         *
         * @param isApplicable
         *        The new value for the IsApplicable property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isApplicable(Boolean isApplicable);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(String risk);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(Risk risk);

        /**
         * <p>
         * The reason why a choice is non-applicable to a question in your workload.
         * </p>
         * 
         * @param reason
         *        The reason why a choice is non-applicable to a question in your workload.
         * @see AnswerReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnswerReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason why a choice is non-applicable to a question in your workload.
         * </p>
         * 
         * @param reason
         *        The reason why a choice is non-applicable to a question in your workload.
         * @see AnswerReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnswerReason
         */
        Builder reason(AnswerReason reason);

        /**
         * <p>
         * The type of the question.
         * </p>
         * 
         * @param questionType
         *        The type of the question.
         * @see QuestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuestionType
         */
        Builder questionType(String questionType);

        /**
         * <p>
         * The type of the question.
         * </p>
         * 
         * @param questionType
         *        The type of the question.
         * @see QuestionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuestionType
         */
        Builder questionType(QuestionType questionType);

        /**
         * <p>
         * Configuration of the Jira integration.
         * </p>
         * 
         * @param jiraConfiguration
         *        Configuration of the Jira integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraConfiguration(JiraConfiguration jiraConfiguration);

        /**
         * <p>
         * Configuration of the Jira integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JiraConfiguration.Builder} avoiding the
         * need to create one manually via {@link JiraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JiraConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #jiraConfiguration(JiraConfiguration)}.
         * 
         * @param jiraConfiguration
         *        a consumer that will call methods on {@link JiraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jiraConfiguration(JiraConfiguration)
         */
        default Builder jiraConfiguration(Consumer<JiraConfiguration.Builder> jiraConfiguration) {
            return jiraConfiguration(JiraConfiguration.builder().applyMutation(jiraConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private String pillarId;

        private String questionTitle;

        private List<Choice> choices = DefaultSdkAutoConstructList.getInstance();

        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();

        private List<ChoiceAnswerSummary> choiceAnswerSummaries = DefaultSdkAutoConstructList.getInstance();

        private Boolean isApplicable;

        private String risk;

        private String reason;

        private String questionType;

        private JiraConfiguration jiraConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AnswerSummary model) {
            questionId(model.questionId);
            pillarId(model.pillarId);
            questionTitle(model.questionTitle);
            choices(model.choices);
            selectedChoices(model.selectedChoices);
            choiceAnswerSummaries(model.choiceAnswerSummaries);
            isApplicable(model.isApplicable);
            risk(model.risk);
            reason(model.reason);
            questionType(model.questionType);
            jiraConfiguration(model.jiraConfiguration);
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionTitle() {
            return questionTitle;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final List<Choice.Builder> getChoices() {
            List<Choice.Builder> result = ChoicesCopier.copyToBuilder(this.choices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoices(Collection<Choice.BuilderImpl> choices) {
            this.choices = ChoicesCopier.copyFromBuilder(choices);
        }

        @Override
        public final Builder choices(Collection<Choice> choices) {
            this.choices = ChoicesCopier.copy(choices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Choice... choices) {
            choices(Arrays.asList(choices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Consumer<Choice.Builder>... choices) {
            choices(Stream.of(choices).map(c -> Choice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedChoices() {
            if (selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedChoices;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String... selectedChoices) {
            selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final List<ChoiceAnswerSummary.Builder> getChoiceAnswerSummaries() {
            List<ChoiceAnswerSummary.Builder> result = ChoiceAnswerSummariesCopier.copyToBuilder(this.choiceAnswerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoiceAnswerSummaries(Collection<ChoiceAnswerSummary.BuilderImpl> choiceAnswerSummaries) {
            this.choiceAnswerSummaries = ChoiceAnswerSummariesCopier.copyFromBuilder(choiceAnswerSummaries);
        }

        @Override
        public final Builder choiceAnswerSummaries(Collection<ChoiceAnswerSummary> choiceAnswerSummaries) {
            this.choiceAnswerSummaries = ChoiceAnswerSummariesCopier.copy(choiceAnswerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswerSummaries(ChoiceAnswerSummary... choiceAnswerSummaries) {
            choiceAnswerSummaries(Arrays.asList(choiceAnswerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswerSummaries(Consumer<ChoiceAnswerSummary.Builder>... choiceAnswerSummaries) {
            choiceAnswerSummaries(Stream.of(choiceAnswerSummaries)
                    .map(c -> ChoiceAnswerSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsApplicable() {
            return isApplicable;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final String getRisk() {
            return risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(AnswerReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getQuestionType() {
            return questionType;
        }

        public final void setQuestionType(String questionType) {
            this.questionType = questionType;
        }

        @Override
        public final Builder questionType(String questionType) {
            this.questionType = questionType;
            return this;
        }

        @Override
        public final Builder questionType(QuestionType questionType) {
            this.questionType(questionType == null ? null : questionType.toString());
            return this;
        }

        public final JiraConfiguration.Builder getJiraConfiguration() {
            return jiraConfiguration != null ? jiraConfiguration.toBuilder() : null;
        }

        public final void setJiraConfiguration(JiraConfiguration.BuilderImpl jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration != null ? jiraConfiguration.build() : null;
        }

        @Override
        public final Builder jiraConfiguration(JiraConfiguration jiraConfiguration) {
            this.jiraConfiguration = jiraConfiguration;
            return this;
        }

        @Override
        public AnswerSummary build() {
            return new AnswerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
