/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfilesRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<ListProfilesRequest.Builder, ListProfilesRequest> {
    private static final SdkField<String> PROFILE_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileNamePrefix").getter(getter(ListProfilesRequest::profileNamePrefix))
            .setter(setter(Builder::profileNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProfileNamePrefix").build())
            .build();

    private static final SdkField<String> PROFILE_OWNER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileOwnerType").getter(getter(ListProfilesRequest::profileOwnerTypeAsString))
            .setter(setter(Builder::profileOwnerType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProfileOwnerType").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_PREFIX_FIELD,
            PROFILE_OWNER_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String profileNamePrefix;

    private final String profileOwnerType;

    private final String nextToken;

    private final Integer maxResults;

    private ListProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.profileNamePrefix = builder.profileNamePrefix;
        this.profileOwnerType = builder.profileOwnerType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * An optional string added to the beginning of each profile name returned in the results.
     * </p>
     * 
     * @return An optional string added to the beginning of each profile name returned in the results.
     */
    public final String profileNamePrefix() {
        return profileNamePrefix;
    }

    /**
     * <p>
     * Profile owner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileOwnerType}
     * will return {@link ProfileOwnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #profileOwnerTypeAsString}.
     * </p>
     * 
     * @return Profile owner type.
     * @see ProfileOwnerType
     */
    public final ProfileOwnerType profileOwnerType() {
        return ProfileOwnerType.fromValue(profileOwnerType);
    }

    /**
     * <p>
     * Profile owner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileOwnerType}
     * will return {@link ProfileOwnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #profileOwnerTypeAsString}.
     * </p>
     * 
     * @return Profile owner type.
     * @see ProfileOwnerType
     */
    public final String profileOwnerTypeAsString() {
        return profileOwnerType;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(profileOwnerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilesRequest)) {
            return false;
        }
        ListProfilesRequest other = (ListProfilesRequest) obj;
        return Objects.equals(profileNamePrefix(), other.profileNamePrefix())
                && Objects.equals(profileOwnerTypeAsString(), other.profileOwnerTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfilesRequest").add("ProfileNamePrefix", profileNamePrefix())
                .add("ProfileOwnerType", profileOwnerTypeAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileNamePrefix":
            return Optional.ofNullable(clazz.cast(profileNamePrefix()));
        case "ProfileOwnerType":
            return Optional.ofNullable(clazz.cast(profileOwnerTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilesRequest, T> g) {
        return obj -> g.apply((ListProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListProfilesRequest> {
        /**
         * <p>
         * An optional string added to the beginning of each profile name returned in the results.
         * </p>
         * 
         * @param profileNamePrefix
         *        An optional string added to the beginning of each profile name returned in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileNamePrefix(String profileNamePrefix);

        /**
         * <p>
         * Profile owner type.
         * </p>
         * 
         * @param profileOwnerType
         *        Profile owner type.
         * @see ProfileOwnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileOwnerType
         */
        Builder profileOwnerType(String profileOwnerType);

        /**
         * <p>
         * Profile owner type.
         * </p>
         * 
         * @param profileOwnerType
         *        Profile owner type.
         * @see ProfileOwnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileOwnerType
         */
        Builder profileOwnerType(ProfileOwnerType profileOwnerType);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String profileNamePrefix;

        private String profileOwnerType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilesRequest model) {
            super(model);
            profileNamePrefix(model.profileNamePrefix);
            profileOwnerType(model.profileOwnerType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getProfileNamePrefix() {
            return profileNamePrefix;
        }

        public final void setProfileNamePrefix(String profileNamePrefix) {
            this.profileNamePrefix = profileNamePrefix;
        }

        @Override
        public final Builder profileNamePrefix(String profileNamePrefix) {
            this.profileNamePrefix = profileNamePrefix;
            return this;
        }

        public final String getProfileOwnerType() {
            return profileOwnerType;
        }

        public final void setProfileOwnerType(String profileOwnerType) {
            this.profileOwnerType = profileOwnerType;
        }

        @Override
        public final Builder profileOwnerType(String profileOwnerType) {
            this.profileOwnerType = profileOwnerType;
            return this;
        }

        @Override
        public final Builder profileOwnerType(ProfileOwnerType profileOwnerType) {
            this.profileOwnerType(profileOwnerType == null ? null : profileOwnerType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfilesRequest build() {
            return new ListProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
