/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account-level: Output configuration of the Jira integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountJiraConfigurationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountJiraConfigurationOutput.Builder, AccountJiraConfigurationOutput> {
    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationStatus").getter(getter(AccountJiraConfigurationOutput::integrationStatusAsString))
            .setter(setter(Builder::integrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationStatus").build()).build();

    private static final SdkField<String> ISSUE_MANAGEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IssueManagementStatus").getter(getter(AccountJiraConfigurationOutput::issueManagementStatusAsString))
            .setter(setter(Builder::issueManagementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementStatus").build())
            .build();

    private static final SdkField<String> ISSUE_MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IssueManagementType").getter(getter(AccountJiraConfigurationOutput::issueManagementTypeAsString))
            .setter(setter(Builder::issueManagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementType").build())
            .build();

    private static final SdkField<String> SUBDOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdomain").getter(getter(AccountJiraConfigurationOutput::subdomain)).setter(setter(Builder::subdomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdomain").build()).build();

    private static final SdkField<String> JIRA_PROJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JiraProjectKey").getter(getter(AccountJiraConfigurationOutput::jiraProjectKey))
            .setter(setter(Builder::jiraProjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraProjectKey").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(AccountJiraConfigurationOutput::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_STATUS_FIELD,
            ISSUE_MANAGEMENT_STATUS_FIELD, ISSUE_MANAGEMENT_TYPE_FIELD, SUBDOMAIN_FIELD, JIRA_PROJECT_KEY_FIELD,
            STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String integrationStatus;

    private final String issueManagementStatus;

    private final String issueManagementType;

    private final String subdomain;

    private final String jiraProjectKey;

    private final String statusMessage;

    private AccountJiraConfigurationOutput(BuilderImpl builder) {
        this.integrationStatus = builder.integrationStatus;
        this.issueManagementStatus = builder.issueManagementStatus;
        this.issueManagementType = builder.issueManagementType;
        this.subdomain = builder.subdomain;
        this.jiraProjectKey = builder.jiraProjectKey;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * Account-level: Configuration status of the Jira integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return Account-level: Configuration status of the Jira integration.
     * @see IntegrationStatus
     */
    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(integrationStatus);
    }

    /**
     * <p>
     * Account-level: Configuration status of the Jira integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #integrationStatus}
     * will return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #integrationStatusAsString}.
     * </p>
     * 
     * @return Account-level: Configuration status of the Jira integration.
     * @see IntegrationStatus
     */
    public final String integrationStatusAsString() {
        return integrationStatus;
    }

    /**
     * <p>
     * Account-level: Jira issue management status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #issueManagementStatus} will return {@link AccountJiraIssueManagementStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #issueManagementStatusAsString}.
     * </p>
     * 
     * @return Account-level: Jira issue management status.
     * @see AccountJiraIssueManagementStatus
     */
    public final AccountJiraIssueManagementStatus issueManagementStatus() {
        return AccountJiraIssueManagementStatus.fromValue(issueManagementStatus);
    }

    /**
     * <p>
     * Account-level: Jira issue management status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #issueManagementStatus} will return {@link AccountJiraIssueManagementStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #issueManagementStatusAsString}.
     * </p>
     * 
     * @return Account-level: Jira issue management status.
     * @see AccountJiraIssueManagementStatus
     */
    public final String issueManagementStatusAsString() {
        return issueManagementStatus;
    }

    /**
     * <p>
     * Account-level: Jira issue management type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #issueManagementType} will return {@link IssueManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #issueManagementTypeAsString}.
     * </p>
     * 
     * @return Account-level: Jira issue management type.
     * @see IssueManagementType
     */
    public final IssueManagementType issueManagementType() {
        return IssueManagementType.fromValue(issueManagementType);
    }

    /**
     * <p>
     * Account-level: Jira issue management type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #issueManagementType} will return {@link IssueManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #issueManagementTypeAsString}.
     * </p>
     * 
     * @return Account-level: Jira issue management type.
     * @see IssueManagementType
     */
    public final String issueManagementTypeAsString() {
        return issueManagementType;
    }

    /**
     * <p>
     * Account-level: Jira subdomain URL.
     * </p>
     * 
     * @return Account-level: Jira subdomain URL.
     */
    public final String subdomain() {
        return subdomain;
    }

    /**
     * <p>
     * Account-level: Jira project key to sync workloads to.
     * </p>
     * 
     * @return Account-level: Jira project key to sync workloads to.
     */
    public final String jiraProjectKey() {
        return jiraProjectKey;
    }

    /**
     * <p>
     * Account-level: Status message on configuration of the Jira integration.
     * </p>
     * 
     * @return Account-level: Status message on configuration of the Jira integration.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(integrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(issueManagementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(issueManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subdomain());
        hashCode = 31 * hashCode + Objects.hashCode(jiraProjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountJiraConfigurationOutput)) {
            return false;
        }
        AccountJiraConfigurationOutput other = (AccountJiraConfigurationOutput) obj;
        return Objects.equals(integrationStatusAsString(), other.integrationStatusAsString())
                && Objects.equals(issueManagementStatusAsString(), other.issueManagementStatusAsString())
                && Objects.equals(issueManagementTypeAsString(), other.issueManagementTypeAsString())
                && Objects.equals(subdomain(), other.subdomain()) && Objects.equals(jiraProjectKey(), other.jiraProjectKey())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountJiraConfigurationOutput").add("IntegrationStatus", integrationStatusAsString())
                .add("IssueManagementStatus", issueManagementStatusAsString())
                .add("IssueManagementType", issueManagementTypeAsString()).add("Subdomain", subdomain())
                .add("JiraProjectKey", jiraProjectKey()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationStatus":
            return Optional.ofNullable(clazz.cast(integrationStatusAsString()));
        case "IssueManagementStatus":
            return Optional.ofNullable(clazz.cast(issueManagementStatusAsString()));
        case "IssueManagementType":
            return Optional.ofNullable(clazz.cast(issueManagementTypeAsString()));
        case "Subdomain":
            return Optional.ofNullable(clazz.cast(subdomain()));
        case "JiraProjectKey":
            return Optional.ofNullable(clazz.cast(jiraProjectKey()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountJiraConfigurationOutput, T> g) {
        return obj -> g.apply((AccountJiraConfigurationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountJiraConfigurationOutput> {
        /**
         * <p>
         * Account-level: Configuration status of the Jira integration.
         * </p>
         * 
         * @param integrationStatus
         *        Account-level: Configuration status of the Jira integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(String integrationStatus);

        /**
         * <p>
         * Account-level: Configuration status of the Jira integration.
         * </p>
         * 
         * @param integrationStatus
         *        Account-level: Configuration status of the Jira integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder integrationStatus(IntegrationStatus integrationStatus);

        /**
         * <p>
         * Account-level: Jira issue management status.
         * </p>
         * 
         * @param issueManagementStatus
         *        Account-level: Jira issue management status.
         * @see AccountJiraIssueManagementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountJiraIssueManagementStatus
         */
        Builder issueManagementStatus(String issueManagementStatus);

        /**
         * <p>
         * Account-level: Jira issue management status.
         * </p>
         * 
         * @param issueManagementStatus
         *        Account-level: Jira issue management status.
         * @see AccountJiraIssueManagementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountJiraIssueManagementStatus
         */
        Builder issueManagementStatus(AccountJiraIssueManagementStatus issueManagementStatus);

        /**
         * <p>
         * Account-level: Jira issue management type.
         * </p>
         * 
         * @param issueManagementType
         *        Account-level: Jira issue management type.
         * @see IssueManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IssueManagementType
         */
        Builder issueManagementType(String issueManagementType);

        /**
         * <p>
         * Account-level: Jira issue management type.
         * </p>
         * 
         * @param issueManagementType
         *        Account-level: Jira issue management type.
         * @see IssueManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IssueManagementType
         */
        Builder issueManagementType(IssueManagementType issueManagementType);

        /**
         * <p>
         * Account-level: Jira subdomain URL.
         * </p>
         * 
         * @param subdomain
         *        Account-level: Jira subdomain URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdomain(String subdomain);

        /**
         * <p>
         * Account-level: Jira project key to sync workloads to.
         * </p>
         * 
         * @param jiraProjectKey
         *        Account-level: Jira project key to sync workloads to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraProjectKey(String jiraProjectKey);

        /**
         * <p>
         * Account-level: Status message on configuration of the Jira integration.
         * </p>
         * 
         * @param statusMessage
         *        Account-level: Status message on configuration of the Jira integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String integrationStatus;

        private String issueManagementStatus;

        private String issueManagementType;

        private String subdomain;

        private String jiraProjectKey;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountJiraConfigurationOutput model) {
            integrationStatus(model.integrationStatus);
            issueManagementStatus(model.issueManagementStatus);
            issueManagementType(model.issueManagementType);
            subdomain(model.subdomain);
            jiraProjectKey(model.jiraProjectKey);
            statusMessage(model.statusMessage);
        }

        public final String getIntegrationStatus() {
            return integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        public final String getIssueManagementStatus() {
            return issueManagementStatus;
        }

        public final void setIssueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
        }

        @Override
        public final Builder issueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
            return this;
        }

        @Override
        public final Builder issueManagementStatus(AccountJiraIssueManagementStatus issueManagementStatus) {
            this.issueManagementStatus(issueManagementStatus == null ? null : issueManagementStatus.toString());
            return this;
        }

        public final String getIssueManagementType() {
            return issueManagementType;
        }

        public final void setIssueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
        }

        @Override
        public final Builder issueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
            return this;
        }

        @Override
        public final Builder issueManagementType(IssueManagementType issueManagementType) {
            this.issueManagementType(issueManagementType == null ? null : issueManagementType.toString());
            return this;
        }

        public final String getSubdomain() {
            return subdomain;
        }

        public final void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @Override
        public final Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public final String getJiraProjectKey() {
            return jiraProjectKey;
        }

        public final void setJiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
        }

        @Override
        public final Builder jiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public AccountJiraConfigurationOutput build() {
            return new AccountJiraConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
