/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesResponse;

public class ListReviewTemplatesIterable
implements SdkIterable<ListReviewTemplatesResponse> {
    private final WellArchitectedClient client;
    private final ListReviewTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReviewTemplatesIterable(WellArchitectedClient client, ListReviewTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReviewTemplatesResponseFetcher();
    }

    public Iterator<ListReviewTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListReviewTemplatesResponseFetcher
    implements SyncPageFetcher<ListReviewTemplatesResponse> {
        private ListReviewTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListReviewTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReviewTemplatesResponse nextPage(ListReviewTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListReviewTemplatesIterable.this.client.listReviewTemplates(ListReviewTemplatesIterable.this.firstRequest);
            }
            return ListReviewTemplatesIterable.this.client.listReviewTemplates((ListReviewTemplatesRequest)((Object)ListReviewTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

