/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateShareSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateShareSummary> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareId").getter(TemplateShareSummary.getter(TemplateShareSummary::shareId)).setter(TemplateShareSummary.setter(Builder::shareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()}).build();
    private static final SdkField<String> SHARED_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedWith").getter(TemplateShareSummary.getter(TemplateShareSummary::sharedWith)).setter(TemplateShareSummary.setter(Builder::sharedWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedWith").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TemplateShareSummary.getter(TemplateShareSummary::statusAsString)).setter(TemplateShareSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(TemplateShareSummary.getter(TemplateShareSummary::statusMessage)).setter(TemplateShareSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD, SHARED_WITH_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ShareId", SHARE_ID_FIELD);
            this.put("SharedWith", SHARED_WITH_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String shareId;
    private final String sharedWith;
    private final String status;
    private final String statusMessage;

    private TemplateShareSummary(BuilderImpl builder) {
        this.shareId = builder.shareId;
        this.sharedWith = builder.sharedWith;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String shareId() {
        return this.shareId;
    }

    public final String sharedWith() {
        return this.sharedWith;
    }

    public final ShareStatus status() {
        return ShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateShareSummary)) {
            return false;
        }
        TemplateShareSummary other = (TemplateShareSummary)obj;
        return Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.sharedWith(), other.sharedWith()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateShareSummary").add("ShareId", (Object)this.shareId()).add("SharedWith", (Object)this.sharedWith()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "SharedWith": {
                return Optional.ofNullable(clazz.cast(this.sharedWith()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TemplateShareSummary, T> g) {
        return obj -> g.apply((TemplateShareSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shareId;
        private String sharedWith;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateShareSummary model) {
            this.shareId(model.shareId);
            this.sharedWith(model.sharedWith);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getShareId() {
            return this.shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getSharedWith() {
            return this.sharedWith;
        }

        public final void setSharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
        }

        @Override
        public final Builder sharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public TemplateShareSummary build() {
            return new TemplateShareSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateShareSummary> {
        public Builder shareId(String var1);

        public Builder sharedWith(String var1);

        public Builder status(String var1);

        public Builder status(ShareStatus var1);

        public Builder statusMessage(String var1);
    }
}

