/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.AdditionalResources;
import software.amazon.awssdk.services.wellarchitected.model.AdditionalResourcesListCopier;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Choice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Choice> {
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChoiceId").getter(Choice.getter(Choice::choiceId)).setter(Choice.setter(Builder::choiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Choice.getter(Choice::title)).setter(Choice.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Choice.getter(Choice::description)).setter(Choice.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ChoiceContent> HELPFUL_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HelpfulResource").getter(Choice.getter(Choice::helpfulResource)).setter(Choice.setter(Builder::helpfulResource)).constructor(ChoiceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelpfulResource").build()}).build();
    private static final SdkField<ChoiceContent> IMPROVEMENT_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImprovementPlan").getter(Choice.getter(Choice::improvementPlan)).setter(Choice.setter(Builder::improvementPlan)).constructor(ChoiceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlan").build()}).build();
    private static final SdkField<List<AdditionalResources>> ADDITIONAL_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalResources").getter(Choice.getter(Choice::additionalResources)).setter(Choice.setter(Builder::additionalResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHOICE_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, HELPFUL_RESOURCE_FIELD, IMPROVEMENT_PLAN_FIELD, ADDITIONAL_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Choice.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String choiceId;
    private final String title;
    private final String description;
    private final ChoiceContent helpfulResource;
    private final ChoiceContent improvementPlan;
    private final List<AdditionalResources> additionalResources;

    private Choice(BuilderImpl builder) {
        this.choiceId = builder.choiceId;
        this.title = builder.title;
        this.description = builder.description;
        this.helpfulResource = builder.helpfulResource;
        this.improvementPlan = builder.improvementPlan;
        this.additionalResources = builder.additionalResources;
    }

    public final String choiceId() {
        return this.choiceId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final ChoiceContent helpfulResource() {
        return this.helpfulResource;
    }

    public final ChoiceContent improvementPlan() {
        return this.improvementPlan;
    }

    public final boolean hasAdditionalResources() {
        return this.additionalResources != null && !(this.additionalResources instanceof SdkAutoConstructList);
    }

    public final List<AdditionalResources> additionalResources() {
        return this.additionalResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.helpfulResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.improvementPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalResources() ? this.additionalResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Choice)) {
            return false;
        }
        Choice other = (Choice)obj;
        return Objects.equals(this.choiceId(), other.choiceId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.helpfulResource(), other.helpfulResource()) && Objects.equals(this.improvementPlan(), other.improvementPlan()) && this.hasAdditionalResources() == other.hasAdditionalResources() && Objects.equals(this.additionalResources(), other.additionalResources());
    }

    public final String toString() {
        return ToString.builder((String)"Choice").add("ChoiceId", (Object)this.choiceId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("HelpfulResource", (Object)this.helpfulResource()).add("ImprovementPlan", (Object)this.improvementPlan()).add("AdditionalResources", this.hasAdditionalResources() ? this.additionalResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChoiceId": {
                return Optional.ofNullable(clazz.cast(this.choiceId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HelpfulResource": {
                return Optional.ofNullable(clazz.cast(this.helpfulResource()));
            }
            case "ImprovementPlan": {
                return Optional.ofNullable(clazz.cast(this.improvementPlan()));
            }
            case "AdditionalResources": {
                return Optional.ofNullable(clazz.cast(this.additionalResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChoiceId", CHOICE_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("HelpfulResource", HELPFUL_RESOURCE_FIELD);
        map.put("ImprovementPlan", IMPROVEMENT_PLAN_FIELD);
        map.put("AdditionalResources", ADDITIONAL_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Choice, T> g) {
        return obj -> g.apply((Choice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String choiceId;
        private String title;
        private String description;
        private ChoiceContent helpfulResource;
        private ChoiceContent improvementPlan;
        private List<AdditionalResources> additionalResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Choice model) {
            this.choiceId(model.choiceId);
            this.title(model.title);
            this.description(model.description);
            this.helpfulResource(model.helpfulResource);
            this.improvementPlan(model.improvementPlan);
            this.additionalResources(model.additionalResources);
        }

        public final String getChoiceId() {
            return this.choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ChoiceContent.Builder getHelpfulResource() {
            return this.helpfulResource != null ? this.helpfulResource.toBuilder() : null;
        }

        public final void setHelpfulResource(ChoiceContent.BuilderImpl helpfulResource) {
            this.helpfulResource = helpfulResource != null ? helpfulResource.build() : null;
        }

        @Override
        public final Builder helpfulResource(ChoiceContent helpfulResource) {
            this.helpfulResource = helpfulResource;
            return this;
        }

        public final ChoiceContent.Builder getImprovementPlan() {
            return this.improvementPlan != null ? this.improvementPlan.toBuilder() : null;
        }

        public final void setImprovementPlan(ChoiceContent.BuilderImpl improvementPlan) {
            this.improvementPlan = improvementPlan != null ? improvementPlan.build() : null;
        }

        @Override
        public final Builder improvementPlan(ChoiceContent improvementPlan) {
            this.improvementPlan = improvementPlan;
            return this;
        }

        public final List<AdditionalResources.Builder> getAdditionalResources() {
            List<AdditionalResources.Builder> result = AdditionalResourcesListCopier.copyToBuilder(this.additionalResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalResources(Collection<AdditionalResources.BuilderImpl> additionalResources) {
            this.additionalResources = AdditionalResourcesListCopier.copyFromBuilder(additionalResources);
        }

        @Override
        public final Builder additionalResources(Collection<AdditionalResources> additionalResources) {
            this.additionalResources = AdditionalResourcesListCopier.copy(additionalResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResources(AdditionalResources ... additionalResources) {
            this.additionalResources(Arrays.asList(additionalResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResources(Consumer<AdditionalResources.Builder> ... additionalResources) {
            this.additionalResources(Stream.of(additionalResources).map(c -> (AdditionalResources)((AdditionalResources.Builder)AdditionalResources.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Choice build() {
            return new Choice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Choice> {
        public Builder choiceId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder helpfulResource(ChoiceContent var1);

        default public Builder helpfulResource(Consumer<ChoiceContent.Builder> helpfulResource) {
            return this.helpfulResource((ChoiceContent)((ChoiceContent.Builder)ChoiceContent.builder().applyMutation(helpfulResource)).build());
        }

        public Builder improvementPlan(ChoiceContent var1);

        default public Builder improvementPlan(Consumer<ChoiceContent.Builder> improvementPlan) {
            return this.improvementPlan((ChoiceContent)((ChoiceContent.Builder)ChoiceContent.builder().applyMutation(improvementPlan)).build());
        }

        public Builder additionalResources(Collection<AdditionalResources> var1);

        public Builder additionalResources(AdditionalResources ... var1);

        public Builder additionalResources(Consumer<AdditionalResources.Builder> ... var1);
    }
}

