/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplateAnswersResponse;

public class ListReviewTemplateAnswersIterable
implements SdkIterable<ListReviewTemplateAnswersResponse> {
    private final WellArchitectedClient client;
    private final ListReviewTemplateAnswersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReviewTemplateAnswersIterable(WellArchitectedClient client, ListReviewTemplateAnswersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReviewTemplateAnswersResponseFetcher();
    }

    public Iterator<ListReviewTemplateAnswersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListReviewTemplateAnswersResponseFetcher
    implements SyncPageFetcher<ListReviewTemplateAnswersResponse> {
        private ListReviewTemplateAnswersResponseFetcher() {
        }

        public boolean hasNextPage(ListReviewTemplateAnswersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReviewTemplateAnswersResponse nextPage(ListReviewTemplateAnswersResponse previousPage) {
            if (previousPage == null) {
                return ListReviewTemplateAnswersIterable.this.client.listReviewTemplateAnswers(ListReviewTemplateAnswersIterable.this.firstRequest);
            }
            return ListReviewTemplateAnswersIterable.this.client.listReviewTemplateAnswers((ListReviewTemplateAnswersRequest)((Object)ListReviewTemplateAnswersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

