/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.CheckFailureReason;
import software.amazon.awssdk.services.wellarchitected.model.CheckProvider;
import software.amazon.awssdk.services.wellarchitected.model.CheckStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CheckDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CheckDetail.getter(CheckDetail::id)).setter(CheckDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CheckDetail.getter(CheckDetail::name)).setter(CheckDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CheckDetail.getter(CheckDetail::description)).setter(CheckDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(CheckDetail.getter(CheckDetail::providerAsString)).setter(CheckDetail.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(CheckDetail.getter(CheckDetail::lensArn)).setter(CheckDetail.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(CheckDetail.getter(CheckDetail::pillarId)).setter(CheckDetail.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(CheckDetail.getter(CheckDetail::questionId)).setter(CheckDetail.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChoiceId").getter(CheckDetail.getter(CheckDetail::choiceId)).setter(CheckDetail.setter(Builder::choiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CheckDetail.getter(CheckDetail::statusAsString)).setter(CheckDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CheckDetail.getter(CheckDetail::accountId)).setter(CheckDetail.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<Integer> FLAGGED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FlaggedResources").getter(CheckDetail.getter(CheckDetail::flaggedResources)).setter(CheckDetail.setter(Builder::flaggedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlaggedResources").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(CheckDetail.getter(CheckDetail::reasonAsString)).setter(CheckDetail.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(CheckDetail.getter(CheckDetail::updatedAt)).setter(CheckDetail.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PROVIDER_FIELD, LENS_ARN_FIELD, PILLAR_ID_FIELD, QUESTION_ID_FIELD, CHOICE_ID_FIELD, STATUS_FIELD, ACCOUNT_ID_FIELD, FLAGGED_RESOURCES_FIELD, REASON_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String provider;
    private final String lensArn;
    private final String pillarId;
    private final String questionId;
    private final String choiceId;
    private final String status;
    private final String accountId;
    private final Integer flaggedResources;
    private final String reason;
    private final Instant updatedAt;

    private CheckDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.provider = builder.provider;
        this.lensArn = builder.lensArn;
        this.pillarId = builder.pillarId;
        this.questionId = builder.questionId;
        this.choiceId = builder.choiceId;
        this.status = builder.status;
        this.accountId = builder.accountId;
        this.flaggedResources = builder.flaggedResources;
        this.reason = builder.reason;
        this.updatedAt = builder.updatedAt;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final CheckProvider provider() {
        return CheckProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String choiceId() {
        return this.choiceId;
    }

    public final CheckStatus status() {
        return CheckStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Integer flaggedResources() {
        return this.flaggedResources;
    }

    public final CheckFailureReason reason() {
        return CheckFailureReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flaggedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDetail)) {
            return false;
        }
        CheckDetail other = (CheckDetail)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.choiceId(), other.choiceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.flaggedResources(), other.flaggedResources()) && Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CheckDetail").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Provider", (Object)this.providerAsString()).add("LensArn", (Object)this.lensArn()).add("PillarId", (Object)this.pillarId()).add("QuestionId", (Object)this.questionId()).add("ChoiceId", (Object)this.choiceId()).add("Status", (Object)this.statusAsString()).add("AccountId", (Object)this.accountId()).add("FlaggedResources", (Object)this.flaggedResources()).add("Reason", (Object)this.reasonAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "ChoiceId": {
                return Optional.ofNullable(clazz.cast(this.choiceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "FlaggedResources": {
                return Optional.ofNullable(clazz.cast(this.flaggedResources()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("ChoiceId", CHOICE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("FlaggedResources", FLAGGED_RESOURCES_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckDetail, T> g) {
        return obj -> g.apply((CheckDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String provider;
        private String lensArn;
        private String pillarId;
        private String questionId;
        private String choiceId;
        private String status;
        private String accountId;
        private Integer flaggedResources;
        private String reason;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDetail model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.provider(model.provider);
            this.lensArn(model.lensArn);
            this.pillarId(model.pillarId);
            this.questionId(model.questionId);
            this.choiceId(model.choiceId);
            this.status(model.status);
            this.accountId(model.accountId);
            this.flaggedResources(model.flaggedResources);
            this.reason(model.reason);
            this.updatedAt(model.updatedAt);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(CheckProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getChoiceId() {
            return this.choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CheckStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Integer getFlaggedResources() {
            return this.flaggedResources;
        }

        public final void setFlaggedResources(Integer flaggedResources) {
            this.flaggedResources = flaggedResources;
        }

        @Override
        public final Builder flaggedResources(Integer flaggedResources) {
            this.flaggedResources = flaggedResources;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(CheckFailureReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CheckDetail build() {
            return new CheckDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CheckDetail> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder provider(String var1);

        public Builder provider(CheckProvider var1);

        public Builder lensArn(String var1);

        public Builder pillarId(String var1);

        public Builder questionId(String var1);

        public Builder choiceId(String var1);

        public Builder status(String var1);

        public Builder status(CheckStatus var1);

        public Builder accountId(String var1);

        public Builder flaggedResources(Integer var1);

        public Builder reason(String var1);

        public Builder reason(CheckFailureReason var1);

        public Builder updatedAt(Instant var1);
    }
}

