/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.DefinitionType;
import software.amazon.awssdk.services.wellarchitected.model.TrustedAdvisorIntegrationStatus;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadResourceDefinitionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadDiscoveryConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadDiscoveryConfig> {
    private static final SdkField<String> TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedAdvisorIntegrationStatus").getter(WorkloadDiscoveryConfig.getter(WorkloadDiscoveryConfig::trustedAdvisorIntegrationStatusAsString)).setter(WorkloadDiscoveryConfig.setter(Builder::trustedAdvisorIntegrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedAdvisorIntegrationStatus").build()}).build();
    private static final SdkField<List<String>> WORKLOAD_RESOURCE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkloadResourceDefinition").getter(WorkloadDiscoveryConfig.getter(WorkloadDiscoveryConfig::workloadResourceDefinitionAsStrings)).setter(WorkloadDiscoveryConfig.setter(Builder::workloadResourceDefinitionWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadResourceDefinition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD, WORKLOAD_RESOURCE_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkloadDiscoveryConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trustedAdvisorIntegrationStatus;
    private final List<String> workloadResourceDefinition;

    private WorkloadDiscoveryConfig(BuilderImpl builder) {
        this.trustedAdvisorIntegrationStatus = builder.trustedAdvisorIntegrationStatus;
        this.workloadResourceDefinition = builder.workloadResourceDefinition;
    }

    public final TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus() {
        return TrustedAdvisorIntegrationStatus.fromValue(this.trustedAdvisorIntegrationStatus);
    }

    public final String trustedAdvisorIntegrationStatusAsString() {
        return this.trustedAdvisorIntegrationStatus;
    }

    public final List<DefinitionType> workloadResourceDefinition() {
        return WorkloadResourceDefinitionCopier.copyStringToEnum(this.workloadResourceDefinition);
    }

    public final boolean hasWorkloadResourceDefinition() {
        return this.workloadResourceDefinition != null && !(this.workloadResourceDefinition instanceof SdkAutoConstructList);
    }

    public final List<String> workloadResourceDefinitionAsStrings() {
        return this.workloadResourceDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedAdvisorIntegrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloadResourceDefinition() ? this.workloadResourceDefinitionAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDiscoveryConfig)) {
            return false;
        }
        WorkloadDiscoveryConfig other = (WorkloadDiscoveryConfig)obj;
        return Objects.equals(this.trustedAdvisorIntegrationStatusAsString(), other.trustedAdvisorIntegrationStatusAsString()) && this.hasWorkloadResourceDefinition() == other.hasWorkloadResourceDefinition() && Objects.equals(this.workloadResourceDefinitionAsStrings(), other.workloadResourceDefinitionAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadDiscoveryConfig").add("TrustedAdvisorIntegrationStatus", (Object)this.trustedAdvisorIntegrationStatusAsString()).add("WorkloadResourceDefinition", this.hasWorkloadResourceDefinition() ? this.workloadResourceDefinitionAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustedAdvisorIntegrationStatus": {
                return Optional.ofNullable(clazz.cast(this.trustedAdvisorIntegrationStatusAsString()));
            }
            case "WorkloadResourceDefinition": {
                return Optional.ofNullable(clazz.cast(this.workloadResourceDefinitionAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustedAdvisorIntegrationStatus", TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD);
        map.put("WorkloadResourceDefinition", WORKLOAD_RESOURCE_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadDiscoveryConfig, T> g) {
        return obj -> g.apply((WorkloadDiscoveryConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trustedAdvisorIntegrationStatus;
        private List<String> workloadResourceDefinition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadDiscoveryConfig model) {
            this.trustedAdvisorIntegrationStatus(model.trustedAdvisorIntegrationStatus);
            this.workloadResourceDefinitionWithStrings(model.workloadResourceDefinition);
        }

        public final String getTrustedAdvisorIntegrationStatus() {
            return this.trustedAdvisorIntegrationStatus;
        }

        public final void setTrustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus;
        }

        @Override
        public final Builder trustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus;
            return this;
        }

        @Override
        public final Builder trustedAdvisorIntegrationStatus(TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus(trustedAdvisorIntegrationStatus == null ? null : trustedAdvisorIntegrationStatus.toString());
            return this;
        }

        public final Collection<String> getWorkloadResourceDefinition() {
            if (this.workloadResourceDefinition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workloadResourceDefinition;
        }

        public final void setWorkloadResourceDefinition(Collection<String> workloadResourceDefinition) {
            this.workloadResourceDefinition = WorkloadResourceDefinitionCopier.copy(workloadResourceDefinition);
        }

        @Override
        public final Builder workloadResourceDefinitionWithStrings(Collection<String> workloadResourceDefinition) {
            this.workloadResourceDefinition = WorkloadResourceDefinitionCopier.copy(workloadResourceDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadResourceDefinitionWithStrings(String ... workloadResourceDefinition) {
            this.workloadResourceDefinitionWithStrings(Arrays.asList(workloadResourceDefinition));
            return this;
        }

        @Override
        public final Builder workloadResourceDefinition(Collection<DefinitionType> workloadResourceDefinition) {
            this.workloadResourceDefinition = WorkloadResourceDefinitionCopier.copyEnumToString(workloadResourceDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadResourceDefinition(DefinitionType ... workloadResourceDefinition) {
            this.workloadResourceDefinition(Arrays.asList(workloadResourceDefinition));
            return this;
        }

        public WorkloadDiscoveryConfig build() {
            return new WorkloadDiscoveryConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadDiscoveryConfig> {
        public Builder trustedAdvisorIntegrationStatus(String var1);

        public Builder trustedAdvisorIntegrationStatus(TrustedAdvisorIntegrationStatus var1);

        public Builder workloadResourceDefinitionWithStrings(Collection<String> var1);

        public Builder workloadResourceDefinitionWithStrings(String ... var1);

        public Builder workloadResourceDefinition(Collection<DefinitionType> var1);

        public Builder workloadResourceDefinition(DefinitionType ... var1);
    }
}

