/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.Question;
import software.amazon.awssdk.services.wellarchitected.model.QuestionCountsCopier;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateLensesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateUpdateStatus;
import software.amazon.awssdk.services.wellarchitected.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewTemplate> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReviewTemplate.getter(ReviewTemplate::description)).setter(ReviewTemplate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> LENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lenses").getter(ReviewTemplate.getter(ReviewTemplate::lenses)).setter(ReviewTemplate.setter(Builder::lenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(ReviewTemplate.getter(ReviewTemplate::notes)).setter(ReviewTemplate.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Map<String, Integer>> QUESTION_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("QuestionCounts").getter(ReviewTemplate.getter(ReviewTemplate::questionCountsAsStrings)).setter(ReviewTemplate.setter(Builder::questionCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(ReviewTemplate.getter(ReviewTemplate::owner)).setter(ReviewTemplate.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ReviewTemplate.getter(ReviewTemplate::updatedAt)).setter(ReviewTemplate.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(ReviewTemplate.getter(ReviewTemplate::templateArn)).setter(ReviewTemplate.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(ReviewTemplate.getter(ReviewTemplate::templateName)).setter(ReviewTemplate.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ReviewTemplate.getter(ReviewTemplate::tags)).setter(ReviewTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(ReviewTemplate.getter(ReviewTemplate::updateStatusAsString)).setter(ReviewTemplate.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareInvitationId").getter(ReviewTemplate.getter(ReviewTemplate::shareInvitationId)).setter(ReviewTemplate.setter(Builder::shareInvitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, LENSES_FIELD, NOTES_FIELD, QUESTION_COUNTS_FIELD, OWNER_FIELD, UPDATED_AT_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_NAME_FIELD, TAGS_FIELD, UPDATE_STATUS_FIELD, SHARE_INVITATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReviewTemplate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> lenses;
    private final String notes;
    private final Map<String, Integer> questionCounts;
    private final String owner;
    private final Instant updatedAt;
    private final String templateArn;
    private final String templateName;
    private final Map<String, String> tags;
    private final String updateStatus;
    private final String shareInvitationId;

    private ReviewTemplate(BuilderImpl builder) {
        this.description = builder.description;
        this.lenses = builder.lenses;
        this.notes = builder.notes;
        this.questionCounts = builder.questionCounts;
        this.owner = builder.owner;
        this.updatedAt = builder.updatedAt;
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.tags = builder.tags;
        this.updateStatus = builder.updateStatus;
        this.shareInvitationId = builder.shareInvitationId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasLenses() {
        return this.lenses != null && !(this.lenses instanceof SdkAutoConstructList);
    }

    public final List<String> lenses() {
        return this.lenses;
    }

    public final String notes() {
        return this.notes;
    }

    public final Map<Question, Integer> questionCounts() {
        return QuestionCountsCopier.copyStringToEnum(this.questionCounts);
    }

    public final boolean hasQuestionCounts() {
        return this.questionCounts != null && !(this.questionCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> questionCountsAsStrings() {
        return this.questionCounts;
    }

    public final String owner() {
        return this.owner;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ReviewTemplateUpdateStatus updateStatus() {
        return ReviewTemplateUpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final String shareInvitationId() {
        return this.shareInvitationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLenses() ? this.lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuestionCounts() ? this.questionCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareInvitationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplate)) {
            return false;
        }
        ReviewTemplate other = (ReviewTemplate)obj;
        return Objects.equals(this.description(), other.description()) && this.hasLenses() == other.hasLenses() && Objects.equals(this.lenses(), other.lenses()) && Objects.equals(this.notes(), other.notes()) && this.hasQuestionCounts() == other.hasQuestionCounts() && Objects.equals(this.questionCountsAsStrings(), other.questionCountsAsStrings()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateName(), other.templateName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.shareInvitationId(), other.shareInvitationId());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewTemplate").add("Description", (Object)this.description()).add("Lenses", this.hasLenses() ? this.lenses() : null).add("Notes", (Object)this.notes()).add("QuestionCounts", this.hasQuestionCounts() ? this.questionCountsAsStrings() : null).add("Owner", (Object)this.owner()).add("UpdatedAt", (Object)this.updatedAt()).add("TemplateArn", (Object)this.templateArn()).add("TemplateName", (Object)this.templateName()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdateStatus", (Object)this.updateStatusAsString()).add("ShareInvitationId", (Object)this.shareInvitationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Lenses": {
                return Optional.ofNullable(clazz.cast(this.lenses()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "QuestionCounts": {
                return Optional.ofNullable(clazz.cast(this.questionCountsAsStrings()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "ShareInvitationId": {
                return Optional.ofNullable(clazz.cast(this.shareInvitationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Lenses", LENSES_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("QuestionCounts", QUESTION_COUNTS_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("ShareInvitationId", SHARE_INVITATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplate, T> g) {
        return obj -> g.apply((ReviewTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();
        private String notes;
        private Map<String, Integer> questionCounts = DefaultSdkAutoConstructMap.getInstance();
        private String owner;
        private Instant updatedAt;
        private String templateArn;
        private String templateName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String updateStatus;
        private String shareInvitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplate model) {
            this.description(model.description);
            this.lenses(model.lenses);
            this.notes(model.notes);
            this.questionCountsWithStrings(model.questionCounts);
            this.owner(model.owner);
            this.updatedAt(model.updatedAt);
            this.templateArn(model.templateArn);
            this.templateName(model.templateName);
            this.tags(model.tags);
            this.updateStatus(model.updateStatus);
            this.shareInvitationId(model.shareInvitationId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getLenses() {
            if (this.lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String ... lenses) {
            this.lenses(Arrays.asList(lenses));
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, Integer> getQuestionCounts() {
            if (this.questionCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.questionCounts;
        }

        public final void setQuestionCounts(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
        }

        @Override
        public final Builder questionCountsWithStrings(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
            return this;
        }

        @Override
        public final Builder questionCounts(Map<Question, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copyEnumToString(questionCounts);
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ReviewTemplateUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getShareInvitationId() {
            return this.shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public ReviewTemplate build() {
            return new ReviewTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewTemplate> {
        public Builder description(String var1);

        public Builder lenses(Collection<String> var1);

        public Builder lenses(String ... var1);

        public Builder notes(String var1);

        public Builder questionCountsWithStrings(Map<String, Integer> var1);

        public Builder questionCounts(Map<Question, Integer> var1);

        public Builder owner(String var1);

        public Builder updatedAt(Instant var1);

        public Builder templateArn(String var1);

        public Builder templateName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(ReviewTemplateUpdateStatus var1);

        public Builder shareInvitationId(String var1);
    }
}

