/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The choice content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChoiceContent implements SdkPojo, Serializable, ToCopyableBuilder<ChoiceContent.Builder, ChoiceContent> {
    private static final SdkField<String> DISPLAY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayText").getter(getter(ChoiceContent::displayText)).setter(setter(Builder::displayText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayText").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(ChoiceContent::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DISPLAY_TEXT_FIELD, URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String displayText;

    private final String url;

    private ChoiceContent(BuilderImpl builder) {
        this.displayText = builder.displayText;
        this.url = builder.url;
    }

    /**
     * <p>
     * The display text for the choice content.
     * </p>
     * 
     * @return The display text for the choice content.
     */
    public final String displayText() {
        return displayText;
    }

    /**
     * <p>
     * The URL for the choice content.
     * </p>
     * 
     * @return The URL for the choice content.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayText());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChoiceContent)) {
            return false;
        }
        ChoiceContent other = (ChoiceContent) obj;
        return Objects.equals(displayText(), other.displayText()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChoiceContent").add("DisplayText", displayText()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayText":
            return Optional.ofNullable(clazz.cast(displayText()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisplayText", DISPLAY_TEXT_FIELD);
        map.put("Url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChoiceContent, T> g) {
        return obj -> g.apply((ChoiceContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChoiceContent> {
        /**
         * <p>
         * The display text for the choice content.
         * </p>
         * 
         * @param displayText
         *        The display text for the choice content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayText(String displayText);

        /**
         * <p>
         * The URL for the choice content.
         * </p>
         * 
         * @param url
         *        The URL for the choice content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String displayText;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(ChoiceContent model) {
            displayText(model.displayText);
            url(model.url);
        }

        public final String getDisplayText() {
            return displayText;
        }

        public final void setDisplayText(String displayText) {
            this.displayText = displayText;
        }

        @Override
        public final Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public ChoiceContent build() {
            return new ChoiceContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
