/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output of a get lens review report call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLensReviewReportResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<GetLensReviewReportResponse.Builder, GetLensReviewReportResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(GetLensReviewReportResponse::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MilestoneNumber").getter(getter(GetLensReviewReportResponse::milestoneNumber))
            .setter(setter(Builder::milestoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()).build();

    private static final SdkField<LensReviewReport> LENS_REVIEW_REPORT_FIELD = SdkField
            .<LensReviewReport> builder(MarshallingType.SDK_POJO).memberName("LensReviewReport")
            .getter(getter(GetLensReviewReportResponse::lensReviewReport)).setter(setter(Builder::lensReviewReport))
            .constructor(LensReviewReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensReviewReport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            MILESTONE_NUMBER_FIELD, LENS_REVIEW_REPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadId;

    private final Integer milestoneNumber;

    private final LensReviewReport lensReviewReport;

    private GetLensReviewReportResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensReviewReport = builder.lensReviewReport;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the MilestoneNumber property for this object.
     * 
     * @return The value of the MilestoneNumber property for this object.
     */
    public final Integer milestoneNumber() {
        return milestoneNumber;
    }

    /**
     * Returns the value of the LensReviewReport property for this object.
     * 
     * @return The value of the LensReviewReport property for this object.
     */
    public final LensReviewReport lensReviewReport() {
        return lensReviewReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(lensReviewReport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensReviewReportResponse)) {
            return false;
        }
        GetLensReviewReportResponse other = (GetLensReviewReportResponse) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(milestoneNumber(), other.milestoneNumber())
                && Objects.equals(lensReviewReport(), other.lensReviewReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLensReviewReportResponse").add("WorkloadId", workloadId())
                .add("MilestoneNumber", milestoneNumber()).add("LensReviewReport", lensReviewReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "MilestoneNumber":
            return Optional.ofNullable(clazz.cast(milestoneNumber()));
        case "LensReviewReport":
            return Optional.ofNullable(clazz.cast(lensReviewReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("MilestoneNumber", MILESTONE_NUMBER_FIELD);
        map.put("LensReviewReport", LENS_REVIEW_REPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLensReviewReportResponse, T> g) {
        return obj -> g.apply((GetLensReviewReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLensReviewReportResponse> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the MilestoneNumber property for this object.
         *
         * @param milestoneNumber
         *        The new value for the MilestoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneNumber(Integer milestoneNumber);

        /**
         * Sets the value of the LensReviewReport property for this object.
         *
         * @param lensReviewReport
         *        The new value for the LensReviewReport property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensReviewReport(LensReviewReport lensReviewReport);

        /**
         * Sets the value of the LensReviewReport property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LensReviewReport.Builder} avoiding the
         * need to create one manually via {@link LensReviewReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LensReviewReport.Builder#build()} is called immediately and its
         * result is passed to {@link #lensReviewReport(LensReviewReport)}.
         * 
         * @param lensReviewReport
         *        a consumer that will call methods on {@link LensReviewReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lensReviewReport(LensReviewReport)
         */
        default Builder lensReviewReport(Consumer<LensReviewReport.Builder> lensReviewReport) {
            return lensReviewReport(LensReviewReport.builder().applyMutation(lensReviewReport).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String workloadId;

        private Integer milestoneNumber;

        private LensReviewReport lensReviewReport;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensReviewReportResponse model) {
            super(model);
            workloadId(model.workloadId);
            milestoneNumber(model.milestoneNumber);
            lensReviewReport(model.lensReviewReport);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Integer getMilestoneNumber() {
            return milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final LensReviewReport.Builder getLensReviewReport() {
            return lensReviewReport != null ? lensReviewReport.toBuilder() : null;
        }

        public final void setLensReviewReport(LensReviewReport.BuilderImpl lensReviewReport) {
            this.lensReviewReport = lensReviewReport != null ? lensReviewReport.build() : null;
        }

        @Override
        public final Builder lensReviewReport(LensReviewReport lensReviewReport) {
            this.lensReviewReport = lensReviewReport;
            return this;
        }

        @Override
        public GetLensReviewReportResponse build() {
            return new GetLensReviewReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
