/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lens summary of a lens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LensSummary implements SdkPojo, Serializable, ToCopyableBuilder<LensSummary.Builder, LensSummary> {
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(LensSummary::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(LensSummary::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensName").getter(getter(LensSummary::lensName)).setter(setter(Builder::lensName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()).build();

    private static final SdkField<String> LENS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensType").getter(getter(LensSummary::lensTypeAsString)).setter(setter(Builder::lensType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LensSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(LensSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(LensSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensVersion").getter(getter(LensSummary::lensVersion)).setter(setter(Builder::lensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(LensSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensStatus").getter(getter(LensSummary::lensStatusAsString)).setter(setter(Builder::lensStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ARN_FIELD,
            LENS_ALIAS_FIELD, LENS_NAME_FIELD, LENS_TYPE_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            LENS_VERSION_FIELD, OWNER_FIELD, LENS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lensArn;

    private final String lensAlias;

    private final String lensName;

    private final String lensType;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String lensVersion;

    private final String owner;

    private final String lensStatus;

    private LensSummary(BuilderImpl builder) {
        this.lensArn = builder.lensArn;
        this.lensAlias = builder.lensAlias;
        this.lensName = builder.lensName;
        this.lensType = builder.lensType;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.lensVersion = builder.lensVersion;
        this.owner = builder.owner;
        this.lensStatus = builder.lensStatus;
    }

    /**
     * <p>
     * The ARN of the lens.
     * </p>
     * 
     * @return The ARN of the lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * Returns the value of the LensName property for this object.
     * 
     * @return The value of the LensName property for this object.
     */
    public final String lensName() {
        return lensName;
    }

    /**
     * <p>
     * The type of the lens.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensType} will
     * return {@link LensType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensTypeAsString}.
     * </p>
     * 
     * @return The type of the lens.
     * @see LensType
     */
    public final LensType lensType() {
        return LensType.fromValue(lensType);
    }

    /**
     * <p>
     * The type of the lens.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensType} will
     * return {@link LensType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensTypeAsString}.
     * </p>
     * 
     * @return The type of the lens.
     * @see LensType
     */
    public final String lensTypeAsString() {
        return lensType;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The version of the lens.
     * </p>
     * 
     * @return The version of the lens.
     */
    public final String lensVersion() {
        return lensVersion;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The status of the lens.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of the lens.
     * @see LensStatus
     */
    public final LensStatus lensStatus() {
        return LensStatus.fromValue(lensStatus);
    }

    /**
     * <p>
     * The status of the lens.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of the lens.
     * @see LensStatus
     */
    public final String lensStatusAsString() {
        return lensStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensName());
        hashCode = 31 * hashCode + Objects.hashCode(lensTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(lensStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensSummary)) {
            return false;
        }
        LensSummary other = (LensSummary) obj;
        return Objects.equals(lensArn(), other.lensArn()) && Objects.equals(lensAlias(), other.lensAlias())
                && Objects.equals(lensName(), other.lensName()) && Objects.equals(lensTypeAsString(), other.lensTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(lensVersion(), other.lensVersion())
                && Objects.equals(owner(), other.owner()) && Objects.equals(lensStatusAsString(), other.lensStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LensSummary").add("LensArn", lensArn()).add("LensAlias", lensAlias())
                .add("LensName", lensName()).add("LensType", lensTypeAsString()).add("Description", description())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("LensVersion", lensVersion())
                .add("Owner", owner()).add("LensStatus", lensStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensName":
            return Optional.ofNullable(clazz.cast(lensName()));
        case "LensType":
            return Optional.ofNullable(clazz.cast(lensTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "LensVersion":
            return Optional.ofNullable(clazz.cast(lensVersion()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "LensStatus":
            return Optional.ofNullable(clazz.cast(lensStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensName", LENS_NAME_FIELD);
        map.put("LensType", LENS_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("LensVersion", LENS_VERSION_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("LensStatus", LENS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LensSummary, T> g) {
        return obj -> g.apply((LensSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LensSummary> {
        /**
         * <p>
         * The ARN of the lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * Sets the value of the LensName property for this object.
         *
         * @param lensName
         *        The new value for the LensName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensName(String lensName);

        /**
         * <p>
         * The type of the lens.
         * </p>
         * 
         * @param lensType
         *        The type of the lens.
         * @see LensType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensType
         */
        Builder lensType(String lensType);

        /**
         * <p>
         * The type of the lens.
         * </p>
         * 
         * @param lensType
         *        The type of the lens.
         * @see LensType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensType
         */
        Builder lensType(LensType lensType);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The version of the lens.
         * </p>
         * 
         * @param lensVersion
         *        The version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensVersion(String lensVersion);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The status of the lens.
         * </p>
         * 
         * @param lensStatus
         *        The status of the lens.
         * @see LensStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatus
         */
        Builder lensStatus(String lensStatus);

        /**
         * <p>
         * The status of the lens.
         * </p>
         * 
         * @param lensStatus
         *        The status of the lens.
         * @see LensStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatus
         */
        Builder lensStatus(LensStatus lensStatus);
    }

    static final class BuilderImpl implements Builder {
        private String lensArn;

        private String lensAlias;

        private String lensName;

        private String lensType;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private String lensVersion;

        private String owner;

        private String lensStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LensSummary model) {
            lensArn(model.lensArn);
            lensAlias(model.lensAlias);
            lensName(model.lensName);
            lensType(model.lensType);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            lensVersion(model.lensVersion);
            owner(model.owner);
            lensStatus(model.lensStatus);
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensName() {
            return lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final String getLensType() {
            return lensType;
        }

        public final void setLensType(String lensType) {
            this.lensType = lensType;
        }

        @Override
        public final Builder lensType(String lensType) {
            this.lensType = lensType;
            return this;
        }

        @Override
        public final Builder lensType(LensType lensType) {
            this.lensType(lensType == null ? null : lensType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getLensVersion() {
            return lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getLensStatus() {
            return lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatus lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        @Override
        public LensSummary build() {
            return new LensSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
