/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to list lenses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLensesRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<ListLensesRequest.Builder, ListLensesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLensesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLensesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> LENS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensType").getter(getter(ListLensesRequest::lensTypeAsString)).setter(setter(Builder::lensType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensType").build()).build();

    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensStatus").getter(getter(ListLensesRequest::lensStatusAsString)).setter(setter(Builder::lensStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensStatus").build()).build();

    private static final SdkField<String> LENS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensName").getter(getter(ListLensesRequest::lensName)).setter(setter(Builder::lensName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, LENS_TYPE_FIELD, LENS_STATUS_FIELD, LENS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String lensType;

    private final String lensStatus;

    private final String lensName;

    private ListLensesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.lensType = builder.lensType;
        this.lensStatus = builder.lensStatus;
        this.lensName = builder.lensName;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The type of lenses to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensType} will
     * return {@link LensType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensTypeAsString}.
     * </p>
     * 
     * @return The type of lenses to be returned.
     * @see LensType
     */
    public final LensType lensType() {
        return LensType.fromValue(lensType);
    }

    /**
     * <p>
     * The type of lenses to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensType} will
     * return {@link LensType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensTypeAsString}.
     * </p>
     * 
     * @return The type of lenses to be returned.
     * @see LensType
     */
    public final String lensTypeAsString() {
        return lensType;
    }

    /**
     * <p>
     * The status of lenses to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of lenses to be returned.
     * @see LensStatusType
     */
    public final LensStatusType lensStatus() {
        return LensStatusType.fromValue(lensStatus);
    }

    /**
     * <p>
     * The status of lenses to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of lenses to be returned.
     * @see LensStatusType
     */
    public final String lensStatusAsString() {
        return lensStatus;
    }

    /**
     * Returns the value of the LensName property for this object.
     * 
     * @return The value of the LensName property for this object.
     */
    public final String lensName() {
        return lensName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(lensTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lensStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lensName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensesRequest)) {
            return false;
        }
        ListLensesRequest other = (ListLensesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(lensTypeAsString(), other.lensTypeAsString())
                && Objects.equals(lensStatusAsString(), other.lensStatusAsString())
                && Objects.equals(lensName(), other.lensName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLensesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("LensType", lensTypeAsString()).add("LensStatus", lensStatusAsString()).add("LensName", lensName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "LensType":
            return Optional.ofNullable(clazz.cast(lensTypeAsString()));
        case "LensStatus":
            return Optional.ofNullable(clazz.cast(lensStatusAsString()));
        case "LensName":
            return Optional.ofNullable(clazz.cast(lensName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("LensType", LENS_TYPE_FIELD);
        map.put("LensStatus", LENS_STATUS_FIELD);
        map.put("LensName", LENS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLensesRequest, T> g) {
        return obj -> g.apply((ListLensesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLensesRequest> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The type of lenses to be returned.
         * </p>
         * 
         * @param lensType
         *        The type of lenses to be returned.
         * @see LensType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensType
         */
        Builder lensType(String lensType);

        /**
         * <p>
         * The type of lenses to be returned.
         * </p>
         * 
         * @param lensType
         *        The type of lenses to be returned.
         * @see LensType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensType
         */
        Builder lensType(LensType lensType);

        /**
         * <p>
         * The status of lenses to be returned.
         * </p>
         * 
         * @param lensStatus
         *        The status of lenses to be returned.
         * @see LensStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatusType
         */
        Builder lensStatus(String lensStatus);

        /**
         * <p>
         * The status of lenses to be returned.
         * </p>
         * 
         * @param lensStatus
         *        The status of lenses to be returned.
         * @see LensStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatusType
         */
        Builder lensStatus(LensStatusType lensStatus);

        /**
         * Sets the value of the LensName property for this object.
         *
         * @param lensName
         *        The new value for the LensName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensName(String lensName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String lensType;

        private String lensStatus;

        private String lensName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            lensType(model.lensType);
            lensStatus(model.lensStatus);
            lensName(model.lensName);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLensType() {
            return lensType;
        }

        public final void setLensType(String lensType) {
            this.lensType = lensType;
        }

        @Override
        public final Builder lensType(String lensType) {
            this.lensType = lensType;
            return this;
        }

        @Override
        public final Builder lensType(LensType lensType) {
            this.lensType(lensType == null ? null : lensType.toString());
            return this;
        }

        public final String getLensStatus() {
            return lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatusType lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public final String getLensName() {
            return lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLensesRequest build() {
            return new ListLensesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
