/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output of a list milestones call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMilestonesResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListMilestonesResponse.Builder, ListMilestonesResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ListMilestonesResponse::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<List<MilestoneSummary>> MILESTONE_SUMMARIES_FIELD = SdkField
            .<List<MilestoneSummary>> builder(MarshallingType.LIST)
            .memberName("MilestoneSummaries")
            .getter(getter(ListMilestonesResponse::milestoneSummaries))
            .setter(setter(Builder::milestoneSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MilestoneSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MilestoneSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMilestonesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            MILESTONE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadId;

    private final List<MilestoneSummary> milestoneSummaries;

    private final String nextToken;

    private ListMilestonesResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneSummaries = builder.milestoneSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MilestoneSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMilestoneSummaries() {
        return milestoneSummaries != null && !(milestoneSummaries instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the MilestoneSummaries property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMilestoneSummaries} method.
     * </p>
     * 
     * @return The value of the MilestoneSummaries property for this object.
     */
    public final List<MilestoneSummary> milestoneSummaries() {
        return milestoneSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMilestoneSummaries() ? milestoneSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMilestonesResponse)) {
            return false;
        }
        ListMilestonesResponse other = (ListMilestonesResponse) obj;
        return Objects.equals(workloadId(), other.workloadId()) && hasMilestoneSummaries() == other.hasMilestoneSummaries()
                && Objects.equals(milestoneSummaries(), other.milestoneSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMilestonesResponse").add("WorkloadId", workloadId())
                .add("MilestoneSummaries", hasMilestoneSummaries() ? milestoneSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "MilestoneSummaries":
            return Optional.ofNullable(clazz.cast(milestoneSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("MilestoneSummaries", MILESTONE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMilestonesResponse, T> g) {
        return obj -> g.apply((ListMilestonesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMilestonesResponse> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the MilestoneSummaries property for this object.
         *
         * @param milestoneSummaries
         *        The new value for the MilestoneSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneSummaries(Collection<MilestoneSummary> milestoneSummaries);

        /**
         * Sets the value of the MilestoneSummaries property for this object.
         *
         * @param milestoneSummaries
         *        The new value for the MilestoneSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneSummaries(MilestoneSummary... milestoneSummaries);

        /**
         * Sets the value of the MilestoneSummaries property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.MilestoneSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.MilestoneSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.MilestoneSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #milestoneSummaries(List<MilestoneSummary>)}.
         * 
         * @param milestoneSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.MilestoneSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #milestoneSummaries(java.util.Collection<MilestoneSummary>)
         */
        Builder milestoneSummaries(Consumer<MilestoneSummary.Builder>... milestoneSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String workloadId;

        private List<MilestoneSummary> milestoneSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMilestonesResponse model) {
            super(model);
            workloadId(model.workloadId);
            milestoneSummaries(model.milestoneSummaries);
            nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final List<MilestoneSummary.Builder> getMilestoneSummaries() {
            List<MilestoneSummary.Builder> result = MilestoneSummariesCopier.copyToBuilder(this.milestoneSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMilestoneSummaries(Collection<MilestoneSummary.BuilderImpl> milestoneSummaries) {
            this.milestoneSummaries = MilestoneSummariesCopier.copyFromBuilder(milestoneSummaries);
        }

        @Override
        public final Builder milestoneSummaries(Collection<MilestoneSummary> milestoneSummaries) {
            this.milestoneSummaries = MilestoneSummariesCopier.copy(milestoneSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder milestoneSummaries(MilestoneSummary... milestoneSummaries) {
            milestoneSummaries(Arrays.asList(milestoneSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder milestoneSummaries(Consumer<MilestoneSummary.Builder>... milestoneSummaries) {
            milestoneSummaries(Stream.of(milestoneSummaries).map(c -> MilestoneSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMilestonesResponse build() {
            return new ListMilestonesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
