/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplateSharesResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListTemplateSharesResponse.Builder, ListTemplateSharesResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(ListTemplateSharesResponse::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<List<TemplateShareSummary>> TEMPLATE_SHARE_SUMMARIES_FIELD = SdkField
            .<List<TemplateShareSummary>> builder(MarshallingType.LIST)
            .memberName("TemplateShareSummaries")
            .getter(getter(ListTemplateSharesResponse::templateShareSummaries))
            .setter(setter(Builder::templateShareSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateShareSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateShareSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateShareSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTemplateSharesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            TEMPLATE_SHARE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateArn;

    private final List<TemplateShareSummary> templateShareSummaries;

    private final String nextToken;

    private ListTemplateSharesResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateShareSummaries = builder.templateShareSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The review template ARN.
     * </p>
     * 
     * @return The review template ARN.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateShareSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTemplateShareSummaries() {
        return templateShareSummaries != null && !(templateShareSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A review template share summary return object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateShareSummaries} method.
     * </p>
     * 
     * @return A review template share summary return object.
     */
    public final List<TemplateShareSummary> templateShareSummaries() {
        return templateShareSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateShareSummaries() ? templateShareSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateSharesResponse)) {
            return false;
        }
        ListTemplateSharesResponse other = (ListTemplateSharesResponse) obj;
        return Objects.equals(templateArn(), other.templateArn())
                && hasTemplateShareSummaries() == other.hasTemplateShareSummaries()
                && Objects.equals(templateShareSummaries(), other.templateShareSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplateSharesResponse").add("TemplateArn", templateArn())
                .add("TemplateShareSummaries", hasTemplateShareSummaries() ? templateShareSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "TemplateShareSummaries":
            return Optional.ofNullable(clazz.cast(templateShareSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("TemplateShareSummaries", TEMPLATE_SHARE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateSharesResponse, T> g) {
        return obj -> g.apply((ListTemplateSharesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTemplateSharesResponse> {
        /**
         * <p>
         * The review template ARN.
         * </p>
         * 
         * @param templateArn
         *        The review template ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * A review template share summary return object.
         * </p>
         * 
         * @param templateShareSummaries
         *        A review template share summary return object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateShareSummaries(Collection<TemplateShareSummary> templateShareSummaries);

        /**
         * <p>
         * A review template share summary return object.
         * </p>
         * 
         * @param templateShareSummaries
         *        A review template share summary return object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateShareSummaries(TemplateShareSummary... templateShareSummaries);

        /**
         * <p>
         * A review template share summary return object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.TemplateShareSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.TemplateShareSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.TemplateShareSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #templateShareSummaries(List<TemplateShareSummary>)}.
         * 
         * @param templateShareSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.TemplateShareSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateShareSummaries(java.util.Collection<TemplateShareSummary>)
         */
        Builder templateShareSummaries(Consumer<TemplateShareSummary.Builder>... templateShareSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String templateArn;

        private List<TemplateShareSummary> templateShareSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateSharesResponse model) {
            super(model);
            templateArn(model.templateArn);
            templateShareSummaries(model.templateShareSummaries);
            nextToken(model.nextToken);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final List<TemplateShareSummary.Builder> getTemplateShareSummaries() {
            List<TemplateShareSummary.Builder> result = TemplateShareSummariesCopier.copyToBuilder(this.templateShareSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateShareSummaries(Collection<TemplateShareSummary.BuilderImpl> templateShareSummaries) {
            this.templateShareSummaries = TemplateShareSummariesCopier.copyFromBuilder(templateShareSummaries);
        }

        @Override
        public final Builder templateShareSummaries(Collection<TemplateShareSummary> templateShareSummaries) {
            this.templateShareSummaries = TemplateShareSummariesCopier.copy(templateShareSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateShareSummaries(TemplateShareSummary... templateShareSummaries) {
            templateShareSummaries(Arrays.asList(templateShareSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateShareSummaries(Consumer<TemplateShareSummary.Builder>... templateShareSummaries) {
            templateShareSummaries(Stream.of(templateShareSummaries)
                    .map(c -> TemplateShareSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTemplateSharesResponse build() {
            return new ListTemplateSharesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
