/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The profile template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileTemplate implements SdkPojo, Serializable, ToCopyableBuilder<ProfileTemplate.Builder, ProfileTemplate> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(ProfileTemplate::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<List<ProfileTemplateQuestion>> TEMPLATE_QUESTIONS_FIELD = SdkField
            .<List<ProfileTemplateQuestion>> builder(MarshallingType.LIST)
            .memberName("TemplateQuestions")
            .getter(getter(ProfileTemplate::templateQuestions))
            .setter(setter(Builder::templateQuestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateQuestions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileTemplateQuestion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileTemplateQuestion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ProfileTemplate::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ProfileTemplate::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_QUESTIONS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final List<ProfileTemplateQuestion> templateQuestions;

    private final Instant createdAt;

    private final Instant updatedAt;

    private ProfileTemplate(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateQuestions = builder.templateQuestions;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The name of the profile template.
     * </p>
     * 
     * @return The name of the profile template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateQuestions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateQuestions() {
        return templateQuestions != null && !(templateQuestions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Profile template questions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateQuestions} method.
     * </p>
     * 
     * @return Profile template questions.
     */
    public final List<ProfileTemplateQuestion> templateQuestions() {
        return templateQuestions;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateQuestions() ? templateQuestions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileTemplate)) {
            return false;
        }
        ProfileTemplate other = (ProfileTemplate) obj;
        return Objects.equals(templateName(), other.templateName()) && hasTemplateQuestions() == other.hasTemplateQuestions()
                && Objects.equals(templateQuestions(), other.templateQuestions())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileTemplate").add("TemplateName", templateName())
                .add("TemplateQuestions", hasTemplateQuestions() ? templateQuestions() : null).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateQuestions":
            return Optional.ofNullable(clazz.cast(templateQuestions()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateQuestions", TEMPLATE_QUESTIONS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileTemplate, T> g) {
        return obj -> g.apply((ProfileTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileTemplate> {
        /**
         * <p>
         * The name of the profile template.
         * </p>
         * 
         * @param templateName
         *        The name of the profile template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * Profile template questions.
         * </p>
         * 
         * @param templateQuestions
         *        Profile template questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateQuestions(Collection<ProfileTemplateQuestion> templateQuestions);

        /**
         * <p>
         * Profile template questions.
         * </p>
         * 
         * @param templateQuestions
         *        Profile template questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateQuestions(ProfileTemplateQuestion... templateQuestions);

        /**
         * <p>
         * Profile template questions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileTemplateQuestion.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileTemplateQuestion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ProfileTemplateQuestion.Builder#build()} is
         * called immediately and its result is passed to {@link #templateQuestions(List<ProfileTemplateQuestion>)}.
         * 
         * @param templateQuestions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ProfileTemplateQuestion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateQuestions(java.util.Collection<ProfileTemplateQuestion>)
         */
        Builder templateQuestions(Consumer<ProfileTemplateQuestion.Builder>... templateQuestions);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private List<ProfileTemplateQuestion> templateQuestions = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileTemplate model) {
            templateName(model.templateName);
            templateQuestions(model.templateQuestions);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final List<ProfileTemplateQuestion.Builder> getTemplateQuestions() {
            List<ProfileTemplateQuestion.Builder> result = TemplateQuestionsCopier.copyToBuilder(this.templateQuestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateQuestions(Collection<ProfileTemplateQuestion.BuilderImpl> templateQuestions) {
            this.templateQuestions = TemplateQuestionsCopier.copyFromBuilder(templateQuestions);
        }

        @Override
        public final Builder templateQuestions(Collection<ProfileTemplateQuestion> templateQuestions) {
            this.templateQuestions = TemplateQuestionsCopier.copy(templateQuestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateQuestions(ProfileTemplateQuestion... templateQuestions) {
            templateQuestions(Arrays.asList(templateQuestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateQuestions(Consumer<ProfileTemplateQuestion.Builder>... templateQuestions) {
            templateQuestions(Stream.of(templateQuestions).map(c -> ProfileTemplateQuestion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ProfileTemplate build() {
            return new ProfileTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
