/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of a review template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewTemplatePillarReviewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReviewTemplatePillarReviewSummary.Builder, ReviewTemplatePillarReviewSummary> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(ReviewTemplatePillarReviewSummary::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> PILLAR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarName").getter(getter(ReviewTemplatePillarReviewSummary::pillarName))
            .setter(setter(Builder::pillarName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarName").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(ReviewTemplatePillarReviewSummary::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<Map<String, Integer>> QUESTION_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("QuestionCounts")
            .getter(getter(ReviewTemplatePillarReviewSummary::questionCountsAsStrings))
            .setter(setter(Builder::questionCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD,
            PILLAR_NAME_FIELD, NOTES_FIELD, QUESTION_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pillarId;

    private final String pillarName;

    private final String notes;

    private final Map<String, Integer> questionCounts;

    private ReviewTemplatePillarReviewSummary(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.pillarName = builder.pillarName;
        this.notes = builder.notes;
        this.questionCounts = builder.questionCounts;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the PillarName property for this object.
     * 
     * @return The value of the PillarName property for this object.
     */
    public final String pillarName() {
        return pillarName;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * <p>
     * A count of how many questions are answered and unanswered in the requested pillar of the lens review.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuestionCounts} method.
     * </p>
     * 
     * @return A count of how many questions are answered and unanswered in the requested pillar of the lens review.
     */
    public final Map<Question, Integer> questionCounts() {
        return QuestionCountsCopier.copyStringToEnum(questionCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the QuestionCounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQuestionCounts() {
        return questionCounts != null && !(questionCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A count of how many questions are answered and unanswered in the requested pillar of the lens review.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuestionCounts} method.
     * </p>
     * 
     * @return A count of how many questions are answered and unanswered in the requested pillar of the lens review.
     */
    public final Map<String, Integer> questionCountsAsStrings() {
        return questionCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(pillarName());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuestionCounts() ? questionCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplatePillarReviewSummary)) {
            return false;
        }
        ReviewTemplatePillarReviewSummary other = (ReviewTemplatePillarReviewSummary) obj;
        return Objects.equals(pillarId(), other.pillarId()) && Objects.equals(pillarName(), other.pillarName())
                && Objects.equals(notes(), other.notes()) && hasQuestionCounts() == other.hasQuestionCounts()
                && Objects.equals(questionCountsAsStrings(), other.questionCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReviewTemplatePillarReviewSummary").add("PillarId", pillarId()).add("PillarName", pillarName())
                .add("Notes", notes()).add("QuestionCounts", hasQuestionCounts() ? questionCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "PillarName":
            return Optional.ofNullable(clazz.cast(pillarName()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "QuestionCounts":
            return Optional.ofNullable(clazz.cast(questionCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("PillarName", PILLAR_NAME_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("QuestionCounts", QUESTION_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplatePillarReviewSummary, T> g) {
        return obj -> g.apply((ReviewTemplatePillarReviewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewTemplatePillarReviewSummary> {
        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the PillarName property for this object.
         *
         * @param pillarName
         *        The new value for the PillarName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarName(String pillarName);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * A count of how many questions are answered and unanswered in the requested pillar of the lens review.
         * </p>
         * 
         * @param questionCounts
         *        A count of how many questions are answered and unanswered in the requested pillar of the lens review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionCountsWithStrings(Map<String, Integer> questionCounts);

        /**
         * <p>
         * A count of how many questions are answered and unanswered in the requested pillar of the lens review.
         * </p>
         * 
         * @param questionCounts
         *        A count of how many questions are answered and unanswered in the requested pillar of the lens review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionCounts(Map<Question, Integer> questionCounts);
    }

    static final class BuilderImpl implements Builder {
        private String pillarId;

        private String pillarName;

        private String notes;

        private Map<String, Integer> questionCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplatePillarReviewSummary model) {
            pillarId(model.pillarId);
            pillarName(model.pillarName);
            notes(model.notes);
            questionCountsWithStrings(model.questionCounts);
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getPillarName() {
            return pillarName;
        }

        public final void setPillarName(String pillarName) {
            this.pillarName = pillarName;
        }

        @Override
        public final Builder pillarName(String pillarName) {
            this.pillarName = pillarName;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, Integer> getQuestionCounts() {
            if (questionCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return questionCounts;
        }

        public final void setQuestionCounts(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
        }

        @Override
        public final Builder questionCountsWithStrings(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
            return this;
        }

        @Override
        public final Builder questionCounts(Map<Question, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copyEnumToString(questionCounts);
            return this;
        }

        @Override
        public ReviewTemplatePillarReviewSummary build() {
            return new ReviewTemplatePillarReviewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
