/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReviewTemplateAnswerRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateReviewTemplateAnswerRequest.Builder, UpdateReviewTemplateAnswerRequest> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(UpdateReviewTemplateAnswerRequest::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(UpdateReviewTemplateAnswerRequest::lensAlias))
            .setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()).build();

    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(UpdateReviewTemplateAnswerRequest::questionId))
            .setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("QuestionId").build()).build();

    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedChoices")
            .getter(getter(UpdateReviewTemplateAnswerRequest::selectedChoices))
            .setter(setter(Builder::selectedChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, ChoiceUpdate>> CHOICE_UPDATES_FIELD = SdkField
            .<Map<String, ChoiceUpdate>> builder(MarshallingType.MAP)
            .memberName("ChoiceUpdates")
            .getter(getter(UpdateReviewTemplateAnswerRequest::choiceUpdates))
            .setter(setter(Builder::choiceUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceUpdates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ChoiceUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChoiceUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(UpdateReviewTemplateAnswerRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsApplicable").getter(getter(UpdateReviewTemplateAnswerRequest::isApplicable))
            .setter(setter(Builder::isApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(UpdateReviewTemplateAnswerRequest::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            LENS_ALIAS_FIELD, QUESTION_ID_FIELD, SELECTED_CHOICES_FIELD, CHOICE_UPDATES_FIELD, NOTES_FIELD, IS_APPLICABLE_FIELD,
            REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateArn;

    private final String lensAlias;

    private final String questionId;

    private final List<String> selectedChoices;

    private final Map<String, ChoiceUpdate> choiceUpdates;

    private final String notes;

    private final Boolean isApplicable;

    private final String reason;

    private UpdateReviewTemplateAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.lensAlias = builder.lensAlias;
        this.questionId = builder.questionId;
        this.selectedChoices = builder.selectedChoices;
        this.choiceUpdates = builder.choiceUpdates;
        this.notes = builder.notes;
        this.isApplicable = builder.isApplicable;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The review template ARN.
     * </p>
     * 
     * @return The review template ARN.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedChoices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedChoices() {
        return selectedChoices != null && !(selectedChoices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SelectedChoices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedChoices} method.
     * </p>
     * 
     * @return The value of the SelectedChoices property for this object.
     */
    public final List<String> selectedChoices() {
        return selectedChoices;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChoiceUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChoiceUpdates() {
        return choiceUpdates != null && !(choiceUpdates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of choices to be updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChoiceUpdates} method.
     * </p>
     * 
     * @return A list of choices to be updated.
     */
    public final Map<String, ChoiceUpdate> choiceUpdates() {
        return choiceUpdates;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * Returns the value of the IsApplicable property for this object.
     * 
     * @return The value of the IsApplicable property for this object.
     */
    public final Boolean isApplicable() {
        return isApplicable;
    }

    /**
     * <p>
     * The update reason.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link AnswerReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The update reason.
     * @see AnswerReason
     */
    public final AnswerReason reason() {
        return AnswerReason.fromValue(reason);
    }

    /**
     * <p>
     * The update reason.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link AnswerReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The update reason.
     * @see AnswerReason
     */
    public final String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedChoices() ? selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChoiceUpdates() ? choiceUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReviewTemplateAnswerRequest)) {
            return false;
        }
        UpdateReviewTemplateAnswerRequest other = (UpdateReviewTemplateAnswerRequest) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(lensAlias(), other.lensAlias())
                && Objects.equals(questionId(), other.questionId()) && hasSelectedChoices() == other.hasSelectedChoices()
                && Objects.equals(selectedChoices(), other.selectedChoices()) && hasChoiceUpdates() == other.hasChoiceUpdates()
                && Objects.equals(choiceUpdates(), other.choiceUpdates()) && Objects.equals(notes(), other.notes())
                && Objects.equals(isApplicable(), other.isApplicable())
                && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReviewTemplateAnswerRequest").add("TemplateArn", templateArn())
                .add("LensAlias", lensAlias()).add("QuestionId", questionId())
                .add("SelectedChoices", hasSelectedChoices() ? selectedChoices() : null)
                .add("ChoiceUpdates", hasChoiceUpdates() ? choiceUpdates() : null).add("Notes", notes())
                .add("IsApplicable", isApplicable()).add("Reason", reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "SelectedChoices":
            return Optional.ofNullable(clazz.cast(selectedChoices()));
        case "ChoiceUpdates":
            return Optional.ofNullable(clazz.cast(choiceUpdates()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "IsApplicable":
            return Optional.ofNullable(clazz.cast(isApplicable()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("SelectedChoices", SELECTED_CHOICES_FIELD);
        map.put("ChoiceUpdates", CHOICE_UPDATES_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("IsApplicable", IS_APPLICABLE_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReviewTemplateAnswerRequest, T> g) {
        return obj -> g.apply((UpdateReviewTemplateAnswerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateReviewTemplateAnswerRequest> {
        /**
         * <p>
         * The review template ARN.
         * </p>
         * 
         * @param templateArn
         *        The review template ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(Collection<String> selectedChoices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(String... selectedChoices);

        /**
         * <p>
         * A list of choices to be updated.
         * </p>
         * 
         * @param choiceUpdates
         *        A list of choices to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceUpdates(Map<String, ChoiceUpdate> choiceUpdates);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * Sets the value of the IsApplicable property for this object.
         *
         * @param isApplicable
         *        The new value for the IsApplicable property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isApplicable(Boolean isApplicable);

        /**
         * <p>
         * The update reason.
         * </p>
         * 
         * @param reason
         *        The update reason.
         * @see AnswerReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnswerReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The update reason.
         * </p>
         * 
         * @param reason
         *        The update reason.
         * @see AnswerReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnswerReason
         */
        Builder reason(AnswerReason reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String templateArn;

        private String lensAlias;

        private String questionId;

        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();

        private Map<String, ChoiceUpdate> choiceUpdates = DefaultSdkAutoConstructMap.getInstance();

        private String notes;

        private Boolean isApplicable;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReviewTemplateAnswerRequest model) {
            super(model);
            templateArn(model.templateArn);
            lensAlias(model.lensAlias);
            questionId(model.questionId);
            selectedChoices(model.selectedChoices);
            choiceUpdates(model.choiceUpdates);
            notes(model.notes);
            isApplicable(model.isApplicable);
            reason(model.reason);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final Collection<String> getSelectedChoices() {
            if (selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedChoices;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String... selectedChoices) {
            selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final Map<String, ChoiceUpdate.Builder> getChoiceUpdates() {
            Map<String, ChoiceUpdate.Builder> result = ChoiceUpdatesCopier.copyToBuilder(this.choiceUpdates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setChoiceUpdates(Map<String, ChoiceUpdate.BuilderImpl> choiceUpdates) {
            this.choiceUpdates = ChoiceUpdatesCopier.copyFromBuilder(choiceUpdates);
        }

        @Override
        public final Builder choiceUpdates(Map<String, ChoiceUpdate> choiceUpdates) {
            this.choiceUpdates = ChoiceUpdatesCopier.copy(choiceUpdates);
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Boolean getIsApplicable() {
            return isApplicable;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(AnswerReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReviewTemplateAnswerRequest build() {
            return new UpdateReviewTemplateAnswerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
