/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReviewTemplateRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<CreateReviewTemplateRequest.Builder, CreateReviewTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(CreateReviewTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateReviewTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> LENSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Lenses")
            .getter(getter(CreateReviewTemplateRequest::lenses))
            .setter(setter(Builder::lenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(CreateReviewTemplateRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateReviewTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateReviewTemplateRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            DESCRIPTION_FIELD, LENSES_FIELD, NOTES_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateName;

    private final String description;

    private final List<String> lenses;

    private final String notes;

    private final Map<String, String> tags;

    private final String clientRequestToken;

    private CreateReviewTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.lenses = builder.lenses;
        this.notes = builder.notes;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * Name of the review template.
     * </p>
     * 
     * @return Name of the review template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The review template description.
     * </p>
     * 
     * @return The review template description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lenses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLenses() {
        return lenses != null && !(lenses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lenses applied to the review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLenses} method.
     * </p>
     * 
     * @return Lenses applied to the review template.
     */
    public final List<String> lenses() {
        return lenses;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the review template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasLenses() ? lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReviewTemplateRequest)) {
            return false;
        }
        CreateReviewTemplateRequest other = (CreateReviewTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(description(), other.description())
                && hasLenses() == other.hasLenses() && Objects.equals(lenses(), other.lenses())
                && Objects.equals(notes(), other.notes()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReviewTemplateRequest").add("TemplateName", templateName())
                .add("Description", description()).add("Lenses", hasLenses() ? lenses() : null).add("Notes", notes())
                .add("Tags", hasTags() ? tags() : null).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Lenses":
            return Optional.ofNullable(clazz.cast(lenses()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Lenses", LENSES_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReviewTemplateRequest, T> g) {
        return obj -> g.apply((CreateReviewTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReviewTemplateRequest> {
        /**
         * <p>
         * Name of the review template.
         * </p>
         * 
         * @param templateName
         *        Name of the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The review template description.
         * </p>
         * 
         * @param description
         *        The review template description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Lenses applied to the review template.
         * </p>
         * 
         * @param lenses
         *        Lenses applied to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(Collection<String> lenses);

        /**
         * <p>
         * Lenses applied to the review template.
         * </p>
         * 
         * @param lenses
         *        Lenses applied to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(String... lenses);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * The tags assigned to the review template.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String templateName;

        private String description;

        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();

        private String notes;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReviewTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            description(model.description);
            lenses(model.lenses);
            notes(model.notes);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getLenses() {
            if (lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String... lenses) {
            lenses(Arrays.asList(lenses));
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReviewTemplateRequest build() {
            return new CreateReviewTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
