/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLensRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<DeleteLensRequest.Builder, DeleteLensRequest> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(DeleteLensRequest::lensAlias)).setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(DeleteLensRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensStatus").getter(getter(DeleteLensRequest::lensStatusAsString)).setter(setter(Builder::lensStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, LENS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lensAlias;

    private final String clientRequestToken;

    private final String lensStatus;

    private DeleteLensRequest(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.clientRequestToken = builder.clientRequestToken;
        this.lensStatus = builder.lensStatus;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The status of the lens to be deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of the lens to be deleted.
     * @see LensStatusType
     */
    public final LensStatusType lensStatus() {
        return LensStatusType.fromValue(lensStatus);
    }

    /**
     * <p>
     * The status of the lens to be deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lensStatus} will
     * return {@link LensStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lensStatusAsString}.
     * </p>
     * 
     * @return The status of the lens to be deleted.
     * @see LensStatusType
     */
    public final String lensStatusAsString() {
        return lensStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(lensStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLensRequest)) {
            return false;
        }
        DeleteLensRequest other = (DeleteLensRequest) obj;
        return Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(lensStatusAsString(), other.lensStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLensRequest").add("LensAlias", lensAlias())
                .add("ClientRequestToken", clientRequestToken()).add("LensStatus", lensStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "LensStatus":
            return Optional.ofNullable(clazz.cast(lensStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("LensStatus", LENS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLensRequest, T> g) {
        return obj -> g.apply((DeleteLensRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteLensRequest> {
        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The status of the lens to be deleted.
         * </p>
         * 
         * @param lensStatus
         *        The status of the lens to be deleted.
         * @see LensStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatusType
         */
        Builder lensStatus(String lensStatus);

        /**
         * <p>
         * The status of the lens to be deleted.
         * </p>
         * 
         * @param lensStatus
         *        The status of the lens to be deleted.
         * @see LensStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LensStatusType
         */
        Builder lensStatus(LensStatusType lensStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String lensAlias;

        private String clientRequestToken;

        private String lensStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLensRequest model) {
            super(model);
            lensAlias(model.lensAlias);
            clientRequestToken(model.clientRequestToken);
            lensStatus(model.lensStatus);
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getLensStatus() {
            return lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatusType lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLensRequest build() {
            return new DeleteLensRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
