/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConsolidatedReportResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<GetConsolidatedReportResponse.Builder, GetConsolidatedReportResponse> {
    private static final SdkField<List<ConsolidatedReportMetric>> METRICS_FIELD = SdkField
            .<List<ConsolidatedReportMetric>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(GetConsolidatedReportResponse::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConsolidatedReportMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConsolidatedReportMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetConsolidatedReportResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> BASE64_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Base64String").getter(getter(GetConsolidatedReportResponse::base64String))
            .setter(setter(Builder::base64String))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base64String").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD,
            NEXT_TOKEN_FIELD, BASE64_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConsolidatedReportMetric> metrics;

    private final String nextToken;

    private final String base64String;

    private GetConsolidatedReportResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
        this.base64String = builder.base64String;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics that make up the consolidated report.
     * </p>
     * <p>
     * Only returned when <code>JSON</code> format is requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics that make up the consolidated report.</p>
     *         <p>
     *         Only returned when <code>JSON</code> format is requested.
     */
    public final List<ConsolidatedReportMetric> metrics() {
        return metrics;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the Base64String property for this object.
     * 
     * @return The value of the Base64String property for this object.
     */
    public final String base64String() {
        return base64String;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(base64String());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsolidatedReportResponse)) {
            return false;
        }
        GetConsolidatedReportResponse other = (GetConsolidatedReportResponse) obj;
        return hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(base64String(), other.base64String());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConsolidatedReportResponse").add("Metrics", hasMetrics() ? metrics() : null)
                .add("NextToken", nextToken()).add("Base64String", base64String()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Base64String":
            return Optional.ofNullable(clazz.cast(base64String()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metrics", METRICS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Base64String", BASE64_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConsolidatedReportResponse, T> g) {
        return obj -> g.apply((GetConsolidatedReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConsolidatedReportResponse> {
        /**
         * <p>
         * The metrics that make up the consolidated report.
         * </p>
         * <p>
         * Only returned when <code>JSON</code> format is requested.
         * </p>
         * 
         * @param metrics
         *        The metrics that make up the consolidated report.</p>
         *        <p>
         *        Only returned when <code>JSON</code> format is requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<ConsolidatedReportMetric> metrics);

        /**
         * <p>
         * The metrics that make up the consolidated report.
         * </p>
         * <p>
         * Only returned when <code>JSON</code> format is requested.
         * </p>
         * 
         * @param metrics
         *        The metrics that make up the consolidated report.</p>
         *        <p>
         *        Only returned when <code>JSON</code> format is requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(ConsolidatedReportMetric... metrics);

        /**
         * <p>
         * The metrics that make up the consolidated report.
         * </p>
         * <p>
         * Only returned when <code>JSON</code> format is requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ConsolidatedReportMetric.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.ConsolidatedReportMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ConsolidatedReportMetric.Builder#build()} is
         * called immediately and its result is passed to {@link #metrics(List<ConsolidatedReportMetric>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ConsolidatedReportMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<ConsolidatedReportMetric>)
         */
        Builder metrics(Consumer<ConsolidatedReportMetric.Builder>... metrics);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the Base64String property for this object.
         *
         * @param base64String
         *        The new value for the Base64String property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base64String(String base64String);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private List<ConsolidatedReportMetric> metrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String base64String;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsolidatedReportResponse model) {
            super(model);
            metrics(model.metrics);
            nextToken(model.nextToken);
            base64String(model.base64String);
        }

        public final List<ConsolidatedReportMetric.Builder> getMetrics() {
            List<ConsolidatedReportMetric.Builder> result = ConsolidatedReportMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<ConsolidatedReportMetric.BuilderImpl> metrics) {
            this.metrics = ConsolidatedReportMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<ConsolidatedReportMetric> metrics) {
            this.metrics = ConsolidatedReportMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(ConsolidatedReportMetric... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<ConsolidatedReportMetric.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> ConsolidatedReportMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getBase64String() {
            return base64String;
        }

        public final void setBase64String(String base64String) {
            this.base64String = base64String;
        }

        @Override
        public final Builder base64String(String base64String) {
            this.base64String = base64String;
            return this;
        }

        @Override
        public GetConsolidatedReportResponse build() {
            return new GetConsolidatedReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
