/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLensVersionDifferenceRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<GetLensVersionDifferenceRequest.Builder, GetLensVersionDifferenceRequest> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(GetLensVersionDifferenceRequest::lensAlias))
            .setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()).build();

    private static final SdkField<String> BASE_LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseLensVersion").getter(getter(GetLensVersionDifferenceRequest::baseLensVersion))
            .setter(setter(Builder::baseLensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("BaseLensVersion").build())
            .build();

    private static final SdkField<String> TARGET_LENS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetLensVersion").getter(getter(GetLensVersionDifferenceRequest::targetLensVersion))
            .setter(setter(Builder::targetLensVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TargetLensVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD,
            BASE_LENS_VERSION_FIELD, TARGET_LENS_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lensAlias;

    private final String baseLensVersion;

    private final String targetLensVersion;

    private GetLensVersionDifferenceRequest(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.baseLensVersion = builder.baseLensVersion;
        this.targetLensVersion = builder.targetLensVersion;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The base version of the lens.
     * </p>
     * 
     * @return The base version of the lens.
     */
    public final String baseLensVersion() {
        return baseLensVersion;
    }

    /**
     * <p>
     * The lens version to target a difference for.
     * </p>
     * 
     * @return The lens version to target a difference for.
     */
    public final String targetLensVersion() {
        return targetLensVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(baseLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetLensVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensVersionDifferenceRequest)) {
            return false;
        }
        GetLensVersionDifferenceRequest other = (GetLensVersionDifferenceRequest) obj;
        return Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(baseLensVersion(), other.baseLensVersion())
                && Objects.equals(targetLensVersion(), other.targetLensVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLensVersionDifferenceRequest").add("LensAlias", lensAlias())
                .add("BaseLensVersion", baseLensVersion()).add("TargetLensVersion", targetLensVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "BaseLensVersion":
            return Optional.ofNullable(clazz.cast(baseLensVersion()));
        case "TargetLensVersion":
            return Optional.ofNullable(clazz.cast(targetLensVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("BaseLensVersion", BASE_LENS_VERSION_FIELD);
        map.put("TargetLensVersion", TARGET_LENS_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLensVersionDifferenceRequest, T> g) {
        return obj -> g.apply((GetLensVersionDifferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLensVersionDifferenceRequest> {
        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The base version of the lens.
         * </p>
         * 
         * @param baseLensVersion
         *        The base version of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseLensVersion(String baseLensVersion);

        /**
         * <p>
         * The lens version to target a difference for.
         * </p>
         * 
         * @param targetLensVersion
         *        The lens version to target a difference for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLensVersion(String targetLensVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String lensAlias;

        private String baseLensVersion;

        private String targetLensVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensVersionDifferenceRequest model) {
            super(model);
            lensAlias(model.lensAlias);
            baseLensVersion(model.baseLensVersion);
            targetLensVersion(model.targetLensVersion);
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getBaseLensVersion() {
            return baseLensVersion;
        }

        public final void setBaseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
        }

        @Override
        public final Builder baseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
            return this;
        }

        public final String getTargetLensVersion() {
            return targetLensVersion;
        }

        public final void setTargetLensVersion(String targetLensVersion) {
            this.targetLensVersion = targetLensVersion;
        }

        @Override
        public final Builder targetLensVersion(String targetLensVersion) {
            this.targetLensVersion = targetLensVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLensVersionDifferenceRequest build() {
            return new GetLensVersionDifferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
