/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the Jira integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JiraConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<JiraConfiguration.Builder, JiraConfiguration> {
    private static final SdkField<String> JIRA_ISSUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JiraIssueUrl").getter(getter(JiraConfiguration::jiraIssueUrl)).setter(setter(Builder::jiraIssueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraIssueUrl").build()).build();

    private static final SdkField<Instant> LAST_SYNCED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSyncedTime").getter(getter(JiraConfiguration::lastSyncedTime))
            .setter(setter(Builder::lastSyncedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JIRA_ISSUE_URL_FIELD,
            LAST_SYNCED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jiraIssueUrl;

    private final Instant lastSyncedTime;

    private JiraConfiguration(BuilderImpl builder) {
        this.jiraIssueUrl = builder.jiraIssueUrl;
        this.lastSyncedTime = builder.lastSyncedTime;
    }

    /**
     * <p>
     * The URL of the associated Jira issue.
     * </p>
     * 
     * @return The URL of the associated Jira issue.
     */
    public final String jiraIssueUrl() {
        return jiraIssueUrl;
    }

    /**
     * Returns the value of the LastSyncedTime property for this object.
     * 
     * @return The value of the LastSyncedTime property for this object.
     */
    public final Instant lastSyncedTime() {
        return lastSyncedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jiraIssueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(lastSyncedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraConfiguration)) {
            return false;
        }
        JiraConfiguration other = (JiraConfiguration) obj;
        return Objects.equals(jiraIssueUrl(), other.jiraIssueUrl()) && Objects.equals(lastSyncedTime(), other.lastSyncedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JiraConfiguration").add("JiraIssueUrl", jiraIssueUrl()).add("LastSyncedTime", lastSyncedTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JiraIssueUrl":
            return Optional.ofNullable(clazz.cast(jiraIssueUrl()));
        case "LastSyncedTime":
            return Optional.ofNullable(clazz.cast(lastSyncedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JiraIssueUrl", JIRA_ISSUE_URL_FIELD);
        map.put("LastSyncedTime", LAST_SYNCED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JiraConfiguration, T> g) {
        return obj -> g.apply((JiraConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JiraConfiguration> {
        /**
         * <p>
         * The URL of the associated Jira issue.
         * </p>
         * 
         * @param jiraIssueUrl
         *        The URL of the associated Jira issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraIssueUrl(String jiraIssueUrl);

        /**
         * Sets the value of the LastSyncedTime property for this object.
         *
         * @param lastSyncedTime
         *        The new value for the LastSyncedTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSyncedTime(Instant lastSyncedTime);
    }

    static final class BuilderImpl implements Builder {
        private String jiraIssueUrl;

        private Instant lastSyncedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(JiraConfiguration model) {
            jiraIssueUrl(model.jiraIssueUrl);
            lastSyncedTime(model.lastSyncedTime);
        }

        public final String getJiraIssueUrl() {
            return jiraIssueUrl;
        }

        public final void setJiraIssueUrl(String jiraIssueUrl) {
            this.jiraIssueUrl = jiraIssueUrl;
        }

        @Override
        public final Builder jiraIssueUrl(String jiraIssueUrl) {
            this.jiraIssueUrl = jiraIssueUrl;
            return this;
        }

        public final Instant getLastSyncedTime() {
            return lastSyncedTime;
        }

        public final void setLastSyncedTime(Instant lastSyncedTime) {
            this.lastSyncedTime = lastSyncedTime;
        }

        @Override
        public final Builder lastSyncedTime(Instant lastSyncedTime) {
            this.lastSyncedTime = lastSyncedTime;
            return this;
        }

        @Override
        public JiraConfiguration build() {
            return new JiraConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
