/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A metric for a particular lens in a workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LensMetric implements SdkPojo, Serializable, ToCopyableBuilder<LensMetric.Builder, LensMetric> {
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(LensMetric::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<List<PillarMetric>> PILLARS_FIELD = SdkField
            .<List<PillarMetric>> builder(MarshallingType.LIST)
            .memberName("Pillars")
            .getter(getter(LensMetric::pillars))
            .setter(setter(Builder::pillars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pillars").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PillarMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(PillarMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("RiskCounts")
            .getter(getter(LensMetric::riskCountsAsStrings))
            .setter(setter(Builder::riskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ARN_FIELD, PILLARS_FIELD,
            RISK_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lensArn;

    private final List<PillarMetric> pillars;

    private final Map<String, Integer> riskCounts;

    private LensMetric(BuilderImpl builder) {
        this.lensArn = builder.lensArn;
        this.pillars = builder.pillars;
        this.riskCounts = builder.riskCounts;
    }

    /**
     * <p>
     * The lens ARN.
     * </p>
     * 
     * @return The lens ARN.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pillars property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPillars() {
        return pillars != null && !(pillars instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics for the pillars in a lens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillars} method.
     * </p>
     * 
     * @return The metrics for the pillars in a lens.
     */
    public final List<PillarMetric> pillars() {
        return pillars;
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(riskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskCounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRiskCounts() {
        return riskCounts != null && !(riskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<String, Integer> riskCountsAsStrings() {
        return riskCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPillars() ? pillars() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskCounts() ? riskCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensMetric)) {
            return false;
        }
        LensMetric other = (LensMetric) obj;
        return Objects.equals(lensArn(), other.lensArn()) && hasPillars() == other.hasPillars()
                && Objects.equals(pillars(), other.pillars()) && hasRiskCounts() == other.hasRiskCounts()
                && Objects.equals(riskCountsAsStrings(), other.riskCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LensMetric").add("LensArn", lensArn()).add("Pillars", hasPillars() ? pillars() : null)
                .add("RiskCounts", hasRiskCounts() ? riskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "Pillars":
            return Optional.ofNullable(clazz.cast(pillars()));
        case "RiskCounts":
            return Optional.ofNullable(clazz.cast(riskCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("Pillars", PILLARS_FIELD);
        map.put("RiskCounts", RISK_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LensMetric, T> g) {
        return obj -> g.apply((LensMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LensMetric> {
        /**
         * <p>
         * The lens ARN.
         * </p>
         * 
         * @param lensArn
         *        The lens ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * <p>
         * The metrics for the pillars in a lens.
         * </p>
         * 
         * @param pillars
         *        The metrics for the pillars in a lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillars(Collection<PillarMetric> pillars);

        /**
         * <p>
         * The metrics for the pillars in a lens.
         * </p>
         * 
         * @param pillars
         *        The metrics for the pillars in a lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillars(PillarMetric... pillars);

        /**
         * <p>
         * The metrics for the pillars in a lens.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.PillarMetric.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.wellarchitected.model.PillarMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.PillarMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #pillars(List<PillarMetric>)}.
         * 
         * @param pillars
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.PillarMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pillars(java.util.Collection<PillarMetric>)
         */
        Builder pillars(Consumer<PillarMetric.Builder>... pillars);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCountsWithStrings(Map<String, Integer> riskCounts);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCounts(Map<Risk, Integer> riskCounts);
    }

    static final class BuilderImpl implements Builder {
        private String lensArn;

        private List<PillarMetric> pillars = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LensMetric model) {
            lensArn(model.lensArn);
            pillars(model.pillars);
            riskCountsWithStrings(model.riskCounts);
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final List<PillarMetric.Builder> getPillars() {
            List<PillarMetric.Builder> result = PillarMetricsCopier.copyToBuilder(this.pillars);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPillars(Collection<PillarMetric.BuilderImpl> pillars) {
            this.pillars = PillarMetricsCopier.copyFromBuilder(pillars);
        }

        @Override
        public final Builder pillars(Collection<PillarMetric> pillars) {
            this.pillars = PillarMetricsCopier.copy(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(PillarMetric... pillars) {
            pillars(Arrays.asList(pillars));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(Consumer<PillarMetric.Builder>... pillars) {
            pillars(Stream.of(pillars).map(c -> PillarMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        @Override
        public LensMetric build() {
            return new LensMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
