/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output of a list lens review improvements call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLensReviewImprovementsResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<ListLensReviewImprovementsResponse.Builder, ListLensReviewImprovementsResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ListLensReviewImprovementsResponse::workloadId))
            .setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MilestoneNumber").getter(getter(ListLensReviewImprovementsResponse::milestoneNumber))
            .setter(setter(Builder::milestoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()).build();

    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensAlias").getter(getter(ListLensReviewImprovementsResponse::lensAlias))
            .setter(setter(Builder::lensAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(ListLensReviewImprovementsResponse::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<List<ImprovementSummary>> IMPROVEMENT_SUMMARIES_FIELD = SdkField
            .<List<ImprovementSummary>> builder(MarshallingType.LIST)
            .memberName("ImprovementSummaries")
            .getter(getter(ListLensReviewImprovementsResponse::improvementSummaries))
            .setter(setter(Builder::improvementSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImprovementSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImprovementSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLensReviewImprovementsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            MILESTONE_NUMBER_FIELD, LENS_ALIAS_FIELD, LENS_ARN_FIELD, IMPROVEMENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadId;

    private final Integer milestoneNumber;

    private final String lensAlias;

    private final String lensArn;

    private final List<ImprovementSummary> improvementSummaries;

    private final String nextToken;

    private ListLensReviewImprovementsResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneNumber = builder.milestoneNumber;
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.improvementSummaries = builder.improvementSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the MilestoneNumber property for this object.
     * 
     * @return The value of the MilestoneNumber property for this object.
     */
    public final Integer milestoneNumber() {
        return milestoneNumber;
    }

    /**
     * Returns the value of the LensAlias property for this object.
     * 
     * @return The value of the LensAlias property for this object.
     */
    public final String lensAlias() {
        return lensAlias;
    }

    /**
     * <p>
     * The ARN for the lens.
     * </p>
     * 
     * @return The ARN for the lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImprovementSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImprovementSummaries() {
        return improvementSummaries != null && !(improvementSummaries instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ImprovementSummaries property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImprovementSummaries} method.
     * </p>
     * 
     * @return The value of the ImprovementSummaries property for this object.
     */
    public final List<ImprovementSummary> improvementSummaries() {
        return improvementSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasImprovementSummaries() ? improvementSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensReviewImprovementsResponse)) {
            return false;
        }
        ListLensReviewImprovementsResponse other = (ListLensReviewImprovementsResponse) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(milestoneNumber(), other.milestoneNumber())
                && Objects.equals(lensAlias(), other.lensAlias()) && Objects.equals(lensArn(), other.lensArn())
                && hasImprovementSummaries() == other.hasImprovementSummaries()
                && Objects.equals(improvementSummaries(), other.improvementSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLensReviewImprovementsResponse").add("WorkloadId", workloadId())
                .add("MilestoneNumber", milestoneNumber()).add("LensAlias", lensAlias()).add("LensArn", lensArn())
                .add("ImprovementSummaries", hasImprovementSummaries() ? improvementSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "MilestoneNumber":
            return Optional.ofNullable(clazz.cast(milestoneNumber()));
        case "LensAlias":
            return Optional.ofNullable(clazz.cast(lensAlias()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "ImprovementSummaries":
            return Optional.ofNullable(clazz.cast(improvementSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("MilestoneNumber", MILESTONE_NUMBER_FIELD);
        map.put("LensAlias", LENS_ALIAS_FIELD);
        map.put("LensArn", LENS_ARN_FIELD);
        map.put("ImprovementSummaries", IMPROVEMENT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLensReviewImprovementsResponse, T> g) {
        return obj -> g.apply((ListLensReviewImprovementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLensReviewImprovementsResponse> {
        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the MilestoneNumber property for this object.
         *
         * @param milestoneNumber
         *        The new value for the MilestoneNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder milestoneNumber(Integer milestoneNumber);

        /**
         * Sets the value of the LensAlias property for this object.
         *
         * @param lensAlias
         *        The new value for the LensAlias property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensAlias(String lensAlias);

        /**
         * <p>
         * The ARN for the lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN for the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * Sets the value of the ImprovementSummaries property for this object.
         *
         * @param improvementSummaries
         *        The new value for the ImprovementSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder improvementSummaries(Collection<ImprovementSummary> improvementSummaries);

        /**
         * Sets the value of the ImprovementSummaries property for this object.
         *
         * @param improvementSummaries
         *        The new value for the ImprovementSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder improvementSummaries(ImprovementSummary... improvementSummaries);

        /**
         * Sets the value of the ImprovementSummaries property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.ImprovementSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.ImprovementSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.ImprovementSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #improvementSummaries(List<ImprovementSummary>)}.
         * 
         * @param improvementSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.ImprovementSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #improvementSummaries(java.util.Collection<ImprovementSummary>)
         */
        Builder improvementSummaries(Consumer<ImprovementSummary.Builder>... improvementSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private String workloadId;

        private Integer milestoneNumber;

        private String lensAlias;

        private String lensArn;

        private List<ImprovementSummary> improvementSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensReviewImprovementsResponse model) {
            super(model);
            workloadId(model.workloadId);
            milestoneNumber(model.milestoneNumber);
            lensAlias(model.lensAlias);
            lensArn(model.lensArn);
            improvementSummaries(model.improvementSummaries);
            nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Integer getMilestoneNumber() {
            return milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final String getLensAlias() {
            return lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final List<ImprovementSummary.Builder> getImprovementSummaries() {
            List<ImprovementSummary.Builder> result = ImprovementSummariesCopier.copyToBuilder(this.improvementSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImprovementSummaries(Collection<ImprovementSummary.BuilderImpl> improvementSummaries) {
            this.improvementSummaries = ImprovementSummariesCopier.copyFromBuilder(improvementSummaries);
        }

        @Override
        public final Builder improvementSummaries(Collection<ImprovementSummary> improvementSummaries) {
            this.improvementSummaries = ImprovementSummariesCopier.copy(improvementSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder improvementSummaries(ImprovementSummary... improvementSummaries) {
            improvementSummaries(Arrays.asList(improvementSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder improvementSummaries(Consumer<ImprovementSummary.Builder>... improvementSummaries) {
            improvementSummaries(Stream.of(improvementSummaries).map(c -> ImprovementSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLensReviewImprovementsResponse build() {
            return new ListLensReviewImprovementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
