/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An update to a profile question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileQuestionUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileQuestionUpdate.Builder, ProfileQuestionUpdate> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(ProfileQuestionUpdate::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<List<String>> SELECTED_CHOICE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedChoiceIds")
            .getter(getter(ProfileQuestionUpdate::selectedChoiceIds))
            .setter(setter(Builder::selectedChoiceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoiceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD,
            SELECTED_CHOICE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final List<String> selectedChoiceIds;

    private ProfileQuestionUpdate(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.selectedChoiceIds = builder.selectedChoiceIds;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedChoiceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedChoiceIds() {
        return selectedChoiceIds != null && !(selectedChoiceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selected choices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedChoiceIds} method.
     * </p>
     * 
     * @return The selected choices.
     */
    public final List<String> selectedChoiceIds() {
        return selectedChoiceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedChoiceIds() ? selectedChoiceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileQuestionUpdate)) {
            return false;
        }
        ProfileQuestionUpdate other = (ProfileQuestionUpdate) obj;
        return Objects.equals(questionId(), other.questionId()) && hasSelectedChoiceIds() == other.hasSelectedChoiceIds()
                && Objects.equals(selectedChoiceIds(), other.selectedChoiceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileQuestionUpdate").add("QuestionId", questionId())
                .add("SelectedChoiceIds", hasSelectedChoiceIds() ? selectedChoiceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "SelectedChoiceIds":
            return Optional.ofNullable(clazz.cast(selectedChoiceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("SelectedChoiceIds", SELECTED_CHOICE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileQuestionUpdate, T> g) {
        return obj -> g.apply((ProfileQuestionUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileQuestionUpdate> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * <p>
         * The selected choices.
         * </p>
         * 
         * @param selectedChoiceIds
         *        The selected choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoiceIds(Collection<String> selectedChoiceIds);

        /**
         * <p>
         * The selected choices.
         * </p>
         * 
         * @param selectedChoiceIds
         *        The selected choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoiceIds(String... selectedChoiceIds);
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private List<String> selectedChoiceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileQuestionUpdate model) {
            questionId(model.questionId);
            selectedChoiceIds(model.selectedChoiceIds);
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final Collection<String> getSelectedChoiceIds() {
            if (selectedChoiceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedChoiceIds;
        }

        public final void setSelectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedProfileChoiceIdsCopier.copy(selectedChoiceIds);
        }

        @Override
        public final Builder selectedChoiceIds(Collection<String> selectedChoiceIds) {
            this.selectedChoiceIds = SelectedProfileChoiceIdsCopier.copy(selectedChoiceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoiceIds(String... selectedChoiceIds) {
            selectedChoiceIds(Arrays.asList(selectedChoiceIds));
            return this;
        }

        @Override
        public ProfileQuestionUpdate build() {
            return new ProfileQuestionUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
