/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The differences between the base and latest versions of the lens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersionDifferences implements SdkPojo, Serializable,
        ToCopyableBuilder<VersionDifferences.Builder, VersionDifferences> {
    private static final SdkField<List<PillarDifference>> PILLAR_DIFFERENCES_FIELD = SdkField
            .<List<PillarDifference>> builder(MarshallingType.LIST)
            .memberName("PillarDifferences")
            .getter(getter(VersionDifferences::pillarDifferences))
            .setter(setter(Builder::pillarDifferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarDifferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PillarDifference> builder(MarshallingType.SDK_POJO)
                                            .constructor(PillarDifference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_DIFFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PillarDifference> pillarDifferences;

    private VersionDifferences(BuilderImpl builder) {
        this.pillarDifferences = builder.pillarDifferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the PillarDifferences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPillarDifferences() {
        return pillarDifferences != null && !(pillarDifferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The differences between the base and latest versions of the lens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillarDifferences} method.
     * </p>
     * 
     * @return The differences between the base and latest versions of the lens.
     */
    public final List<PillarDifference> pillarDifferences() {
        return pillarDifferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPillarDifferences() ? pillarDifferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionDifferences)) {
            return false;
        }
        VersionDifferences other = (VersionDifferences) obj;
        return hasPillarDifferences() == other.hasPillarDifferences()
                && Objects.equals(pillarDifferences(), other.pillarDifferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VersionDifferences")
                .add("PillarDifferences", hasPillarDifferences() ? pillarDifferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PillarDifferences":
            return Optional.ofNullable(clazz.cast(pillarDifferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PillarDifferences", PILLAR_DIFFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VersionDifferences, T> g) {
        return obj -> g.apply((VersionDifferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersionDifferences> {
        /**
         * <p>
         * The differences between the base and latest versions of the lens.
         * </p>
         * 
         * @param pillarDifferences
         *        The differences between the base and latest versions of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarDifferences(Collection<PillarDifference> pillarDifferences);

        /**
         * <p>
         * The differences between the base and latest versions of the lens.
         * </p>
         * 
         * @param pillarDifferences
         *        The differences between the base and latest versions of the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarDifferences(PillarDifference... pillarDifferences);

        /**
         * <p>
         * The differences between the base and latest versions of the lens.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wellarchitected.model.PillarDifference.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wellarchitected.model.PillarDifference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wellarchitected.model.PillarDifference.Builder#build()} is called
         * immediately and its result is passed to {@link #pillarDifferences(List<PillarDifference>)}.
         * 
         * @param pillarDifferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wellarchitected.model.PillarDifference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pillarDifferences(java.util.Collection<PillarDifference>)
         */
        Builder pillarDifferences(Consumer<PillarDifference.Builder>... pillarDifferences);
    }

    static final class BuilderImpl implements Builder {
        private List<PillarDifference> pillarDifferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VersionDifferences model) {
            pillarDifferences(model.pillarDifferences);
        }

        public final List<PillarDifference.Builder> getPillarDifferences() {
            List<PillarDifference.Builder> result = PillarDifferencesCopier.copyToBuilder(this.pillarDifferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPillarDifferences(Collection<PillarDifference.BuilderImpl> pillarDifferences) {
            this.pillarDifferences = PillarDifferencesCopier.copyFromBuilder(pillarDifferences);
        }

        @Override
        public final Builder pillarDifferences(Collection<PillarDifference> pillarDifferences) {
            this.pillarDifferences = PillarDifferencesCopier.copy(pillarDifferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarDifferences(PillarDifference... pillarDifferences) {
            pillarDifferences(Arrays.asList(pillarDifferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarDifferences(Consumer<PillarDifference.Builder>... pillarDifferences) {
            pillarDifferences(Stream.of(pillarDifferences).map(c -> PillarDifference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public VersionDifferences build() {
            return new VersionDifferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
