/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Discovery configuration associated to the workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadDiscoveryConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadDiscoveryConfig.Builder, WorkloadDiscoveryConfig> {
    private static final SdkField<String> TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrustedAdvisorIntegrationStatus")
            .getter(getter(WorkloadDiscoveryConfig::trustedAdvisorIntegrationStatusAsString))
            .setter(setter(Builder::trustedAdvisorIntegrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedAdvisorIntegrationStatus")
                    .build()).build();

    private static final SdkField<List<String>> WORKLOAD_RESOURCE_DEFINITION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WorkloadResourceDefinition")
            .getter(getter(WorkloadDiscoveryConfig::workloadResourceDefinitionAsStrings))
            .setter(setter(Builder::workloadResourceDefinitionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadResourceDefinition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD, WORKLOAD_RESOURCE_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trustedAdvisorIntegrationStatus;

    private final List<String> workloadResourceDefinition;

    private WorkloadDiscoveryConfig(BuilderImpl builder) {
        this.trustedAdvisorIntegrationStatus = builder.trustedAdvisorIntegrationStatus;
        this.workloadResourceDefinition = builder.workloadResourceDefinition;
    }

    /**
     * <p>
     * Discovery integration status in respect to Trusted Advisor for the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedAdvisorIntegrationStatus} will return
     * {@link TrustedAdvisorIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trustedAdvisorIntegrationStatusAsString}.
     * </p>
     * 
     * @return Discovery integration status in respect to Trusted Advisor for the workload.
     * @see TrustedAdvisorIntegrationStatus
     */
    public final TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus() {
        return TrustedAdvisorIntegrationStatus.fromValue(trustedAdvisorIntegrationStatus);
    }

    /**
     * <p>
     * Discovery integration status in respect to Trusted Advisor for the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trustedAdvisorIntegrationStatus} will return
     * {@link TrustedAdvisorIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #trustedAdvisorIntegrationStatusAsString}.
     * </p>
     * 
     * @return Discovery integration status in respect to Trusted Advisor for the workload.
     * @see TrustedAdvisorIntegrationStatus
     */
    public final String trustedAdvisorIntegrationStatusAsString() {
        return trustedAdvisorIntegrationStatus;
    }

    /**
     * <p>
     * The mode to use for identifying resources associated with the workload.
     * </p>
     * <p>
     * You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkloadResourceDefinition} method.
     * </p>
     * 
     * @return The mode to use for identifying resources associated with the workload.</p>
     *         <p>
     *         You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
     */
    public final List<DefinitionType> workloadResourceDefinition() {
        return WorkloadResourceDefinitionCopier.copyStringToEnum(workloadResourceDefinition);
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkloadResourceDefinition property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkloadResourceDefinition() {
        return workloadResourceDefinition != null && !(workloadResourceDefinition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The mode to use for identifying resources associated with the workload.
     * </p>
     * <p>
     * You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkloadResourceDefinition} method.
     * </p>
     * 
     * @return The mode to use for identifying resources associated with the workload.</p>
     *         <p>
     *         You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
     */
    public final List<String> workloadResourceDefinitionAsStrings() {
        return workloadResourceDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trustedAdvisorIntegrationStatusAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasWorkloadResourceDefinition() ? workloadResourceDefinitionAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDiscoveryConfig)) {
            return false;
        }
        WorkloadDiscoveryConfig other = (WorkloadDiscoveryConfig) obj;
        return Objects.equals(trustedAdvisorIntegrationStatusAsString(), other.trustedAdvisorIntegrationStatusAsString())
                && hasWorkloadResourceDefinition() == other.hasWorkloadResourceDefinition()
                && Objects.equals(workloadResourceDefinitionAsStrings(), other.workloadResourceDefinitionAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("WorkloadDiscoveryConfig")
                .add("TrustedAdvisorIntegrationStatus", trustedAdvisorIntegrationStatusAsString())
                .add("WorkloadResourceDefinition", hasWorkloadResourceDefinition() ? workloadResourceDefinitionAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustedAdvisorIntegrationStatus":
            return Optional.ofNullable(clazz.cast(trustedAdvisorIntegrationStatusAsString()));
        case "WorkloadResourceDefinition":
            return Optional.ofNullable(clazz.cast(workloadResourceDefinitionAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustedAdvisorIntegrationStatus", TRUSTED_ADVISOR_INTEGRATION_STATUS_FIELD);
        map.put("WorkloadResourceDefinition", WORKLOAD_RESOURCE_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadDiscoveryConfig, T> g) {
        return obj -> g.apply((WorkloadDiscoveryConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadDiscoveryConfig> {
        /**
         * <p>
         * Discovery integration status in respect to Trusted Advisor for the workload.
         * </p>
         * 
         * @param trustedAdvisorIntegrationStatus
         *        Discovery integration status in respect to Trusted Advisor for the workload.
         * @see TrustedAdvisorIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedAdvisorIntegrationStatus
         */
        Builder trustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus);

        /**
         * <p>
         * Discovery integration status in respect to Trusted Advisor for the workload.
         * </p>
         * 
         * @param trustedAdvisorIntegrationStatus
         *        Discovery integration status in respect to Trusted Advisor for the workload.
         * @see TrustedAdvisorIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustedAdvisorIntegrationStatus
         */
        Builder trustedAdvisorIntegrationStatus(TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus);

        /**
         * <p>
         * The mode to use for identifying resources associated with the workload.
         * </p>
         * <p>
         * You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * </p>
         * 
         * @param workloadResourceDefinition
         *        The mode to use for identifying resources associated with the workload.</p>
         *        <p>
         *        You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadResourceDefinitionWithStrings(Collection<String> workloadResourceDefinition);

        /**
         * <p>
         * The mode to use for identifying resources associated with the workload.
         * </p>
         * <p>
         * You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * </p>
         * 
         * @param workloadResourceDefinition
         *        The mode to use for identifying resources associated with the workload.</p>
         *        <p>
         *        You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadResourceDefinitionWithStrings(String... workloadResourceDefinition);

        /**
         * <p>
         * The mode to use for identifying resources associated with the workload.
         * </p>
         * <p>
         * You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * </p>
         * 
         * @param workloadResourceDefinition
         *        The mode to use for identifying resources associated with the workload.</p>
         *        <p>
         *        You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadResourceDefinition(Collection<DefinitionType> workloadResourceDefinition);

        /**
         * <p>
         * The mode to use for identifying resources associated with the workload.
         * </p>
         * <p>
         * You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * </p>
         * 
         * @param workloadResourceDefinition
         *        The mode to use for identifying resources associated with the workload.</p>
         *        <p>
         *        You can specify <code>WORKLOAD_METADATA</code>, <code>APP_REGISTRY</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadResourceDefinition(DefinitionType... workloadResourceDefinition);
    }

    static final class BuilderImpl implements Builder {
        private String trustedAdvisorIntegrationStatus;

        private List<String> workloadResourceDefinition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadDiscoveryConfig model) {
            trustedAdvisorIntegrationStatus(model.trustedAdvisorIntegrationStatus);
            workloadResourceDefinitionWithStrings(model.workloadResourceDefinition);
        }

        public final String getTrustedAdvisorIntegrationStatus() {
            return trustedAdvisorIntegrationStatus;
        }

        public final void setTrustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus;
        }

        @Override
        public final Builder trustedAdvisorIntegrationStatus(String trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus = trustedAdvisorIntegrationStatus;
            return this;
        }

        @Override
        public final Builder trustedAdvisorIntegrationStatus(TrustedAdvisorIntegrationStatus trustedAdvisorIntegrationStatus) {
            this.trustedAdvisorIntegrationStatus(trustedAdvisorIntegrationStatus == null ? null : trustedAdvisorIntegrationStatus
                    .toString());
            return this;
        }

        public final Collection<String> getWorkloadResourceDefinition() {
            if (workloadResourceDefinition instanceof SdkAutoConstructList) {
                return null;
            }
            return workloadResourceDefinition;
        }

        public final void setWorkloadResourceDefinition(Collection<String> workloadResourceDefinition) {
            this.workloadResourceDefinition = WorkloadResourceDefinitionCopier.copy(workloadResourceDefinition);
        }

        @Override
        public final Builder workloadResourceDefinitionWithStrings(Collection<String> workloadResourceDefinition) {
            this.workloadResourceDefinition = WorkloadResourceDefinitionCopier.copy(workloadResourceDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadResourceDefinitionWithStrings(String... workloadResourceDefinition) {
            workloadResourceDefinitionWithStrings(Arrays.asList(workloadResourceDefinition));
            return this;
        }

        @Override
        public final Builder workloadResourceDefinition(Collection<DefinitionType> workloadResourceDefinition) {
            this.workloadResourceDefinition = WorkloadResourceDefinitionCopier.copyEnumToString(workloadResourceDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadResourceDefinition(DefinitionType... workloadResourceDefinition) {
            workloadResourceDefinition(Arrays.asList(workloadResourceDefinition));
            return this;
        }

        @Override
        public WorkloadDiscoveryConfig build() {
            return new WorkloadDiscoveryConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
