/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A workload share return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadShare implements SdkPojo, Serializable, ToCopyableBuilder<WorkloadShare.Builder, WorkloadShare> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareId").getter(getter(WorkloadShare::shareId)).setter(setter(Builder::shareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()).build();

    private static final SdkField<String> SHARED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedBy").getter(getter(WorkloadShare::sharedBy)).setter(setter(Builder::sharedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedBy").build()).build();

    private static final SdkField<String> SHARED_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedWith").getter(getter(WorkloadShare::sharedWith)).setter(setter(Builder::sharedWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedWith").build()).build();

    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionType").getter(getter(WorkloadShare::permissionTypeAsString))
            .setter(setter(Builder::permissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(WorkloadShare::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(WorkloadShare::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(WorkloadShare::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD,
            SHARED_BY_FIELD, SHARED_WITH_FIELD, PERMISSION_TYPE_FIELD, STATUS_FIELD, WORKLOAD_NAME_FIELD, WORKLOAD_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String shareId;

    private final String sharedBy;

    private final String sharedWith;

    private final String permissionType;

    private final String status;

    private final String workloadName;

    private final String workloadId;

    private WorkloadShare(BuilderImpl builder) {
        this.shareId = builder.shareId;
        this.sharedBy = builder.sharedBy;
        this.sharedWith = builder.sharedWith;
        this.permissionType = builder.permissionType;
        this.status = builder.status;
        this.workloadName = builder.workloadName;
        this.workloadId = builder.workloadId;
    }

    /**
     * Returns the value of the ShareId property for this object.
     * 
     * @return The value of the ShareId property for this object.
     */
    public final String shareId() {
        return shareId;
    }

    /**
     * Returns the value of the SharedBy property for this object.
     * 
     * @return The value of the SharedBy property for this object.
     */
    public final String sharedBy() {
        return sharedBy;
    }

    /**
     * Returns the value of the SharedWith property for this object.
     * 
     * @return The value of the SharedWith property for this object.
     */
    public final String sharedWith() {
        return sharedWith;
    }

    /**
     * Returns the value of the PermissionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The value of the PermissionType property for this object.
     * @see PermissionType
     */
    public final PermissionType permissionType() {
        return PermissionType.fromValue(permissionType);
    }

    /**
     * Returns the value of the PermissionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The value of the PermissionType property for this object.
     * @see PermissionType
     */
    public final String permissionTypeAsString() {
        return permissionType;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see ShareStatus
     */
    public final ShareStatus status() {
        return ShareStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see ShareStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shareId());
        hashCode = 31 * hashCode + Objects.hashCode(sharedBy());
        hashCode = 31 * hashCode + Objects.hashCode(sharedWith());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadShare)) {
            return false;
        }
        WorkloadShare other = (WorkloadShare) obj;
        return Objects.equals(shareId(), other.shareId()) && Objects.equals(sharedBy(), other.sharedBy())
                && Objects.equals(sharedWith(), other.sharedWith())
                && Objects.equals(permissionTypeAsString(), other.permissionTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(workloadName(), other.workloadName()) && Objects.equals(workloadId(), other.workloadId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadShare").add("ShareId", shareId()).add("SharedBy", sharedBy())
                .add("SharedWith", sharedWith()).add("PermissionType", permissionTypeAsString()).add("Status", statusAsString())
                .add("WorkloadName", workloadName()).add("WorkloadId", workloadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShareId":
            return Optional.ofNullable(clazz.cast(shareId()));
        case "SharedBy":
            return Optional.ofNullable(clazz.cast(sharedBy()));
        case "SharedWith":
            return Optional.ofNullable(clazz.cast(sharedWith()));
        case "PermissionType":
            return Optional.ofNullable(clazz.cast(permissionTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShareId", SHARE_ID_FIELD);
        map.put("SharedBy", SHARED_BY_FIELD);
        map.put("SharedWith", SHARED_WITH_FIELD);
        map.put("PermissionType", PERMISSION_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("WorkloadName", WORKLOAD_NAME_FIELD);
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadShare, T> g) {
        return obj -> g.apply((WorkloadShare) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadShare> {
        /**
         * Sets the value of the ShareId property for this object.
         *
         * @param shareId
         *        The new value for the ShareId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareId(String shareId);

        /**
         * Sets the value of the SharedBy property for this object.
         *
         * @param sharedBy
         *        The new value for the SharedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedBy(String sharedBy);

        /**
         * Sets the value of the SharedWith property for this object.
         *
         * @param sharedWith
         *        The new value for the SharedWith property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedWith(String sharedWith);

        /**
         * Sets the value of the PermissionType property for this object.
         *
         * @param permissionType
         *        The new value for the PermissionType property for this object.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * Sets the value of the PermissionType property for this object.
         *
         * @param permissionType
         *        The new value for the PermissionType property for this object.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(PermissionType permissionType);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(ShareStatus status);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);
    }

    static final class BuilderImpl implements Builder {
        private String shareId;

        private String sharedBy;

        private String sharedWith;

        private String permissionType;

        private String status;

        private String workloadName;

        private String workloadId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadShare model) {
            shareId(model.shareId);
            sharedBy(model.sharedBy);
            sharedWith(model.sharedWith);
            permissionType(model.permissionType);
            status(model.status);
            workloadName(model.workloadName);
            workloadId(model.workloadId);
        }

        public final String getShareId() {
            return shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getSharedBy() {
            return sharedBy;
        }

        public final void setSharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
        }

        @Override
        public final Builder sharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
            return this;
        }

        public final String getSharedWith() {
            return sharedWith;
        }

        public final void setSharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
        }

        @Override
        public final Builder sharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
            return this;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        @Override
        public WorkloadShare build() {
            return new WorkloadShare(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
