/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.QuestionMetric;
import software.amazon.awssdk.services.wellarchitected.model.QuestionMetricsCopier;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PillarMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PillarMetric> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(PillarMetric.getter(PillarMetric::pillarId)).setter(PillarMetric.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(PillarMetric.getter(PillarMetric::riskCountsAsStrings)).setter(PillarMetric.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<QuestionMetric>> QUESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Questions").getter(PillarMetric.getter(PillarMetric::questions)).setter(PillarMetric.setter(Builder::questions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Questions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuestionMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD, RISK_COUNTS_FIELD, QUESTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PillarMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pillarId;
    private final Map<String, Integer> riskCounts;
    private final List<QuestionMetric> questions;

    private PillarMetric(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.riskCounts = builder.riskCounts;
        this.questions = builder.questions;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public final boolean hasQuestions() {
        return this.questions != null && !(this.questions instanceof SdkAutoConstructList);
    }

    public final List<QuestionMetric> questions() {
        return this.questions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuestions() ? this.questions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PillarMetric)) {
            return false;
        }
        PillarMetric other = (PillarMetric)obj;
        return Objects.equals(this.pillarId(), other.pillarId()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings()) && this.hasQuestions() == other.hasQuestions() && Objects.equals(this.questions(), other.questions());
    }

    public final String toString() {
        return ToString.builder((String)"PillarMetric").add("PillarId", (Object)this.pillarId()).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).add("Questions", this.hasQuestions() ? this.questions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
            case "Questions": {
                return Optional.ofNullable(clazz.cast(this.questions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PillarId", PILLAR_ID_FIELD);
        map.put("RiskCounts", RISK_COUNTS_FIELD);
        map.put("Questions", QUESTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PillarMetric, T> g) {
        return obj -> g.apply((PillarMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pillarId;
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();
        private List<QuestionMetric> questions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PillarMetric model) {
            this.pillarId(model.pillarId);
            this.riskCountsWithStrings(model.riskCounts);
            this.questions(model.questions);
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final List<QuestionMetric.Builder> getQuestions() {
            List<QuestionMetric.Builder> result = QuestionMetricsCopier.copyToBuilder(this.questions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuestions(Collection<QuestionMetric.BuilderImpl> questions) {
            this.questions = QuestionMetricsCopier.copyFromBuilder(questions);
        }

        @Override
        public final Builder questions(Collection<QuestionMetric> questions) {
            this.questions = QuestionMetricsCopier.copy(questions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questions(QuestionMetric ... questions) {
            this.questions(Arrays.asList(questions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questions(Consumer<QuestionMetric.Builder> ... questions) {
            this.questions(Stream.of(questions).map(c -> (QuestionMetric)((QuestionMetric.Builder)QuestionMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PillarMetric build() {
            return new PillarMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PillarMetric> {
        public Builder pillarId(String var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);

        public Builder questions(Collection<QuestionMetric> var1);

        public Builder questions(QuestionMetric ... var1);

        public Builder questions(Consumer<QuestionMetric.Builder> ... var1);
    }
}

