/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsResponse extends WisdomResponse implements
        ToCopyableBuilder<GetRecommendationsResponse.Builder, GetRecommendationsResponse> {
    private static final SdkField<List<RecommendationData>> RECOMMENDATIONS_FIELD = SdkField
            .<List<RecommendationData>> builder(MarshallingType.LIST)
            .memberName("recommendations")
            .getter(getter(GetRecommendationsResponse::recommendations))
            .setter(setter(Builder::recommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATIONS_FIELD));

    private final List<RecommendationData> recommendations;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendations = builder.recommendations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Recommendations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendations() {
        return recommendations != null && !(recommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendations} method.
     * </p>
     * 
     * @return The recommendations.
     */
    public final List<RecommendationData> recommendations() {
        return recommendations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendations() ? recommendations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse) obj;
        return hasRecommendations() == other.hasRecommendations() && Objects.equals(recommendations(), other.recommendations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationsResponse")
                .add("Recommendations", hasRecommendations() ? recommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendations":
            return Optional.ofNullable(clazz.cast(recommendations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRecommendationsResponse> {
        /**
         * <p>
         * The recommendations.
         * </p>
         * 
         * @param recommendations
         *        The recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(Collection<RecommendationData> recommendations);

        /**
         * <p>
         * The recommendations.
         * </p>
         * 
         * @param recommendations
         *        The recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(RecommendationData... recommendations);

        /**
         * <p>
         * The recommendations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommendationData>.Builder} avoiding the
         * need to create one manually via {@link List<RecommendationData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationData>.Builder#build()} is called immediately
         * and its result is passed to {@link #recommendations(List<RecommendationData>)}.
         * 
         * @param recommendations
         *        a consumer that will call methods on {@link List<RecommendationData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendations(List<RecommendationData>)
         */
        Builder recommendations(Consumer<RecommendationData.Builder>... recommendations);
    }

    static final class BuilderImpl extends WisdomResponse.BuilderImpl implements Builder {
        private List<RecommendationData> recommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            recommendations(model.recommendations);
        }

        public final List<RecommendationData.Builder> getRecommendations() {
            List<RecommendationData.Builder> result = RecommendationListCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<RecommendationData.BuilderImpl> recommendations) {
            this.recommendations = RecommendationListCopier.copyFromBuilder(recommendations);
        }

        @Override
        @Transient
        public final Builder recommendations(Collection<RecommendationData> recommendations) {
            this.recommendations = RecommendationListCopier.copy(recommendations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendations(RecommendationData... recommendations) {
            recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendations(Consumer<RecommendationData.Builder>... recommendations) {
            recommendations(Stream.of(recommendations).map(c -> RecommendationData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
