/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssistantsResponse extends WisdomResponse implements
        ToCopyableBuilder<ListAssistantsResponse.Builder, ListAssistantsResponse> {
    private static final SdkField<List<AssistantSummary>> ASSISTANT_SUMMARIES_FIELD = SdkField
            .<List<AssistantSummary>> builder(MarshallingType.LIST)
            .memberName("assistantSummaries")
            .getter(getter(ListAssistantsResponse::assistantSummaries))
            .setter(setter(Builder::assistantSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssistantSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssistantSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssistantsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssistantSummary> assistantSummaries;

    private final String nextToken;

    private ListAssistantsResponse(BuilderImpl builder) {
        super(builder);
        this.assistantSummaries = builder.assistantSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssistantSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssistantSummaries() {
        return assistantSummaries != null && !(assistantSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the assistants.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssistantSummaries} method.
     * </p>
     * 
     * @return Information about the assistants.
     */
    public final List<AssistantSummary> assistantSummaries() {
        return assistantSummaries;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssistantSummaries() ? assistantSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssistantsResponse)) {
            return false;
        }
        ListAssistantsResponse other = (ListAssistantsResponse) obj;
        return hasAssistantSummaries() == other.hasAssistantSummaries()
                && Objects.equals(assistantSummaries(), other.assistantSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssistantsResponse")
                .add("AssistantSummaries", hasAssistantSummaries() ? assistantSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantSummaries":
            return Optional.ofNullable(clazz.cast(assistantSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssistantsResponse, T> g) {
        return obj -> g.apply((ListAssistantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssistantsResponse> {
        /**
         * <p>
         * Information about the assistants.
         * </p>
         * 
         * @param assistantSummaries
         *        Information about the assistants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantSummaries(Collection<AssistantSummary> assistantSummaries);

        /**
         * <p>
         * Information about the assistants.
         * </p>
         * 
         * @param assistantSummaries
         *        Information about the assistants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantSummaries(AssistantSummary... assistantSummaries);

        /**
         * <p>
         * Information about the assistants.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssistantSummary>.Builder} avoiding the
         * need to create one manually via {@link List<AssistantSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssistantSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #assistantSummaries(List<AssistantSummary>)}.
         * 
         * @param assistantSummaries
         *        a consumer that will call methods on {@link List<AssistantSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assistantSummaries(List<AssistantSummary>)
         */
        Builder assistantSummaries(Consumer<AssistantSummary.Builder>... assistantSummaries);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WisdomResponse.BuilderImpl implements Builder {
        private List<AssistantSummary> assistantSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssistantsResponse model) {
            super(model);
            assistantSummaries(model.assistantSummaries);
            nextToken(model.nextToken);
        }

        public final List<AssistantSummary.Builder> getAssistantSummaries() {
            List<AssistantSummary.Builder> result = AssistantListCopier.copyToBuilder(this.assistantSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssistantSummaries(Collection<AssistantSummary.BuilderImpl> assistantSummaries) {
            this.assistantSummaries = AssistantListCopier.copyFromBuilder(assistantSummaries);
        }

        @Override
        @Transient
        public final Builder assistantSummaries(Collection<AssistantSummary> assistantSummaries) {
            this.assistantSummaries = AssistantListCopier.copy(assistantSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assistantSummaries(AssistantSummary... assistantSummaries) {
            assistantSummaries(Arrays.asList(assistantSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assistantSummaries(Consumer<AssistantSummary.Builder>... assistantSummaries) {
            assistantSummaries(Stream.of(assistantSummaries).map(c -> AssistantSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssistantsResponse build() {
            return new ListAssistantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
