/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContentResponse extends WisdomResponse implements
        ToCopyableBuilder<CreateContentResponse.Builder, CreateContentResponse> {
    private static final SdkField<ContentData> CONTENT_FIELD = SdkField.<ContentData> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(CreateContentResponse::content)).setter(setter(Builder::content))
            .constructor(ContentData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD));

    private final ContentData content;

    private CreateContentResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
    }

    /**
     * <p>
     * The content.
     * </p>
     * 
     * @return The content.
     */
    public final ContentData content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContentResponse)) {
            return false;
        }
        CreateContentResponse other = (CreateContentResponse) obj;
        return Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContentResponse").add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContentResponse, T> g) {
        return obj -> g.apply((CreateContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateContentResponse> {
        /**
         * <p>
         * The content.
         * </p>
         * 
         * @param content
         *        The content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ContentData content);

        /**
         * <p>
         * The content.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentData.Builder} avoiding the need to
         * create one manually via {@link ContentData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContentData.Builder#build()} is called immediately and its result
         * is passed to {@link #content(ContentData)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ContentData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ContentData)
         */
        default Builder content(Consumer<ContentData.Builder> content) {
            return content(ContentData.builder().applyMutation(content).build());
        }
    }

    static final class BuilderImpl extends WisdomResponse.BuilderImpl implements Builder {
        private ContentData content;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContentResponse model) {
            super(model);
            content(model.content);
        }

        public final ContentData.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ContentData.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ContentData content) {
            this.content = content;
            return this;
        }

        @Override
        public CreateContentResponse build() {
            return new CreateContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
