/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFeedbackResponse extends WisdomResponse implements
        ToCopyableBuilder<PutFeedbackResponse.Builder, PutFeedbackResponse> {
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(PutFeedbackResponse::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(PutFeedbackResponse::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<FeedbackData> FEEDBACK_FIELD = SdkField.<FeedbackData> builder(MarshallingType.SDK_POJO)
            .memberName("feedback").getter(getter(PutFeedbackResponse::feedback)).setter(setter(Builder::feedback))
            .constructor(FeedbackData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feedback").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetId").getter(getter(PutFeedbackResponse::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(PutFeedbackResponse::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ARN_FIELD,
            ASSISTANT_ID_FIELD, FEEDBACK_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD));

    private final String assistantArn;

    private final String assistantId;

    private final FeedbackData feedback;

    private final String targetId;

    private final String targetType;

    private PutFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.assistantArn = builder.assistantArn;
        this.assistantId = builder.assistantId;
        this.feedback = builder.feedback;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Wisdom assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Wisdom assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the Wisdom assistant.
     * </p>
     * 
     * @return The identifier of the Wisdom assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The feedback.
     * </p>
     * 
     * @return The feedback.
     */
    public final FeedbackData feedback() {
        return feedback;
    }

    /**
     * <p>
     * The identifier of a recommendation. or The identifier of the result data.
     * </p>
     * 
     * @return The identifier of a recommendation. or The identifier of the result data.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The type of the targetId for which The feedback. is targeted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the targetId for which The feedback. is targeted.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of the targetId for which The feedback. is targeted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the targetId for which The feedback. is targeted.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(feedback());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackResponse)) {
            return false;
        }
        PutFeedbackResponse other = (PutFeedbackResponse) obj;
        return Objects.equals(assistantArn(), other.assistantArn()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(feedback(), other.feedback()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFeedbackResponse").add("AssistantArn", assistantArn()).add("AssistantId", assistantId())
                .add("Feedback", feedback()).add("TargetId", targetId()).add("TargetType", targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "feedback":
            return Optional.ofNullable(clazz.cast(feedback()));
        case "targetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackResponse, T> g) {
        return obj -> g.apply((PutFeedbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutFeedbackResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Wisdom assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Wisdom assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the Wisdom assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Wisdom assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The feedback.
         * </p>
         * 
         * @param feedback
         *        The feedback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedback(FeedbackData feedback);

        /**
         * <p>
         * The feedback.
         * </p>
         * This is a convenience method that creates an instance of the {@link FeedbackData.Builder} avoiding the need
         * to create one manually via {@link FeedbackData#builder()}.
         *
         * When the {@link Consumer} completes, {@link FeedbackData.Builder#build()} is called immediately and its
         * result is passed to {@link #feedback(FeedbackData)}.
         * 
         * @param feedback
         *        a consumer that will call methods on {@link FeedbackData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #feedback(FeedbackData)
         */
        default Builder feedback(Consumer<FeedbackData.Builder> feedback) {
            return feedback(FeedbackData.builder().applyMutation(feedback).build());
        }

        /**
         * <p>
         * The identifier of a recommendation. or The identifier of the result data.
         * </p>
         * 
         * @param targetId
         *        The identifier of a recommendation. or The identifier of the result data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The type of the targetId for which The feedback. is targeted.
         * </p>
         * 
         * @param targetType
         *        The type of the targetId for which The feedback. is targeted.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of the targetId for which The feedback. is targeted.
         * </p>
         * 
         * @param targetType
         *        The type of the targetId for which The feedback. is targeted.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);
    }

    static final class BuilderImpl extends WisdomResponse.BuilderImpl implements Builder {
        private String assistantArn;

        private String assistantId;

        private FeedbackData feedback;

        private String targetId;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackResponse model) {
            super(model);
            assistantArn(model.assistantArn);
            assistantId(model.assistantId);
            feedback(model.feedback);
            targetId(model.targetId);
            targetType(model.targetType);
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final FeedbackData.Builder getFeedback() {
            return feedback != null ? feedback.toBuilder() : null;
        }

        public final void setFeedback(FeedbackData.BuilderImpl feedback) {
            this.feedback = feedback != null ? feedback.build() : null;
        }

        @Override
        public final Builder feedback(FeedbackData feedback) {
            this.feedback = feedback;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public PutFeedbackResponse build() {
            return new PutFeedbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
