/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContentRequest extends WisdomRequest implements
        ToCopyableBuilder<UpdateContentRequest.Builder, UpdateContentRequest> {
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentId").getter(getter(UpdateContentRequest::contentId)).setter(setter(Builder::contentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("contentId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(UpdateContentRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(UpdateContentRequest::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OVERRIDE_LINK_OUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overrideLinkOutUri").getter(getter(UpdateContentRequest::overrideLinkOutUri))
            .setter(setter(Builder::overrideLinkOutUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLinkOutUri").build())
            .build();

    private static final SdkField<Boolean> REMOVE_OVERRIDE_LINK_OUT_URI_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("removeOverrideLinkOutUri")
            .getter(getter(UpdateContentRequest::removeOverrideLinkOutUri)).setter(setter(Builder::removeOverrideLinkOutUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeOverrideLinkOutUri").build())
            .build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(UpdateContentRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(UpdateContentRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(UpdateContentRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ID_FIELD,
            KNOWLEDGE_BASE_ID_FIELD, METADATA_FIELD, OVERRIDE_LINK_OUT_URI_FIELD, REMOVE_OVERRIDE_LINK_OUT_URI_FIELD,
            REVISION_ID_FIELD, TITLE_FIELD, UPLOAD_ID_FIELD));

    private final String contentId;

    private final String knowledgeBaseId;

    private final Map<String, String> metadata;

    private final String overrideLinkOutUri;

    private final Boolean removeOverrideLinkOutUri;

    private final String revisionId;

    private final String title;

    private final String uploadId;

    private UpdateContentRequest(BuilderImpl builder) {
        super(builder);
        this.contentId = builder.contentId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.metadata = builder.metadata;
        this.overrideLinkOutUri = builder.overrideLinkOutUri;
        this.removeOverrideLinkOutUri = builder.removeOverrideLinkOutUri;
        this.revisionId = builder.revisionId;
        this.title = builder.title;
        this.uploadId = builder.uploadId;
    }

    /**
     * <p>
     * The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String contentId() {
        return contentId;
    }

    /**
     * <p>
     * The the identifier of the knowledge base. Can be either the ID or the ARN
     * </p>
     * 
     * @return The the identifier of the knowledge base. Can be either the ID or the ARN
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing
     * data between an external system and Wisdom, you can store an external version identifier as metadata to utilize
     * for determining drift.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return A key/value map to store attributes without affecting tagging or recommendations. For example, when
     *         synchronizing data between an external system and Wisdom, you can store an external version identifier as
     *         metadata to utilize for determining drift.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this
     * piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set
     * <code>removeOverrideLinkOutUri</code> to true.
     * </p>
     * 
     * @return The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for
     *         this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and
     *         set <code>removeOverrideLinkOutUri</code> to true.
     */
    public final String overrideLinkOutUri() {
        return overrideLinkOutUri;
    }

    /**
     * <p>
     * Unset the existing <code>overrideLinkOutUri</code> if it exists.
     * </p>
     * 
     * @return Unset the existing <code>overrideLinkOutUri</code> if it exists.
     */
    public final Boolean removeOverrideLinkOutUri() {
        return removeOverrideLinkOutUri;
    }

    /**
     * <p>
     * The <code>revisionId</code> of the content resource to update, taken from an earlier call to
     * <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>
     * . If included, this argument acts as an optimistic lock to ensure content was not modified since it was last
     * read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.
     * </p>
     * 
     * @return The <code>revisionId</code> of the content resource to update, taken from an earlier call to
     *         <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or
     *         <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was
     *         not modified since it was last read. If it has been modified, this API throws a
     *         <code>PreconditionFailedException</code>.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The title of the content.
     * </p>
     * 
     * @return The title of the content.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A pointer to the uploaded asset. This value is returned by <a
     * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.
     * </p>
     * 
     * @return A pointer to the uploaded asset. This value is returned by <a
     *         href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
     *         >StartContentUpload</a>.
     */
    public final String uploadId() {
        return uploadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(overrideLinkOutUri());
        hashCode = 31 * hashCode + Objects.hashCode(removeOverrideLinkOutUri());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContentRequest)) {
            return false;
        }
        UpdateContentRequest other = (UpdateContentRequest) obj;
        return Objects.equals(contentId(), other.contentId()) && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata())
                && Objects.equals(overrideLinkOutUri(), other.overrideLinkOutUri())
                && Objects.equals(removeOverrideLinkOutUri(), other.removeOverrideLinkOutUri())
                && Objects.equals(revisionId(), other.revisionId()) && Objects.equals(title(), other.title())
                && Objects.equals(uploadId(), other.uploadId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContentRequest").add("ContentId", contentId()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("Metadata", hasMetadata() ? metadata() : null).add("OverrideLinkOutUri", overrideLinkOutUri())
                .add("RemoveOverrideLinkOutUri", removeOverrideLinkOutUri()).add("RevisionId", revisionId())
                .add("Title", title()).add("UploadId", uploadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentId":
            return Optional.ofNullable(clazz.cast(contentId()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "overrideLinkOutUri":
            return Optional.ofNullable(clazz.cast(overrideLinkOutUri()));
        case "removeOverrideLinkOutUri":
            return Optional.ofNullable(clazz.cast(removeOverrideLinkOutUri()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContentRequest, T> g) {
        return obj -> g.apply((UpdateContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContentRequest> {
        /**
         * <p>
         * The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param contentId
         *        The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentId(String contentId);

        /**
         * <p>
         * The the identifier of the knowledge base. Can be either the ID or the ARN
         * </p>
         * 
         * @param knowledgeBaseId
         *        The the identifier of the knowledge base. Can be either the ID or the ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * A key/value map to store attributes without affecting tagging or recommendations. For example, when
         * synchronizing data between an external system and Wisdom, you can store an external version identifier as
         * metadata to utilize for determining drift.
         * </p>
         * 
         * @param metadata
         *        A key/value map to store attributes without affecting tagging or recommendations. For example, when
         *        synchronizing data between an external system and Wisdom, you can store an external version identifier
         *        as metadata to utilize for determining drift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this
         * piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set
         * <code>removeOverrideLinkOutUri</code> to true.
         * </p>
         * 
         * @param overrideLinkOutUri
         *        The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it
         *        for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this
         *        argument and set <code>removeOverrideLinkOutUri</code> to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideLinkOutUri(String overrideLinkOutUri);

        /**
         * <p>
         * Unset the existing <code>overrideLinkOutUri</code> if it exists.
         * </p>
         * 
         * @param removeOverrideLinkOutUri
         *        Unset the existing <code>overrideLinkOutUri</code> if it exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeOverrideLinkOutUri(Boolean removeOverrideLinkOutUri);

        /**
         * <p>
         * The <code>revisionId</code> of the content resource to update, taken from an earlier call to
         * <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or
         * <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not
         * modified since it was last read. If it has been modified, this API throws a
         * <code>PreconditionFailedException</code>.
         * </p>
         * 
         * @param revisionId
         *        The <code>revisionId</code> of the content resource to update, taken from an earlier call to
         *        <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or
         *        <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was
         *        not modified since it was last read. If it has been modified, this API throws a
         *        <code>PreconditionFailedException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The title of the content.
         * </p>
         * 
         * @param title
         *        The title of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A pointer to the uploaded asset. This value is returned by <a
         * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
         * >StartContentUpload</a>.
         * </p>
         * 
         * @param uploadId
         *        A pointer to the uploaded asset. This value is returned by <a
         *        href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html"
         *        >StartContentUpload</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WisdomRequest.BuilderImpl implements Builder {
        private String contentId;

        private String knowledgeBaseId;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String overrideLinkOutUri;

        private Boolean removeOverrideLinkOutUri;

        private String revisionId;

        private String title;

        private String uploadId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContentRequest model) {
            super(model);
            contentId(model.contentId);
            knowledgeBaseId(model.knowledgeBaseId);
            metadata(model.metadata);
            overrideLinkOutUri(model.overrideLinkOutUri);
            removeOverrideLinkOutUri(model.removeOverrideLinkOutUri);
            revisionId(model.revisionId);
            title(model.title);
            uploadId(model.uploadId);
        }

        public final String getContentId() {
            return contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        @Transient
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        @Transient
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
        }

        @Override
        @Transient
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = ContentMetadataCopier.copy(metadata);
            return this;
        }

        public final String getOverrideLinkOutUri() {
            return overrideLinkOutUri;
        }

        public final void setOverrideLinkOutUri(String overrideLinkOutUri) {
            this.overrideLinkOutUri = overrideLinkOutUri;
        }

        @Override
        @Transient
        public final Builder overrideLinkOutUri(String overrideLinkOutUri) {
            this.overrideLinkOutUri = overrideLinkOutUri;
            return this;
        }

        public final Boolean getRemoveOverrideLinkOutUri() {
            return removeOverrideLinkOutUri;
        }

        public final void setRemoveOverrideLinkOutUri(Boolean removeOverrideLinkOutUri) {
            this.removeOverrideLinkOutUri = removeOverrideLinkOutUri;
        }

        @Override
        @Transient
        public final Builder removeOverrideLinkOutUri(Boolean removeOverrideLinkOutUri) {
            this.removeOverrideLinkOutUri = removeOverrideLinkOutUri;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        @Transient
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContentRequest build() {
            return new UpdateContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
