/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationData implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationData.Builder, RecommendationData> {
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.<Document> builder(MarshallingType.SDK_POJO)
            .memberName("document").getter(getter(RecommendationData::document)).setter(setter(Builder::document))
            .constructor(Document::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(RecommendationData::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final SdkField<String> RELEVANCE_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relevanceLevel").getter(getter(RecommendationData::relevanceLevelAsString))
            .setter(setter(Builder::relevanceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceLevel").build()).build();

    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("relevanceScore").getter(getter(RecommendationData::relevanceScore))
            .setter(setter(Builder::relevanceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD,
            RECOMMENDATION_ID_FIELD, RELEVANCE_LEVEL_FIELD, RELEVANCE_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Document document;

    private final String recommendationId;

    private final String relevanceLevel;

    private final Double relevanceScore;

    private RecommendationData(BuilderImpl builder) {
        this.document = builder.document;
        this.recommendationId = builder.recommendationId;
        this.relevanceLevel = builder.relevanceLevel;
        this.relevanceScore = builder.relevanceScore;
    }

    /**
     * <p>
     * The recommended document.
     * </p>
     * 
     * @return The recommended document.
     */
    public final Document document() {
        return document;
    }

    /**
     * <p>
     * The identifier of the recommendation.
     * </p>
     * 
     * @return The identifier of the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The relevance level of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevanceLevel}
     * will return {@link RelevanceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relevanceLevelAsString}.
     * </p>
     * 
     * @return The relevance level of the recommendation.
     * @see RelevanceLevel
     */
    public final RelevanceLevel relevanceLevel() {
        return RelevanceLevel.fromValue(relevanceLevel);
    }

    /**
     * <p>
     * The relevance level of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevanceLevel}
     * will return {@link RelevanceLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relevanceLevelAsString}.
     * </p>
     * 
     * @return The relevance level of the recommendation.
     * @see RelevanceLevel
     */
    public final String relevanceLevelAsString() {
        return relevanceLevel;
    }

    /**
     * <p>
     * The relevance score of the recommendation.
     * </p>
     * 
     * @return The relevance score of the recommendation.
     */
    public final Double relevanceScore() {
        return relevanceScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(relevanceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relevanceScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationData)) {
            return false;
        }
        RecommendationData other = (RecommendationData) obj;
        return Objects.equals(document(), other.document()) && Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(relevanceLevelAsString(), other.relevanceLevelAsString())
                && Objects.equals(relevanceScore(), other.relevanceScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationData").add("Document", document()).add("RecommendationId", recommendationId())
                .add("RelevanceLevel", relevanceLevelAsString()).add("RelevanceScore", relevanceScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "relevanceLevel":
            return Optional.ofNullable(clazz.cast(relevanceLevelAsString()));
        case "relevanceScore":
            return Optional.ofNullable(clazz.cast(relevanceScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationData, T> g) {
        return obj -> g.apply((RecommendationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationData> {
        /**
         * <p>
         * The recommended document.
         * </p>
         * 
         * @param document
         *        The recommended document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(Document document);

        /**
         * <p>
         * The recommended document.
         * </p>
         * This is a convenience that creates an instance of the {@link Document.Builder} avoiding the need to create
         * one manually via {@link Document#builder()}.
         *
         * When the {@link Consumer} completes, {@link Document.Builder#build()} is called immediately and its result is
         * passed to {@link #document(Document)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link Document.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(Document)
         */
        default Builder document(Consumer<Document.Builder> document) {
            return document(Document.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * The identifier of the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The identifier of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The relevance level of the recommendation.
         * </p>
         * 
         * @param relevanceLevel
         *        The relevance level of the recommendation.
         * @see RelevanceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelevanceLevel
         */
        Builder relevanceLevel(String relevanceLevel);

        /**
         * <p>
         * The relevance level of the recommendation.
         * </p>
         * 
         * @param relevanceLevel
         *        The relevance level of the recommendation.
         * @see RelevanceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelevanceLevel
         */
        Builder relevanceLevel(RelevanceLevel relevanceLevel);

        /**
         * <p>
         * The relevance score of the recommendation.
         * </p>
         * 
         * @param relevanceScore
         *        The relevance score of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevanceScore(Double relevanceScore);
    }

    static final class BuilderImpl implements Builder {
        private Document document;

        private String recommendationId;

        private String relevanceLevel;

        private Double relevanceScore;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationData model) {
            document(model.document);
            recommendationId(model.recommendationId);
            relevanceLevel(model.relevanceLevel);
            relevanceScore(model.relevanceScore);
        }

        public final Document.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        @Transient
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        @Transient
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getRelevanceLevel() {
            return relevanceLevel;
        }

        public final void setRelevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
        }

        @Override
        @Transient
        public final Builder relevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder relevanceLevel(RelevanceLevel relevanceLevel) {
            this.relevanceLevel(relevanceLevel == null ? null : relevanceLevel.toString());
            return this;
        }

        public final Double getRelevanceScore() {
            return relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        @Transient
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        @Override
        public RecommendationData build() {
            return new RecommendationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
