/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionData implements SdkPojo, Serializable, ToCopyableBuilder<SessionData.Builder, SessionData> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SessionData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SessionIntegrationConfiguration> INTEGRATION_CONFIGURATION_FIELD = SdkField
            .<SessionIntegrationConfiguration> builder(MarshallingType.SDK_POJO).memberName("integrationConfiguration")
            .getter(getter(SessionData::integrationConfiguration)).setter(setter(Builder::integrationConfiguration))
            .constructor(SessionIntegrationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SessionData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(SessionData::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(SessionData::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SessionData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            INTEGRATION_CONFIGURATION_FIELD, NAME_FIELD, SESSION_ARN_FIELD, SESSION_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final SessionIntegrationConfiguration integrationConfiguration;

    private final String name;

    private final String sessionArn;

    private final String sessionId;

    private final Map<String, String> tags;

    private SessionData(BuilderImpl builder) {
        this.description = builder.description;
        this.integrationConfiguration = builder.integrationConfiguration;
        this.name = builder.name;
        this.sessionArn = builder.sessionArn;
        this.sessionId = builder.sessionId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The description of the session.
     * </p>
     * 
     * @return The description of the session.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration information for the session integration.
     * </p>
     * 
     * @return The configuration information for the session integration.
     */
    public final SessionIntegrationConfiguration integrationConfiguration() {
        return integrationConfiguration;
    }

    /**
     * <p>
     * The name of the session.
     * </p>
     * 
     * @return The name of the session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * The identifier of the session.
     * </p>
     * 
     * @return The identifier of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(integrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionData)) {
            return false;
        }
        SessionData other = (SessionData) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(integrationConfiguration(), other.integrationConfiguration())
                && Objects.equals(name(), other.name()) && Objects.equals(sessionArn(), other.sessionArn())
                && Objects.equals(sessionId(), other.sessionId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionData").add("Description", description())
                .add("IntegrationConfiguration", integrationConfiguration()).add("Name", name()).add("SessionArn", sessionArn())
                .add("SessionId", sessionId()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "integrationConfiguration":
            return Optional.ofNullable(clazz.cast(integrationConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionData, T> g) {
        return obj -> g.apply((SessionData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionData> {
        /**
         * <p>
         * The description of the session.
         * </p>
         * 
         * @param description
         *        The description of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration information for the session integration.
         * </p>
         * 
         * @param integrationConfiguration
         *        The configuration information for the session integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationConfiguration(SessionIntegrationConfiguration integrationConfiguration);

        /**
         * <p>
         * The configuration information for the session integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionIntegrationConfiguration.Builder}
         * avoiding the need to create one manually via {@link SessionIntegrationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionIntegrationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #integrationConfiguration(SessionIntegrationConfiguration)}.
         * 
         * @param integrationConfiguration
         *        a consumer that will call methods on {@link SessionIntegrationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationConfiguration(SessionIntegrationConfiguration)
         */
        default Builder integrationConfiguration(Consumer<SessionIntegrationConfiguration.Builder> integrationConfiguration) {
            return integrationConfiguration(SessionIntegrationConfiguration.builder().applyMutation(integrationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The name of the session.
         * </p>
         * 
         * @param name
         *        The name of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The identifier of the session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private SessionIntegrationConfiguration integrationConfiguration;

        private String name;

        private String sessionArn;

        private String sessionId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SessionData model) {
            description(model.description);
            integrationConfiguration(model.integrationConfiguration);
            name(model.name);
            sessionArn(model.sessionArn);
            sessionId(model.sessionId);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SessionIntegrationConfiguration.Builder getIntegrationConfiguration() {
            return integrationConfiguration != null ? integrationConfiguration.toBuilder() : null;
        }

        public final void setIntegrationConfiguration(SessionIntegrationConfiguration.BuilderImpl integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration != null ? integrationConfiguration.build() : null;
        }

        @Override
        public final Builder integrationConfiguration(SessionIntegrationConfiguration integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public SessionData build() {
            return new SessionData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
