/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomAsyncClient;
import software.amazon.awssdk.services.wisdom.internal.UserAgentUtils;
import software.amazon.awssdk.services.wisdom.model.ImportJobSummary;
import software.amazon.awssdk.services.wisdom.model.ListImportJobsRequest;
import software.amazon.awssdk.services.wisdom.model.ListImportJobsResponse;

public class ListImportJobsPublisher
implements SdkPublisher<ListImportJobsResponse> {
    private final WisdomAsyncClient client;
    private final ListImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportJobsPublisher(WisdomAsyncClient client, ListImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportJobsPublisher(WisdomAsyncClient client, ListImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportJobSummary> importJobSummaries() {
        Function<ListImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobSummaries() != null) {
                return response.importJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImportJobsResponseFetcher
    implements AsyncPageFetcher<ListImportJobsResponse> {
        private ListImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportJobsResponse> nextPage(ListImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListImportJobsPublisher.this.client.listImportJobs(ListImportJobsPublisher.this.firstRequest);
            }
            return ListImportJobsPublisher.this.client.listImportJobs((ListImportJobsRequest)((Object)ListImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

