/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssistantAssociationResponse extends WisdomResponse implements
        ToCopyableBuilder<GetAssistantAssociationResponse.Builder, GetAssistantAssociationResponse> {
    private static final SdkField<AssistantAssociationData> ASSISTANT_ASSOCIATION_FIELD = SdkField
            .<AssistantAssociationData> builder(MarshallingType.SDK_POJO).memberName("assistantAssociation")
            .getter(getter(GetAssistantAssociationResponse::assistantAssociation)).setter(setter(Builder::assistantAssociation))
            .constructor(AssistantAssociationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AssistantAssociationData assistantAssociation;

    private GetAssistantAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.assistantAssociation = builder.assistantAssociation;
    }

    /**
     * <p>
     * The assistant association.
     * </p>
     * 
     * @return The assistant association.
     */
    public final AssistantAssociationData assistantAssociation() {
        return assistantAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssistantAssociationResponse)) {
            return false;
        }
        GetAssistantAssociationResponse other = (GetAssistantAssociationResponse) obj;
        return Objects.equals(assistantAssociation(), other.assistantAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssistantAssociationResponse").add("AssistantAssociation", assistantAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantAssociation":
            return Optional.ofNullable(clazz.cast(assistantAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantAssociation", ASSISTANT_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssistantAssociationResponse, T> g) {
        return obj -> g.apply((GetAssistantAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAssistantAssociationResponse> {
        /**
         * <p>
         * The assistant association.
         * </p>
         * 
         * @param assistantAssociation
         *        The assistant association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantAssociation(AssistantAssociationData assistantAssociation);

        /**
         * <p>
         * The assistant association.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssistantAssociationData.Builder}
         * avoiding the need to create one manually via {@link AssistantAssociationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssistantAssociationData.Builder#build()} is called immediately
         * and its result is passed to {@link #assistantAssociation(AssistantAssociationData)}.
         * 
         * @param assistantAssociation
         *        a consumer that will call methods on {@link AssistantAssociationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assistantAssociation(AssistantAssociationData)
         */
        default Builder assistantAssociation(Consumer<AssistantAssociationData.Builder> assistantAssociation) {
            return assistantAssociation(AssistantAssociationData.builder().applyMutation(assistantAssociation).build());
        }
    }

    static final class BuilderImpl extends WisdomResponse.BuilderImpl implements Builder {
        private AssistantAssociationData assistantAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssistantAssociationResponse model) {
            super(model);
            assistantAssociation(model.assistantAssociation);
        }

        public final AssistantAssociationData.Builder getAssistantAssociation() {
            return assistantAssociation != null ? assistantAssociation.toBuilder() : null;
        }

        public final void setAssistantAssociation(AssistantAssociationData.BuilderImpl assistantAssociation) {
            this.assistantAssociation = assistantAssociation != null ? assistantAssociation.build() : null;
        }

        @Override
        public final Builder assistantAssociation(AssistantAssociationData assistantAssociation) {
            this.assistantAssociation = assistantAssociation;
            return this;
        }

        @Override
        public GetAssistantAssociationResponse build() {
            return new GetAssistantAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
